/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.blockmodel;

import com.google.common.graph.Graph;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class NodePartition<N> {
    private Map<N, Set<N>> node_partition_map;
    private Collection<Set<N>> node_sets;
    private Graph<N> graph;

    public NodePartition(Graph<N> g, Map<N, Set<N>> partition_map) {
        this.node_partition_map = Collections.unmodifiableMap(partition_map);
        this.graph = g;
    }

    public NodePartition(Graph<N> g, Map<N, Set<N>> partition_map, Collection<Set<N>> node_sets) {
        this.node_partition_map = Collections.unmodifiableMap(partition_map);
        this.node_sets = node_sets;
        this.graph = g;
    }

    public NodePartition(Graph<N> g, Collection<Set<N>> node_sets) {
        this.node_sets = node_sets;
        this.graph = g;
    }

    public Graph<N> getGraph() {
        return this.graph;
    }

    public Map<N, Set<N>> getNodeToPartitionMap() {
        if (this.node_partition_map == null) {
            this.node_partition_map = new HashMap<N, Set<N>>();
            for (Set<N> set : this.node_sets) {
                for (N v : set) {
                    this.node_partition_map.put(v, set);
                }
            }
        }
        return this.node_partition_map;
    }

    public Collection<Set<N>> getNodePartitions() {
        if (this.node_sets == null) {
            this.node_sets = new HashSet<Set<N>>();
            this.node_sets.addAll(this.node_partition_map.values());
        }
        return this.node_sets;
    }

    public int numPartitions() {
        return this.node_sets.size();
    }

    public String toString() {
        return "Partitions: " + this.node_partition_map;
    }
}

