/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.cluster;

import com.google.common.base.Preconditions;
import com.google.common.graph.Network;
import com.google.common.math.Stats;
import edu.uci.ics.jung.algorithms.scoring.VoltageScorer;
import edu.uci.ics.jung.algorithms.util.KMeansClusterer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;

public class VoltageClusterer<N, E> {
    protected int random_sample_count;
    protected KMeansClusterer<N> kmc;
    protected Random rand;
    protected Network<N, E> g;

    public VoltageClusterer(Network<N, E> g, int random_sample_count) {
        Preconditions.checkArgument((random_sample_count >= 1 ? 1 : 0) != 0, (Object)"must generate >= 1 candidates");
        this.random_sample_count = random_sample_count;
        this.kmc = new KMeansClusterer();
        this.rand = new Random();
        this.g = g;
    }

    protected void setRandomSeed(int random_seed) {
        this.rand = new Random(random_seed);
    }

    public Collection<Set<N>> getCommunity(N v) {
        return this.cluster_internal(v, 2);
    }

    public Collection<Set<N>> cluster(int num_clusters) {
        return this.cluster_internal(null, num_clusters);
    }

    protected Collection<Set<N>> cluster_internal(N origin, int num_clusters) {
        ArrayList v_array = new ArrayList(this.g.nodes());
        LinkedList<Set<N>> candidates = new LinkedList<Set<N>>();
        for (int j = 0; j < this.random_sample_count; ++j) {
            N source = origin == null ? v_array.get((int)(this.rand.nextDouble() * (double)v_array.size())) : origin;
            Object target = null;
            while (source == (target = (Object)v_array.get((int)(this.rand.nextDouble() * (double)v_array.size())))) {
            }
            VoltageScorer<Object, E> vs = new VoltageScorer<Object, E>(this.g, source, target);
            vs.evaluate();
            HashMap voltage_ranks = new HashMap();
            for (Object v : this.g.nodes()) {
                voltage_ranks.put(v, new double[]{(Double)vs.getNodeScore(v)});
            }
            this.addTwoCandidateClusters(candidates, voltage_ranks);
        }
        LinkedList<Set<N>> clusters = new LinkedList<Set<N>>();
        HashSet remaining = new HashSet(this.g.nodes());
        List<N> seed_candidates = this.getSeedCandidates(candidates);
        int seed_index = 0;
        for (int j = 0; j < num_clusters - 1 && !remaining.isEmpty(); ++j) {
            N seed;
            if (seed_index == 0 && origin != null) {
                seed = origin;
            } else {
                while (!remaining.contains(seed = seed_candidates.get(seed_index++))) {
                }
            }
            Map<N, double[]> occur_counts = this.getObjectCounts(candidates, seed);
            if (occur_counts.size() < 2) break;
            try {
                Collection<Map<N, double[]>> high_low = this.kmc.cluster(occur_counts, 2);
                Iterator<Map<N, double[]>> h_iter = high_low.iterator();
                Map<N, double[]> cluster1 = h_iter.next();
                Map<N, double[]> cluster2 = h_iter.next();
                double[] centroid1 = VoltageClusterer.meansOf(cluster1.values());
                double[] centroid2 = VoltageClusterer.meansOf(cluster2.values());
                Set<N> new_cluster = centroid1[0] >= centroid2[0] ? cluster1.keySet() : cluster2.keySet();
                for (Set set : candidates) {
                    set.removeAll(new_cluster);
                }
                clusters.add(new_cluster);
                remaining.removeAll(new_cluster);
                continue;
            }
            catch (KMeansClusterer.NotEnoughClustersException nece) {
                break;
            }
        }
        if (!remaining.isEmpty()) {
            clusters.add(remaining);
        }
        return clusters;
    }

    private static double[] meansOf(Collection<double[]> collectionOfDoubleArrays) {
        double[] result = new double[collectionOfDoubleArrays.size()];
        int index = 0;
        for (double[] array : collectionOfDoubleArrays) {
            result[index++] = Stats.meanOf((double[])array);
        }
        return result;
    }

    protected void addTwoCandidateClusters(LinkedList<Set<N>> candidates, Map<N, double[]> voltage_ranks) {
        try {
            boolean b12;
            ArrayList<Map<N, double[]>> clusters = new ArrayList<Map<N, double[]>>(this.kmc.cluster(voltage_ranks, 3));
            boolean b01 = ((Map)clusters.get(0)).size() > ((Map)clusters.get(1)).size();
            boolean b02 = ((Map)clusters.get(0)).size() > ((Map)clusters.get(2)).size();
            boolean bl = b12 = ((Map)clusters.get(1)).size() > ((Map)clusters.get(2)).size();
            if (b01 && b02) {
                candidates.add(((Map)clusters.get(1)).keySet());
                candidates.add(((Map)clusters.get(2)).keySet());
            } else if (!b01 && b12) {
                candidates.add(((Map)clusters.get(0)).keySet());
                candidates.add(((Map)clusters.get(2)).keySet());
            } else if (!b02 && !b12) {
                candidates.add(((Map)clusters.get(0)).keySet());
                candidates.add(((Map)clusters.get(1)).keySet());
            }
        }
        catch (KMeansClusterer.NotEnoughClustersException notEnoughClustersException) {
            // empty catch block
        }
    }

    protected void addOneCandidateCluster(LinkedList<Set<N>> candidates, Map<N, double[]> voltage_ranks) {
        try {
            ArrayList<Map<N, double[]>> clusters = new ArrayList<Map<N, double[]>>(this.kmc.cluster(voltage_ranks, 2));
            if (((Map)clusters.get(0)).size() < ((Map)clusters.get(1)).size()) {
                candidates.add(((Map)clusters.get(0)).keySet());
            } else {
                candidates.add(((Map)clusters.get(1)).keySet());
            }
        }
        catch (KMeansClusterer.NotEnoughClustersException notEnoughClustersException) {
            // empty catch block
        }
    }

    protected List<N> getSeedCandidates(Collection<Set<N>> candidates) {
        Map<Object, double[]> occur_counts = this.getObjectCounts(candidates, null);
        ArrayList<Object> occurrences = new ArrayList<Object>(occur_counts.keySet());
        Collections.sort(occurrences, new MapValueArrayComparator(occur_counts));
        for (int i = 0; i < occurrences.size(); ++i) {
            System.out.println(occur_counts.get(occurrences.get(i))[0]);
        }
        return occurrences;
    }

    protected Map<N, double[]> getObjectCounts(Collection<Set<N>> candidates, N seed) {
        HashMap occur_counts = new HashMap();
        for (Object e : this.g.nodes()) {
            occur_counts.put(e, new double[]{0.0});
        }
        for (Set set : candidates) {
            if (seed == null) {
                System.out.println(set.size());
            }
            if (seed != null && !set.contains(seed)) continue;
            for (Object element : set) {
                double[] count = (double[])occur_counts.get(element);
                count[0] = count[0] + 1.0;
            }
        }
        if (seed == null) {
            System.out.println("occur_counts size: " + occur_counts.size());
            for (Object object : occur_counts.keySet()) {
                System.out.println(((double[])occur_counts.get(object))[0]);
            }
        }
        return occur_counts;
    }

    protected class MapValueArrayComparator
    implements Comparator<N> {
        private Map<N, double[]> map;

        protected MapValueArrayComparator(Map<N, double[]> map) {
            this.map = map;
        }

        @Override
        public int compare(N o1, N o2) {
            double[] count1;
            double[] count0 = this.map.get(o1);
            if (count0[0] < (count1 = this.map.get(o2))[0]) {
                return 1;
            }
            if (count0[0] > count1[0]) {
                return -1;
            }
            return 0;
        }
    }
}

