/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.generators.random;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.graph.MutableNetwork;
import com.google.common.graph.NetworkBuilder;
import edu.uci.ics.jung.algorithms.util.WeightedChoice;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.function.Supplier;

public class BarabasiAlbertGenerator<N, E> {
    private int mNumEdgesToAttachPerStep;
    private int mElapsedTimeSteps;
    private Random mRandom;
    protected Supplier<N> nodeFactory;
    protected Supplier<E> edgeFactory;
    protected ImmutableSet<N> seedNodes;
    private MutableNetwork<N, E> graph;

    public BarabasiAlbertGenerator(NetworkBuilder<Object, Object> graphBuilder, Supplier<N> nodeFactory, Supplier<E> edgeFactory, int init_nodes, int numEdgesToAttach, int seed) {
        this.nodeFactory = (Supplier)Preconditions.checkNotNull(nodeFactory);
        this.edgeFactory = (Supplier)Preconditions.checkNotNull(edgeFactory);
        Preconditions.checkArgument((init_nodes > 0 ? 1 : 0) != 0, (Object)"Number of initial unconnected 'seed' nodes must be positive");
        Preconditions.checkArgument((numEdgesToAttach > 0 ? 1 : 0) != 0, (Object)"Number of edges to attach at each time step must be positive");
        Preconditions.checkArgument((numEdgesToAttach <= init_nodes ? 1 : 0) != 0, (Object)"Number of edges to attach at each time step must be <= the number of initial nodes");
        this.graph = graphBuilder.build();
        this.mNumEdgesToAttachPerStep = numEdgesToAttach;
        this.mRandom = new Random(seed);
        this.nodeFactory = nodeFactory;
        this.initialize(init_nodes);
    }

    public BarabasiAlbertGenerator(NetworkBuilder<Object, Object> graphBuilder, Supplier<N> nodeFactory, Supplier<E> edgeFactory, int init_nodes, int numEdgesToAttach) {
        this(graphBuilder, nodeFactory, edgeFactory, init_nodes, numEdgesToAttach, (int)System.currentTimeMillis());
    }

    private void initialize(int init_nodes) {
        ImmutableSet.Builder seedBuilder = ImmutableSet.builder();
        for (int i = 0; i < init_nodes; ++i) {
            N v = this.nodeFactory.get();
            seedBuilder.add(v);
            this.graph.addNode(v);
        }
        this.seedNodes = seedBuilder.build();
        this.mElapsedTimeSteps = 0;
    }

    private WeightedChoice<N> buildNodeProbabilities() {
        HashMap item_weights = new HashMap();
        for (Object v : this.graph.nodes()) {
            double denominator;
            double degree;
            if (this.graph.isDirected()) {
                degree = this.graph.inDegree(v);
                denominator = this.graph.edges().size() + this.graph.nodes().size();
            } else {
                degree = this.graph.degree(v);
                denominator = 2 * this.graph.edges().size() + this.graph.nodes().size();
            }
            double prob = (degree + 1.0) / denominator;
            item_weights.put(v, prob);
        }
        WeightedChoice nodeProbabilities = new WeightedChoice(item_weights, this.mRandom);
        return nodeProbabilities;
    }

    private List<N> generateAdjacentNodes(int edgesToAdd) {
        Preconditions.checkArgument((edgesToAdd >= 1 ? 1 : 0) != 0);
        WeightedChoice<N> nodeChooser = this.buildNodeProbabilities();
        ArrayList<N> adjacentNodes = new ArrayList<N>(edgesToAdd);
        while (adjacentNodes.size() < edgesToAdd) {
            N attach_point = nodeChooser.nextItem();
            if (!this.graph.allowsParallelEdges() && adjacentNodes.contains(attach_point)) continue;
            adjacentNodes.add(attach_point);
        }
        return adjacentNodes;
    }

    public void evolveGraph(int numTimeSteps) {
        for (int i = 0; i < numTimeSteps; ++i) {
            N newNode = this.nodeFactory.get();
            List<N> adjacentNodes = this.generateAdjacentNodes(this.mNumEdgesToAttachPerStep);
            this.graph.addNode(newNode);
            for (N node : adjacentNodes) {
                this.graph.addEdge(newNode, node, this.edgeFactory.get());
            }
            ++this.mElapsedTimeSteps;
        }
    }

    public int numIterations() {
        return this.mElapsedTimeSteps;
    }

    public MutableNetwork<N, E> get() {
        return this.graph;
    }

    public ImmutableSet<N> seedNodes() {
        return this.seedNodes;
    }
}

