/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.metrics;

import com.google.common.collect.ImmutableMap;
import com.google.common.graph.Graph;

public class Metrics {
    public static <N> ImmutableMap<N, Double> clusteringCoefficients(Graph<N> graph) {
        ImmutableMap.Builder coefficients = ImmutableMap.builder();
        for (Object v : graph.nodes()) {
            int n = graph.degree(v);
            if (n < 2) {
                coefficients.put(v, (Object)new Double(0.0));
                continue;
            }
            int edgeCount = 0;
            for (Object w : graph.adjacentNodes(v)) {
                if (w.equals(v)) continue;
                for (Object x : graph.adjacentNodes(v)) {
                    if (w.equals(x) || !graph.adjacentNodes(w).contains(x)) continue;
                    ++edgeCount;
                }
            }
            double possible_edges = (double)(n * (n - 1)) / 2.0;
            coefficients.put(v, (Object)new Double((double)edgeCount / possible_edges));
        }
        return coefficients.build();
    }
}

