/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.scoring;

import com.google.common.base.Preconditions;
import com.google.common.graph.Network;
import edu.uci.ics.jung.algorithms.scoring.NodeScorer;
import edu.uci.ics.jung.algorithms.scoring.util.DelegateToEdgeTransformer;
import edu.uci.ics.jung.algorithms.scoring.util.VEPair;
import edu.uci.ics.jung.algorithms.util.IterativeContext;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;

public abstract class AbstractIterativeScorer<N, E, T>
implements IterativeContext,
NodeScorer<N, T> {
    protected int max_iterations;
    protected double tolerance;
    protected Network<N, E> graph;
    protected int total_iterations;
    protected Function<VEPair<N, E>, ? extends Number> edge_weights;
    private Map<N, T> output;
    private Map<N, T> current_values;
    private boolean accept_disconnected_graph;
    protected double max_delta;

    protected void setOutputValue(N v, T value) {
        this.output.put(v, value);
    }

    protected T getOutputValue(N v) {
        return this.output.get(v);
    }

    protected T getCurrentValue(N v) {
        return this.current_values.get(v);
    }

    protected void setCurrentValue(N v, T value) {
        this.current_values.put(v, value);
    }

    public AbstractIterativeScorer(Network<N, E> g, Function<? super E, ? extends Number> edge_weights) {
        this.graph = g;
        this.max_iterations = 100;
        this.tolerance = 0.001;
        this.accept_disconnected_graph = true;
        this.setEdgeWeights(edge_weights);
    }

    public AbstractIterativeScorer(Network<N, E> g) {
        this.graph = g;
        this.max_iterations = 100;
        this.tolerance = 0.001;
        this.accept_disconnected_graph = true;
    }

    protected void initialize() {
        this.total_iterations = 0;
        this.max_delta = Double.MIN_VALUE;
        this.current_values = new HashMap<N, T>();
        this.output = new HashMap<N, T>();
    }

    public void evaluate() {
        do {
            this.step();
        } while (!this.done());
    }

    @Override
    public boolean done() {
        return this.total_iterations >= this.max_iterations || this.max_delta < this.tolerance;
    }

    @Override
    public void step() {
        this.swapOutputForCurrent();
        this.max_delta = 0.0;
        for (Object v : this.graph.nodes()) {
            double diff = this.update(v);
            this.updateMaxDelta(v, diff);
        }
        ++this.total_iterations;
        this.afterStep();
    }

    protected void swapOutputForCurrent() {
        Map<N, T> tmp = this.output;
        this.output = this.current_values;
        this.current_values = tmp;
    }

    protected abstract double update(N var1);

    protected void updateMaxDelta(N v, double diff) {
        this.max_delta = Math.max(this.max_delta, diff);
    }

    protected void afterStep() {
    }

    @Override
    public T getNodeScore(N v) {
        Preconditions.checkArgument((boolean)this.graph.nodes().contains(v), (String)"Node %s not an element of this graph", (Object)v.toString());
        return this.output.get(v);
    }

    @Override
    public Map<N, T> nodeScores() {
        return Collections.unmodifiableMap(this.output);
    }

    public int getMaxIterations() {
        return this.max_iterations;
    }

    public int getIterations() {
        return this.total_iterations;
    }

    public void setMaxIterations(int max_iterations) {
        this.max_iterations = max_iterations;
    }

    public double getTolerance() {
        return this.tolerance;
    }

    public void setTolerance(double tolerance) {
        this.tolerance = tolerance;
    }

    public Function<VEPair<N, E>, ? extends Number> getEdgeWeights() {
        return this.edge_weights;
    }

    public void setEdgeWeights(Function<? super E, ? extends Number> edge_weights) {
        this.edge_weights = new DelegateToEdgeTransformer<N, E>(edge_weights);
    }

    protected Number getEdgeWeight(N v, E e) {
        return this.edge_weights.apply(new VEPair<N, E>(v, e));
    }

    protected void collectDisappearingPotential(N v) {
    }

    public void acceptDisconnectedGraph(boolean accept) {
        this.accept_disconnected_graph = accept;
    }

    public boolean isDisconnectedGraphOK() {
        return this.accept_disconnected_graph;
    }
}

