/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.scoring;

import com.google.common.base.Preconditions;
import com.google.common.graph.Network;
import edu.uci.ics.jung.algorithms.scoring.EdgeScorer;
import edu.uci.ics.jung.algorithms.scoring.NodeScorer;
import edu.uci.ics.jung.algorithms.util.MapBinaryHeap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.function.Function;

public class BetweennessCentrality<N, E>
implements NodeScorer<N, Double>,
EdgeScorer<E, Double> {
    protected Network<N, E> graph;
    protected Map<N, Double> node_scores;
    protected Map<E, Double> edge_scores;
    protected Map<N, BetweennessData> node_data;

    public BetweennessCentrality(Network<N, E> graph) {
        this.initialize(graph);
        this.computeBetweenness(new LinkedList(), n -> 1);
    }

    public BetweennessCentrality(Network<N, E> graph, Function<? super E, ? extends Number> edge_weights) {
        for (Object e : graph.edges()) {
            double e_weight = edge_weights.apply(e).doubleValue();
            Preconditions.checkArgument((e_weight >= 0.0 ? 1 : 0) != 0, (String)"Weight for edge '%s' is < 0: %d", e, (Object)e_weight);
        }
        this.initialize(graph);
        this.computeBetweenness(new MapBinaryHeap((v1, v2) -> Double.compare(this.node_data.get((Object)v1).distance, this.node_data.get((Object)v2).distance)), edge_weights);
    }

    protected void initialize(Network<N, E> graph) {
        this.graph = graph;
        this.node_scores = new HashMap<N, Double>();
        this.edge_scores = new HashMap<E, Double>();
        this.node_data = new HashMap<N, BetweennessData>();
        for (Object v : graph.nodes()) {
            this.node_scores.put(v, 0.0);
        }
        for (Object e : graph.edges()) {
            this.edge_scores.put(e, 0.0);
        }
    }

    protected void computeBetweenness(Queue<N> queue, Function<? super E, ? extends Number> edge_weights) {
        for (Object v : this.graph.nodes()) {
            for (Object s : this.graph.nodes()) {
                this.node_data.put(s, new BetweennessData());
            }
            this.node_data.get(v).numSPs = 1.0;
            this.node_data.get(v).distance = 0.0;
            ArrayDeque<N> stack = new ArrayDeque<N>();
            queue.offer(v);
            while (!queue.isEmpty()) {
                double x_potential_dist;
                BetweennessData x_data;
                Object x;
                N w = queue.poll();
                stack.push(w);
                BetweennessData w_data = this.node_data.get(w);
                for (Object e : this.graph.outEdges(w)) {
                    x = this.graph.incidentNodes(e).adjacentNode(w);
                    if (x.equals(w)) continue;
                    double wx_weight = edge_weights.apply(e).doubleValue();
                    x_data = this.node_data.get(x);
                    x_potential_dist = w_data.distance + wx_weight;
                    if (x_data.distance < 0.0) {
                        x_data.distance = x_potential_dist;
                        queue.offer(x);
                    }
                    if (!(x_data.distance > x_potential_dist)) continue;
                    x_data.distance = x_potential_dist;
                    x_data.incomingEdges.clear();
                    ((MapBinaryHeap)queue).update(x);
                }
                for (Object e : this.graph.outEdges(w)) {
                    x = this.graph.incidentNodes(e).adjacentNode(w);
                    if (x.equals(w)) continue;
                    double e_weight = edge_weights.apply(e).doubleValue();
                    x_data = this.node_data.get(x);
                    x_potential_dist = w_data.distance + e_weight;
                    if (x_data.distance != x_potential_dist) continue;
                    x_data.numSPs += w_data.numSPs;
                    x_data.incomingEdges.add(e);
                }
            }
            while (!stack.isEmpty()) {
                Object x = stack.pop();
                for (Object e : this.node_data.get(x).incomingEdges) {
                    Object w = this.graph.incidentNodes(e).adjacentNode(x);
                    double partialDependency = this.node_data.get((Object)w).numSPs / this.node_data.get(x).numSPs * (1.0 + this.node_data.get(x).dependency);
                    this.node_data.get((Object)w).dependency += partialDependency;
                    double e_score = this.edge_scores.get(e);
                    this.edge_scores.put(e, e_score + partialDependency);
                }
                if (x.equals(v)) continue;
                double x_score = this.node_scores.get(x);
                this.node_scores.put(x, x_score += this.node_data.get(x).dependency);
            }
        }
        if (!this.graph.isDirected()) {
            for (Object v : this.graph.nodes()) {
                double v_score = this.node_scores.get(v);
                this.node_scores.put(v, v_score /= 2.0);
            }
            for (Object e : this.graph.edges()) {
                double e_score = this.edge_scores.get(e);
                this.edge_scores.put(e, e_score /= 2.0);
            }
        }
        this.node_data.clear();
    }

    @Override
    public Double getNodeScore(N v) {
        return this.node_scores.get(v);
    }

    @Override
    public Double getEdgeScore(E e) {
        return this.edge_scores.get(e);
    }

    @Override
    public Map<N, Double> nodeScores() {
        return Collections.unmodifiableMap(this.node_scores);
    }

    @Override
    public Map<E, Double> edgeScores() {
        return Collections.unmodifiableMap(this.edge_scores);
    }

    private class BetweennessData {
        double distance = -1.0;
        double numSPs = 0.0;
        List<E> incomingEdges = new ArrayList();
        double dependency = 0.0;

        BetweennessData() {
        }

        public String toString() {
            return "[d:" + this.distance + ", sp:" + this.numSPs + ", p:" + this.incomingEdges + ", d:" + this.dependency + "]\n";
        }
    }
}

