/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.scoring;

import com.google.common.base.Preconditions;
import com.google.common.graph.Network;
import edu.uci.ics.jung.algorithms.scoring.AbstractIterativeScorerWithPriors;
import edu.uci.ics.jung.algorithms.scoring.util.UniformDegreeWeight;
import java.util.function.Function;

public class PageRankWithPriors<N, E>
extends AbstractIterativeScorerWithPriors<N, E, Double> {
    protected double disappearing_potential = 0.0;

    public PageRankWithPriors(Network<N, E> graph, Function<E, ? extends Number> edge_weights, Function<N, Double> node_priors, double alpha) {
        super(graph, edge_weights, node_priors, alpha);
    }

    public PageRankWithPriors(Network<N, E> graph, Function<N, Double> node_priors, double alpha) {
        super(graph, node_priors, alpha);
        this.edge_weights = new UniformDegreeWeight<N, E>(graph);
    }

    @Override
    public double update(N v) {
        this.collectDisappearingPotential(v);
        double v_input = 0.0;
        for (Object u : this.graph.predecessors(v)) {
            for (Object e : this.graph.edgesConnecting(u, v)) {
                v_input += (Double)this.getCurrentValue(u) * this.getEdgeWeight(u, e).doubleValue();
            }
        }
        double new_value = this.alpha > 0.0 ? v_input * (1.0 - this.alpha) + (Double)this.getNodePrior(v) * this.alpha : v_input;
        this.setOutputValue(v, new_value);
        return Math.abs((Double)this.getCurrentValue(v) - new_value);
    }

    @Override
    protected void afterStep() {
        if (this.disappearing_potential > 0.0) {
            for (Object v : this.graph.nodes()) {
                this.setOutputValue(v, (Double)this.getOutputValue(v) + (1.0 - this.alpha) * (this.disappearing_potential * (Double)this.getNodePrior(v)));
            }
            this.disappearing_potential = 0.0;
        }
        super.afterStep();
    }

    @Override
    protected void collectDisappearingPotential(N v) {
        if (this.graph.outDegree(v) == 0) {
            Preconditions.checkState((boolean)this.isDisconnectedGraphOK(), (Object)("Outdegree of " + v + " must be > 0"));
            this.disappearing_potential += ((Double)this.getCurrentValue(v)).doubleValue();
        }
    }
}

