/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.scoring;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.common.graph.Network;
import edu.uci.ics.jung.algorithms.scoring.AbstractIterativeScorer;
import edu.uci.ics.jung.algorithms.scoring.NodeScorer;
import edu.uci.ics.jung.algorithms.scoring.util.UniformDegreeWeight;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;

public class VoltageScorer<N, E>
extends AbstractIterativeScorer<N, E, Double>
implements NodeScorer<N, Double> {
    protected Map<N, ? extends Number> source_voltages;
    protected Set<N> sinks;

    public VoltageScorer(Network<N, E> g, Function<? super E, ? extends Number> edge_weights, Map<N, ? extends Number> source_voltages, Set<N> sinks) {
        super(g, edge_weights);
        this.source_voltages = source_voltages;
        this.sinks = sinks;
        this.initialize();
    }

    public VoltageScorer(Network<N, E> g, Function<? super E, ? extends Number> edge_weights, Set<N> sources, Set<N> sinks) {
        super(g, edge_weights);
        HashMap<N, Number> unit_voltages = new HashMap<N, Number>();
        for (N v : sources) {
            unit_voltages.put(v, new Double(1.0));
        }
        this.source_voltages = unit_voltages;
        this.sinks = sinks;
        this.initialize();
    }

    public VoltageScorer(Network<N, E> g, Set<N> sources, Set<N> sinks) {
        super(g);
        HashMap<N, Number> unit_voltages = new HashMap<N, Number>();
        for (N v : sources) {
            unit_voltages.put(v, new Double(1.0));
        }
        this.source_voltages = unit_voltages;
        this.sinks = sinks;
        this.initialize();
    }

    public VoltageScorer(Network<N, E> g, Map<N, ? extends Number> source_voltages, Set<N> sinks) {
        super(g);
        this.source_voltages = source_voltages;
        this.sinks = sinks;
        this.edge_weights = new UniformDegreeWeight<N, E>(g);
        this.initialize();
    }

    public VoltageScorer(Network<N, E> g, Function<? super E, ? extends Number> edge_weights, N source, N sink) {
        this((Network<ImmutableSet, E>)g, (Function<E, Number>)edge_weights, (ImmutableSet)ImmutableMap.of(source, (Object)1.0), ImmutableSet.of(sink));
        this.initialize();
    }

    public VoltageScorer(Network<N, E> g, N source, N sink) {
        this((Network<ImmutableSet, E>)g, (ImmutableSet)ImmutableMap.of(source, (Object)1.0), ImmutableSet.of(sink));
        this.initialize();
    }

    @Override
    public void initialize() {
        super.initialize();
        Preconditions.checkArgument((!this.source_voltages.isEmpty() ? 1 : 0) != 0, (Object)"Source voltages must be non-empty");
        Preconditions.checkArgument((!this.sinks.isEmpty() ? 1 : 0) != 0, (Object)"Sinks must be non-empty");
        Preconditions.checkArgument((boolean)Sets.intersection(this.source_voltages.keySet(), this.sinks).isEmpty(), (Object)"Sources and sinks must be disjoint");
        Preconditions.checkArgument((boolean)this.graph.nodes().containsAll(this.source_voltages.keySet()), (Object)"Sources must all be elements of the graph");
        Preconditions.checkArgument((boolean)this.graph.nodes().containsAll(this.sinks), (Object)"Sinks must all be elements of the graph");
        for (Map.Entry<N, Number> entry : this.source_voltages.entrySet()) {
            N v = entry.getKey();
            Preconditions.checkArgument((!this.sinks.contains(v) ? 1 : 0) != 0, (Object)("Node " + v + " is incorrectly specified as both source and sink"));
            double value = entry.getValue().doubleValue();
            Preconditions.checkArgument((value > 0.0 ? 1 : 0) != 0, (Object)("Source node " + v + " has non-positive voltage " + value));
        }
        for (Map.Entry<Object, Number> v : this.graph.nodes()) {
            if (this.source_voltages.containsKey(v)) {
                this.setOutputValue(v, this.source_voltages.get(v).doubleValue());
                continue;
            }
            this.setOutputValue(v, 0.0);
        }
    }

    @Override
    public double update(N v) {
        Number source_volts = this.source_voltages.get(v);
        if (source_volts != null) {
            this.setOutputValue(v, source_volts.doubleValue());
            return 0.0;
        }
        if (this.sinks.contains(v)) {
            this.setOutputValue(v, 0.0);
            return 0.0;
        }
        double voltage_sum = 0.0;
        double weight_sum = 0.0;
        for (Object u : this.graph.predecessors(v)) {
            for (Object e : this.graph.edgesConnecting(u, v)) {
                double weight = this.getEdgeWeight(u, e).doubleValue();
                voltage_sum += (Double)this.getCurrentValue(u) * weight;
                weight_sum += weight;
            }
        }
        if (voltage_sum == 0.0 || weight_sum == 0.0) {
            this.setOutputValue(v, 0.0);
            return (Double)this.getCurrentValue(v);
        }
        double outputValue = voltage_sum / weight_sum;
        this.setOutputValue(v, outputValue);
        return Math.abs((Double)this.getCurrentValue(v) - outputValue);
    }
}

