/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.shortestpath;

import com.google.common.base.Preconditions;
import com.google.common.graph.Network;
import edu.uci.ics.jung.algorithms.shortestpath.Distance;
import edu.uci.ics.jung.algorithms.util.MapBinaryHeap;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;

public class DijkstraDistance<N, E>
implements Distance<N> {
    protected Network<N, E> g;
    protected Function<? super E, ? extends Number> nev;
    protected Map<N, SourceData> sourceMap;
    protected boolean cached;
    protected double maxDistance;
    protected int maxTargets;

    public DijkstraDistance(Network<N, E> g, Function<? super E, ? extends Number> nev, boolean cached) {
        this.g = g;
        this.nev = nev;
        this.sourceMap = new HashMap<N, SourceData>();
        this.cached = cached;
        this.maxDistance = Double.POSITIVE_INFINITY;
        this.maxTargets = Integer.MAX_VALUE;
    }

    public DijkstraDistance(Network<N, E> g, Function<? super E, ? extends Number> nev) {
        this(g, nev, true);
    }

    public DijkstraDistance(Network<N, E> g) {
        this(g, e -> 1, true);
    }

    public DijkstraDistance(Network<N, E> g, boolean cached) {
        this(g, e -> 1, cached);
    }

    protected LinkedHashMap<N, Number> singleSourceShortestPath(N source, Collection<N> targets, int numDistances) {
        SourceData sd = this.getSourceData(source);
        HashSet<N> toGet = new HashSet<N>();
        if (targets != null) {
            toGet.addAll(targets);
            Set existingDistances = sd.distances.keySet();
            for (N o : targets) {
                if (!existingDistances.contains(o)) continue;
                toGet.remove(o);
            }
        }
        if (sd.reachedMax || targets != null && toGet.isEmpty() || sd.distances.size() >= numDistances) {
            return sd.distances;
        }
        while (!(sd.unknownNodes.isEmpty() || sd.distances.size() >= numDistances && toGet.isEmpty())) {
            Map.Entry p = sd.getNextNode();
            Object v = p.getKey();
            double vDist = p.getValue().doubleValue();
            toGet.remove(v);
            if (vDist > this.maxDistance) {
                sd.restoreNode(v, vDist);
                sd.reachedMax = true;
                break;
            }
            sd.distanceReached = vDist;
            if (sd.distances.size() >= this.maxTargets) {
                sd.reachedMax = true;
                break;
            }
            for (Object w : this.g.successors(v)) {
                for (Object e : this.g.edgesConnecting(v, w)) {
                    if (sd.distances.containsKey(w)) continue;
                    double edgeWeight = this.nev.apply(e).doubleValue();
                    Preconditions.checkArgument((edgeWeight >= 0.0 ? 1 : 0) != 0, (String)"encountered negative edge weight %s for edge %s", (Object)this.nev.apply(e), e);
                    double newDist = vDist + edgeWeight;
                    if (!sd.estimatedDistances.containsKey(w)) {
                        sd.createRecord(w, e, newDist);
                        continue;
                    }
                    double wDist = (Double)sd.estimatedDistances.get(w);
                    if (!(newDist < wDist)) continue;
                    sd.update(w, e, newDist);
                }
            }
        }
        return sd.distances;
    }

    protected SourceData getSourceData(N source) {
        SourceData sd = this.sourceMap.get(source);
        if (sd == null) {
            sd = new SourceData(source);
        }
        return sd;
    }

    @Override
    public Number getDistance(N source, N target) {
        Preconditions.checkArgument((boolean)this.g.nodes().contains(target), (String)"Specified target node %s  is not part of graph %s", target, this.g);
        Preconditions.checkArgument((boolean)this.g.nodes().contains(source), (String)"Specified source node %s  is not part of graph %s", source, this.g);
        HashSet<N> targets = new HashSet<N>();
        targets.add(target);
        Map<N, Number> distanceMap = this.getDistanceMap(source, targets);
        return distanceMap.get(target);
    }

    public Map<N, Number> getDistanceMap(N source, Collection<N> targets) {
        Preconditions.checkArgument((boolean)this.g.nodes().contains(source), (String)"Specified source node %s  is not part of graph %s", source, this.g);
        Preconditions.checkArgument((targets.size() <= this.maxTargets ? 1 : 0) != 0, (String)"size of target set %d exceeds maximum number of targets allowed: %d", (int)targets.size(), (int)this.maxTargets);
        LinkedHashMap<N, Number> distanceMap = this.singleSourceShortestPath(source, targets, Math.min(this.g.nodes().size(), this.maxTargets));
        if (!this.cached) {
            this.reset(source);
        }
        return distanceMap;
    }

    @Override
    public Map<N, Number> getDistanceMap(N source) {
        return this.getDistanceMap(source, Math.min(this.g.nodes().size(), this.maxTargets));
    }

    public LinkedHashMap<N, Number> getDistanceMap(N source, int numDests) {
        Preconditions.checkArgument((boolean)this.g.nodes().contains(source), (String)"Specified source node %s is not part of graph %s", source, this.g);
        Preconditions.checkArgument((numDests >= 1 && numDests <= this.g.nodes().size() ? 1 : 0) != 0, (String)"number of destinations must be in [1, %d]", (int)this.g.nodes().size());
        Preconditions.checkArgument((numDests <= this.maxTargets ? 1 : 0) != 0, (String)"size of target set %d exceeds maximum number of targets allowed: %d", (int)numDests, (int)this.maxTargets);
        LinkedHashMap<N, Number> distanceMap = this.singleSourceShortestPath(source, null, numDests);
        if (!this.cached) {
            this.reset(source);
        }
        return distanceMap;
    }

    public void setMaxDistance(double maxDistance) {
        this.maxDistance = maxDistance;
        for (N v : this.sourceMap.keySet()) {
            SourceData sd = this.sourceMap.get(v);
            sd.reachedMax = this.maxDistance <= sd.distanceReached || sd.distances.size() >= this.maxTargets;
        }
    }

    public void setMaxTargets(int maxTargets) {
        this.maxTargets = maxTargets;
        for (N v : this.sourceMap.keySet()) {
            SourceData sd = this.sourceMap.get(v);
            sd.reachedMax = this.maxDistance <= sd.distanceReached || sd.distances.size() >= maxTargets;
        }
    }

    public void reset() {
        this.sourceMap = new HashMap<N, SourceData>();
    }

    public void enableCaching(boolean enable) {
        this.cached = enable;
    }

    public void reset(N source) {
        this.sourceMap.put(source, null);
    }

    protected class SourceData {
        protected LinkedHashMap<N, Number> distances = new LinkedHashMap();
        protected Map<N, Number> estimatedDistances = new HashMap();
        protected MapBinaryHeap<N> unknownNodes = new MapBinaryHeap<Object>(Comparator.comparingDouble(n -> this.estimatedDistances.get(n).doubleValue()));
        protected boolean reachedMax = false;
        protected double distanceReached = 0.0;

        protected SourceData(N source) {
            DijkstraDistance.this.sourceMap.put(source, this);
            this.estimatedDistances.put(source, 0.0);
            this.unknownNodes.add(source);
            this.reachedMax = false;
            this.distanceReached = 0.0;
        }

        protected Map.Entry<N, Number> getNextNode() {
            Object v = this.unknownNodes.remove();
            Number dist = this.estimatedDistances.remove(v);
            this.distances.put(v, dist);
            return new AbstractMap.SimpleImmutableEntry(v, dist);
        }

        protected void update(N dest, E tentativeEdge, double newDist) {
            this.estimatedDistances.put(dest, newDist);
            this.unknownNodes.update(dest);
        }

        protected void createRecord(N w, E e, double newDist) {
            this.estimatedDistances.put(w, newDist);
            this.unknownNodes.add(w);
        }

        protected void restoreNode(N v, double dist) {
            this.estimatedDistances.put(v, dist);
            this.unknownNodes.add(v);
            this.distances.remove(v);
        }
    }
}

