/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.shortestpath;

import com.google.common.graph.Graph;
import com.google.common.graph.Network;
import edu.uci.ics.jung.algorithms.scoring.ClosenessCentrality;
import edu.uci.ics.jung.algorithms.scoring.util.NodeScoreTransformer;
import edu.uci.ics.jung.algorithms.shortestpath.Distance;
import edu.uci.ics.jung.algorithms.shortestpath.UnweightedShortestPath;
import java.util.function.BiFunction;
import java.util.function.Function;

public class DistanceStatistics {
    public static <N, E> Function<N, Double> averageDistances(Network<N, E> graph, Distance<N> d) {
        ClosenessCentrality<N, E> cc = new ClosenessCentrality<N, E>(graph, d);
        return new NodeScoreTransformer<N, E>(cc);
    }

    public static <N, E> Function<N, Double> averageDistances(Network<N, E> g) {
        ClosenessCentrality<N, E> cc = new ClosenessCentrality<N, E>(g, new UnweightedShortestPath(g.asGraph()));
        return new NodeScoreTransformer<N, E>(cc);
    }

    public static <N> double diameter(Graph<N> g, BiFunction<N, N, ? extends Number> d, boolean use_max) {
        double diameter = 0.0;
        for (Object v : g.nodes()) {
            for (Object w : g.nodes()) {
                if (v.equals(w)) continue;
                Number dist = d.apply(v, w);
                if (dist == null) {
                    if (use_max) continue;
                    return Double.POSITIVE_INFINITY;
                }
                diameter = Math.max(diameter, dist.doubleValue());
            }
        }
        return diameter;
    }

    public static <N> double diameter(Graph<N> g, BiFunction<N, N, ? extends Number> distance) {
        return DistanceStatistics.diameter(g, distance, false);
    }

    public static <N> double diameter(Graph<N> g) {
        return DistanceStatistics.diameter(g, new UnweightedShortestPath<N>(g)::getDistance);
    }
}

