/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.transformation;

import com.google.common.base.Preconditions;
import com.google.common.graph.Graph;
import com.google.common.graph.GraphBuilder;
import com.google.common.graph.MutableGraph;
import com.google.common.graph.MutableValueGraph;
import com.google.common.graph.ValueGraphBuilder;
import java.util.LinkedHashSet;
import java.util.Set;

public class FoldingTransformer<N, E> {
    public static <N> MutableGraph<N> foldToGraph(Graph<N> g, Set<N> nodes) {
        Preconditions.checkArgument((boolean)g.nodes().containsAll(nodes), (Object)"Input graph must contain all specified nodes");
        MutableGraph newGraph = GraphBuilder.from(g).expectedNodeCount(nodes.size()).build();
        for (N node : nodes) {
            for (Object s : g.successors(node)) {
                for (Object t : g.successors(s)) {
                    if (!nodes.contains(t) || t.equals(node)) continue;
                    newGraph.putEdge(node, t);
                }
            }
        }
        return newGraph;
    }

    public static <N> MutableValueGraph<N, Set<N>> foldToValueGraph(Graph<N> g, Set<N> nodes) {
        Preconditions.checkArgument((boolean)g.nodes().containsAll(nodes), (Object)"Input graph must contain all specified nodes");
        ValueGraphBuilder builder = g.isDirected() ? ValueGraphBuilder.directed() : ValueGraphBuilder.undirected();
        MutableValueGraph newGraph = builder.expectedNodeCount(nodes.size()).nodeOrder(g.nodeOrder()).build();
        for (N node : nodes) {
            for (Object s : g.successors(node)) {
                for (Object t : g.successors(s)) {
                    if (!nodes.contains(t) || t.equals(node)) continue;
                    Set intermediateNodes = (Set)newGraph.edgeValueOrDefault(node, t, new LinkedHashSet());
                    if (intermediateNodes.isEmpty()) {
                        newGraph.putEdgeValue(node, t, (Object)intermediateNodes);
                    }
                    intermediateNodes.add(s);
                }
            }
        }
        return newGraph;
    }
}

