/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.transformation;

import com.google.common.graph.EndpointPair;
import com.google.common.graph.Graph;
import com.google.common.graph.MutableValueGraph;
import com.google.common.graph.ValueGraph;
import com.google.common.graph.ValueGraphBuilder;
import edu.uci.ics.jung.algorithms.blockmodel.NodePartition;
import java.util.Map;
import java.util.Set;

public class NodePartitionCollapser {
    public static <N> ValueGraph<Set<N>, Integer> collapseNodePartitions(NodePartition<N> partitioning) {
        Graph<N> original = partitioning.getGraph();
        ValueGraphBuilder builder = original.isDirected() ? ValueGraphBuilder.directed() : ValueGraphBuilder.undirected();
        MutableValueGraph collapsed = builder.build();
        for (Set<N> set : partitioning.getNodePartitions()) {
            collapsed.addNode(set);
        }
        Map<N, Set<N>> nodeToPartition = partitioning.getNodeToPartitionMap();
        for (EndpointPair endpoints : original.edges()) {
            Object nodeU = endpoints.nodeU();
            Object nodeV = endpoints.nodeV();
            Set<N> partitionU = nodeToPartition.get(nodeU);
            Set<N> partitionV = nodeToPartition.get(nodeV);
            if (nodeU.equals(nodeV) || partitionU.equals(partitionV)) continue;
            int edgeCount = (Integer)collapsed.edgeValueOrDefault(partitionU, partitionV, (Object)0);
            collapsed.putEdgeValue(partitionU, partitionV, (Object)(edgeCount + 1));
        }
        return collapsed;
    }
}

