/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.layout.algorithms;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.graph.EndpointPair;
import com.google.common.graph.Graph;
import edu.uci.ics.jung.algorithms.util.IterativeContext;
import edu.uci.ics.jung.layout.algorithms.AbstractIterativeLayoutAlgorithm;
import edu.uci.ics.jung.layout.model.LayoutModel;
import edu.uci.ics.jung.layout.model.Point;
import java.util.ConcurrentModificationException;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpringLayoutAlgorithm<N>
extends AbstractIterativeLayoutAlgorithm<N>
implements IterativeContext {
    private static final Logger log = LoggerFactory.getLogger(SpringLayoutAlgorithm.class);
    protected double stretch = 0.7;
    protected Function<? super EndpointPair<N>, Integer> lengthFunction;
    protected int repulsion_range_sq = 10000;
    protected double force_multiplier = 0.3333333333333333;
    protected LoadingCache<N, SpringNodeData> springNodeData = CacheBuilder.newBuilder().build(CacheLoader.from(() -> new SpringNodeData()));

    public SpringLayoutAlgorithm() {
        this(n -> 30);
    }

    public SpringLayoutAlgorithm(Function<? super EndpointPair<N>, Integer> length_function) {
        this.lengthFunction = length_function;
    }

    public double getStretch() {
        return this.stretch;
    }

    public void setStretch(double stretch) {
        this.stretch = stretch;
    }

    public int getRepulsionRange() {
        return (int)Math.sqrt(this.repulsion_range_sq);
    }

    public void setRepulsionRange(int range) {
        this.repulsion_range_sq = range * range;
    }

    public double getForceMultiplier() {
        return this.force_multiplier;
    }

    public void setForceMultiplier(double force) {
        this.force_multiplier = force;
    }

    public void initialize() {
    }

    @Override
    public void step() {
        Graph graph = this.layoutModel.getGraph();
        try {
            for (Object node : graph.nodes()) {
                SpringNodeData svd = (SpringNodeData)this.springNodeData.getUnchecked(node);
                if (svd == null) continue;
                svd.dx /= 4.0;
                svd.dy /= 4.0;
                svd.edgedy = 0.0;
                svd.edgedx = 0.0;
                svd.repulsiondy = 0.0;
                svd.repulsiondx = 0.0;
            }
        }
        catch (ConcurrentModificationException cme) {
            this.step();
        }
        this.relaxEdges();
        this.calculateRepulsion();
        this.moveNodes();
    }

    protected void relaxEdges() {
        Graph graph = this.layoutModel.getGraph();
        try {
            for (EndpointPair endpoints : this.layoutModel.getGraph().edges()) {
                Object node1 = endpoints.nodeU();
                Object node2 = endpoints.nodeV();
                Point p1 = this.layoutModel.get(node1);
                Point p2 = this.layoutModel.get(node2);
                if (p1 == null || p2 == null) continue;
                double vx = p1.x - p2.x;
                double vy = p1.y - p2.y;
                double len = Math.sqrt(vx * vx + vy * vy);
                double desiredLen = this.lengthFunction.apply(endpoints).intValue();
                len = len == 0.0 ? 1.0E-4 : len;
                double f = this.force_multiplier * (desiredLen - len) / len;
                double dx = (f *= Math.pow(this.stretch, graph.degree(node1) + graph.degree(node2) - 2)) * vx;
                double dy = f * vy;
                SpringNodeData v1D = (SpringNodeData)this.springNodeData.getUnchecked(node1);
                SpringNodeData v2D = (SpringNodeData)this.springNodeData.getUnchecked(node2);
                v1D.edgedx += dx;
                v1D.edgedy += dy;
                v2D.edgedx += -dx;
                v2D.edgedy += -dy;
            }
        }
        catch (ConcurrentModificationException cme) {
            this.relaxEdges();
        }
    }

    protected void calculateRepulsion() {
        Graph graph = this.layoutModel.getGraph();
        try {
            for (Object node : graph.nodes()) {
                SpringNodeData svd;
                if (this.layoutModel.isLocked(node) || (svd = (SpringNodeData)this.springNodeData.getUnchecked(node)) == null) continue;
                double dx = 0.0;
                double dy = 0.0;
                for (Object node2 : graph.nodes()) {
                    if (node == node2) continue;
                    Point p = (Point)this.layoutModel.apply(node);
                    Point p2 = (Point)this.layoutModel.apply(node2);
                    if (p == null || p2 == null) continue;
                    double vx = p.x - p2.x;
                    double vy = p.y - p2.y;
                    double distanceSq = p.distanceSquared(p2);
                    if (distanceSq == 0.0) {
                        dx += this.random.nextDouble();
                        dy += this.random.nextDouble();
                        continue;
                    }
                    if (!(distanceSq < (double)this.repulsion_range_sq)) continue;
                    double factor = 1.0;
                    dx += factor * vx / distanceSq;
                    dy += factor * vy / distanceSq;
                }
                double dlen = dx * dx + dy * dy;
                if (!(dlen > 0.0)) continue;
                dlen = Math.sqrt(dlen) / 2.0;
                svd.repulsiondx += dx / dlen;
                svd.repulsiondy += dy / dlen;
            }
        }
        catch (ConcurrentModificationException cme) {
            this.calculateRepulsion();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void moveNodes() {
        Graph graph = this.layoutModel.getGraph();
        LayoutModel layoutModel = this.layoutModel;
        synchronized (layoutModel) {
            try {
                for (Object node : graph.nodes()) {
                    SpringNodeData vd;
                    if (this.layoutModel.isLocked(node) || (vd = (SpringNodeData)this.springNodeData.getUnchecked(node)) == null) continue;
                    Point xyd = (Point)this.layoutModel.apply(node);
                    double posX = xyd.x;
                    double posY = xyd.y;
                    vd.dx += vd.repulsiondx + vd.edgedx;
                    vd.dy += vd.repulsiondy + vd.edgedy;
                    posX += Math.max(-5.0, Math.min(5.0, vd.dx));
                    posY += Math.max(-5.0, Math.min(5.0, vd.dy));
                    int width = this.layoutModel.getWidth();
                    int height = this.layoutModel.getHeight();
                    if (posX < 0.0) {
                        posX = 0.0;
                    } else if (posX > (double)width) {
                        posX = width;
                    }
                    if (posY < 0.0) {
                        posY = 0.0;
                    } else if (posY > (double)height) {
                        posY = height;
                    }
                    this.layoutModel.set(node, posX, posY);
                }
            }
            catch (ConcurrentModificationException cme) {
                this.moveNodes();
            }
        }
    }

    @Override
    public boolean done() {
        return false;
    }

    protected static class SpringNodeData {
        protected double edgedx;
        protected double edgedy;
        protected double repulsiondx;
        protected double repulsiondy;
        protected double dx;
        protected double dy;

        protected SpringNodeData() {
        }

        public String toString() {
            return "{edge=" + Point.of(this.edgedx, this.edgedy) + ", rep=" + Point.of(this.repulsiondx, this.repulsiondy) + ", dx=" + this.dx + ", dy=" + this.dy + '}';
        }
    }
}

