/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.layout.algorithms;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import edu.uci.ics.jung.graph.util.TreeUtils;
import edu.uci.ics.jung.layout.algorithms.LayoutAlgorithm;
import edu.uci.ics.jung.layout.model.LayoutModel;
import edu.uci.ics.jung.layout.model.Point;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TreeLayoutAlgorithm<N>
implements LayoutAlgorithm<N> {
    private static final Logger log = LoggerFactory.getLogger(TreeLayoutAlgorithm.class);
    protected Map<N, Integer> basePositions = new HashMap<N, Integer>();
    protected transient Set<N> alreadyDone = new HashSet<N>();
    public static int DEFAULT_DISTX = 50;
    public static int DEFAULT_DISTY = 50;
    protected int distX = 50;
    protected int distY = 50;
    protected double currentX;
    protected double currentY;

    public TreeLayoutAlgorithm() {
        this(DEFAULT_DISTX, DEFAULT_DISTY);
    }

    public TreeLayoutAlgorithm(int distx) {
        this(distx, DEFAULT_DISTY);
    }

    public TreeLayoutAlgorithm(int distx, int disty) {
        Preconditions.checkArgument((distx >= 1 ? 1 : 0) != 0, (Object)"X distance must be positive");
        Preconditions.checkArgument((disty >= 1 ? 1 : 0) != 0, (Object)"Y distance must be positive");
        this.distX = distx;
        this.distY = disty;
        this.currentY = 0.0;
        this.currentX = 0.0;
    }

    @Override
    public void visit(LayoutModel<N> layoutModel) {
        this.buildTree(layoutModel);
    }

    protected void buildTree(LayoutModel<N> layoutModel) {
        this.alreadyDone = Sets.newHashSet();
        this.currentX = 0.0;
        this.currentY = 20.0;
        ImmutableSet roots = TreeUtils.roots(layoutModel.getGraph());
        Preconditions.checkArgument((roots.size() > 0 ? 1 : 0) != 0);
        this.calculateDimensionX(layoutModel, (Collection<N>)roots);
        for (Object node : roots) {
            this.calculateDimensionX(layoutModel, node);
            double posX = this.basePositions.get(node) / 2 + this.distX;
            this.buildTree(layoutModel, node, (int)posX);
        }
    }

    protected void buildTree(LayoutModel<N> layoutModel, N node, int x) {
        if (this.alreadyDone.add(node)) {
            double newY = this.currentY + (double)this.distY;
            this.currentX = x;
            this.currentY = newY;
            this.setCurrentPositionFor(layoutModel, node);
            int sizeXofCurrent = this.basePositions.get(node);
            int lastX = x - sizeXofCurrent / 2;
            for (Object element : layoutModel.getGraph().successors(node)) {
                int sizeXofChild = this.basePositions.get(element);
                int startXofChild = lastX + sizeXofChild / 2;
                this.buildTree(layoutModel, element, startXofChild);
                lastX = lastX + sizeXofChild + this.distX;
            }
            this.currentY -= (double)this.distY;
        }
    }

    private int calculateDimensionX(LayoutModel<N> layoutModel, N node) {
        int size = 0;
        int childrenNum = layoutModel.getGraph().successors(node).size();
        if (childrenNum != 0) {
            for (Object element : layoutModel.getGraph().successors(node)) {
                size += this.calculateDimensionX(layoutModel, element) + this.distX;
            }
        }
        size = Math.max(0, size - this.distX);
        this.basePositions.put(node, size);
        return size;
    }

    private int calculateDimensionX(LayoutModel<N> layoutModel, Collection<N> roots) {
        int size = 0;
        for (N node : roots) {
            size += this.calculateDimensionX(layoutModel, node);
        }
        return size;
    }

    protected void setCurrentPositionFor(LayoutModel<N> layoutModel, N node) {
        int width = layoutModel.getWidth();
        int height = layoutModel.getHeight();
        int x = (int)this.currentX;
        int y = (int)this.currentY;
        if (x < 0) {
            width -= x;
        }
        if (x >= width - this.distX) {
            width = x + this.distX;
        }
        if (y < 0) {
            height -= y;
        }
        if (y >= height - this.distY) {
            height = y + this.distY;
        }
        if (layoutModel.getWidth() < width || layoutModel.getHeight() < height) {
            layoutModel.setSize(width, height);
        }
        this.setLocation(layoutModel, node, this.currentX, this.currentY);
    }

    protected void setLocation(LayoutModel<N> layoutModel, N node, Point location) {
        layoutModel.set(node, location);
    }

    protected void setLocation(LayoutModel<N> layoutModel, N node, double x, double y) {
        layoutModel.set(node, x, y);
    }

    public boolean isLocked(N node) {
        return false;
    }

    public void lock(N node, boolean state) {
    }

    public void setInitializer(Function<N, Point> initializer) {
    }

    public Point getCenter(LayoutModel<N> layoutModel) {
        return Point.of(layoutModel.getWidth() / 2, layoutModel.getHeight() / 2);
    }
}

