/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.layout.util;

import edu.uci.ics.jung.layout.model.LayoutModel;
import edu.uci.ics.jung.layout.model.Point;
import edu.uci.ics.jung.layout.util.NetworkNodeAccessor;
import java.util.ConcurrentModificationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RadiusNetworkNodeAccessor<N>
implements NetworkNodeAccessor<N> {
    private static final Logger log = LoggerFactory.getLogger(RadiusNetworkNodeAccessor.class);
    protected double maxDistance;

    public RadiusNetworkNodeAccessor() {
        this(Math.sqrt(Double.MAX_VALUE));
    }

    public RadiusNetworkNodeAccessor(double maxDistance) {
        this.maxDistance = maxDistance;
    }

    @Override
    public N getNode(LayoutModel<N> layoutModel, Point p) {
        return this.getNode(layoutModel, p.x, p.y);
    }

    @Override
    public N getNode(LayoutModel<N> layoutModel, double x, double y) {
        double minDistance = this.maxDistance * this.maxDistance * this.maxDistance;
        N closest = null;
        while (true) {
            try {
                for (N node : layoutModel.getLocations().keySet()) {
                    Point p = (Point)layoutModel.apply(node);
                    double dx = p.x - x;
                    double dy = p.y - y;
                    double dist = dx * dx + dy * dy;
                    if (!(dist < minDistance)) continue;
                    minDistance = dist;
                    closest = node;
                }
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                continue;
            }
            break;
        }
        return closest;
    }
}

