/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.graph.util;

import com.google.common.base.Preconditions;
import com.google.common.graph.AbstractNetwork;
import com.google.common.graph.ElementOrder;
import com.google.common.graph.EndpointPair;
import com.google.common.graph.Graph;
import com.google.common.graph.MutableNetwork;
import com.google.common.graph.Network;
import java.util.Set;

public class Graphs {
    public static boolean isSelfLoop(EndpointPair<?> endpoints) {
        Preconditions.checkNotNull(endpoints, (Object)"endpoints");
        return endpoints.nodeU().equals(endpoints.nodeV());
    }

    public static <E> boolean isSelfLoop(Network<?, E> network, E edge) {
        Preconditions.checkNotNull(network, (Object)"network");
        Preconditions.checkNotNull(edge, (Object)"edge");
        return Graphs.isSelfLoop(network.incidentNodes(edge));
    }

    public static <N, E> MutableNetwork<N, E> synchronizedNetwork(MutableNetwork<N, E> delegate) {
        return new SynchronizedNetwork(delegate);
    }

    private static class SynchronizedNetwork<N, E>
    extends AbstractNetwork<N, E>
    implements MutableNetwork<N, E> {
        private final MutableNetwork<N, E> delegate;

        private SynchronizedNetwork(MutableNetwork<N, E> delegate) {
            this.delegate = (MutableNetwork)Preconditions.checkNotNull(delegate, (Object)"delegate");
        }

        public synchronized Set<E> adjacentEdges(E arg0) {
            return this.delegate.adjacentEdges(arg0);
        }

        public synchronized Set<N> adjacentNodes(N arg0) {
            return this.delegate.adjacentNodes(arg0);
        }

        public synchronized boolean allowsParallelEdges() {
            return this.delegate.allowsParallelEdges();
        }

        public synchronized boolean allowsSelfLoops() {
            return this.delegate.allowsSelfLoops();
        }

        public synchronized Graph<N> asGraph() {
            return this.delegate.asGraph();
        }

        public synchronized int degree(N arg0) {
            return this.delegate.degree(arg0);
        }

        public synchronized ElementOrder<E> edgeOrder() {
            return this.delegate.edgeOrder();
        }

        public synchronized Set<E> edges() {
            return this.delegate.edges();
        }

        public synchronized Set<E> edgesConnecting(N arg0, N arg1) {
            return this.delegate.edgesConnecting(arg0, arg1);
        }

        public synchronized int inDegree(N arg0) {
            return this.delegate.inDegree(arg0);
        }

        public synchronized Set<E> inEdges(N arg0) {
            return this.delegate.inEdges(arg0);
        }

        public synchronized Set<E> incidentEdges(N arg0) {
            return this.delegate.incidentEdges(arg0);
        }

        public synchronized EndpointPair<N> incidentNodes(E arg0) {
            return this.delegate.incidentNodes(arg0);
        }

        public synchronized boolean isDirected() {
            return this.delegate.isDirected();
        }

        public synchronized ElementOrder<N> nodeOrder() {
            return this.delegate.nodeOrder();
        }

        public synchronized Set<N> nodes() {
            return this.delegate.nodes();
        }

        public synchronized int outDegree(N arg0) {
            return this.delegate.outDegree(arg0);
        }

        public synchronized Set<E> outEdges(N arg0) {
            return this.delegate.outEdges(arg0);
        }

        public synchronized Set<N> predecessors(N arg0) {
            return this.delegate.predecessors(arg0);
        }

        public synchronized Set<N> successors(N arg0) {
            return this.delegate.successors(arg0);
        }

        public synchronized boolean addEdge(N arg0, N arg1, E arg2) {
            return this.delegate.addEdge(arg0, arg1, arg2);
        }

        public synchronized boolean addNode(N arg0) {
            return this.delegate.addNode(arg0);
        }

        public synchronized boolean removeEdge(E arg0) {
            return this.delegate.removeEdge(arg0);
        }

        public synchronized boolean removeNode(N arg0) {
            return this.delegate.removeNode(arg0);
        }
    }
}

