/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization;

import com.google.common.graph.Network;
import edu.uci.ics.jung.visualization.BasicTransformer;
import edu.uci.ics.jung.visualization.MultiLayerTransformer;
import edu.uci.ics.jung.visualization.RenderContext;
import edu.uci.ics.jung.visualization.decorators.EdgeShape;
import edu.uci.ics.jung.visualization.decorators.ParallelEdgeShapeFunction;
import edu.uci.ics.jung.visualization.layout.NetworkElementAccessor;
import edu.uci.ics.jung.visualization.picking.PickedState;
import edu.uci.ics.jung.visualization.renderers.DefaultEdgeLabelRenderer;
import edu.uci.ics.jung.visualization.renderers.DefaultNodeLabelRenderer;
import edu.uci.ics.jung.visualization.renderers.EdgeLabelRenderer;
import edu.uci.ics.jung.visualization.renderers.NodeLabelRenderer;
import edu.uci.ics.jung.visualization.transform.shape.GraphicsDecorator;
import edu.uci.ics.jung.visualization.util.ArrowFactory;
import edu.uci.ics.jung.visualization.util.Context;
import edu.uci.ics.jung.visualization.util.EdgeIndexFunction;
import edu.uci.ics.jung.visualization.util.ParallelEdgeIndexFunction;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Ellipse2D;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.swing.CellRendererPane;
import javax.swing.Icon;
import javax.swing.JComponent;

public class PluggableRenderContext<N, E>
implements RenderContext<N, E> {
    protected float arrowPlacementTolerance = 1.0f;
    protected Predicate<N> nodeIncludePredicate = n -> true;
    protected Function<? super N, Stroke> nodeStrokeFunction = n -> new BasicStroke(1.0f);
    protected Function<? super N, Shape> nodeShapeFunction = n -> new Ellipse2D.Float(-10.0f, -10.0f, 20.0f, 20.0f);
    protected Function<? super N, String> nodeLabelFunction = n -> null;
    protected Function<N, Icon> nodeIconFunction;
    protected Function<? super N, Font> nodeFontFunction = n -> new Font("Helvetica", 0, 12);
    protected Function<? super N, Paint> nodeDrawPaintFunction = n -> Color.BLACK;
    protected Function<? super N, Paint> nodeFillPaintFunction = n -> Color.RED;
    protected Function<? super N, Paint> nodeLabelDrawPaintFunction = n -> Color.BLACK;
    protected Function<? super E, String> edgeLabelFunction = e -> null;
    protected Function<? super E, Stroke> edgeStrokeFunction = e -> new BasicStroke(1.0f);
    protected Function<? super E, Stroke> edgeArrowStrokeFunction = e -> new BasicStroke(1.0f);
    private static final int EDGE_ARROW_LENGTH = 10;
    private static final int EDGE_ARROW_WIDTH = 8;
    private static final int EDGE_ARROW_NOTCH_DEPTH = 4;
    protected Shape edgeArrow;
    protected boolean renderEdgeArrow;
    protected Predicate<E> edgeIncludePredicate = n -> true;
    protected Function<? super E, Font> edgeFontFunction = n -> new Font("Helvetica", 0, 12);
    private static final float DIRECTED_EDGE_LABEL_CLOSENESS = 0.65f;
    private static final float UNDIRECTED_EDGE_LABEL_CLOSENESS = 0.65f;
    protected float edgeLabelCloseness;
    protected Function<Context<Network<N, E>, E>, Shape> edgeShapeFunction;
    protected Function<? super E, Paint> edgeFillPaintFunction = n -> null;
    protected Function<? super E, Paint> edgeDrawPaintFunction = n -> Color.black;
    protected Function<? super E, Paint> arrowFillPaintFunction = n -> Color.black;
    protected Function<? super E, Paint> arrowDrawPaintFunction = n -> Color.black;
    protected EdgeIndexFunction<N, E> parallelEdgeIndexFunction;
    protected MultiLayerTransformer multiLayerTransformer = new BasicTransformer();
    protected NetworkElementAccessor<N, E> pickSupport;
    protected int labelOffset = 10;
    protected JComponent screenDevice;
    protected PickedState<N> pickedNodeState;
    protected PickedState<E> pickedEdgeState;
    protected CellRendererPane rendererPane = new CellRendererPane();
    protected NodeLabelRenderer nodeLabelRenderer = new DefaultNodeLabelRenderer(Color.blue);
    protected EdgeLabelRenderer edgeLabelRenderer = new DefaultEdgeLabelRenderer(Color.cyan);
    protected GraphicsDecorator graphicsContext;
    private EdgeShape<E> edgeShape;

    PluggableRenderContext(Network<N, E> graph) {
        this.edgeShapeFunction = new EdgeShape.QuadCurve();
        this.parallelEdgeIndexFunction = new ParallelEdgeIndexFunction();
        if (graph.isDirected()) {
            this.edgeArrow = ArrowFactory.getNotchedArrow(8.0f, 10.0f, 4.0f);
            this.renderEdgeArrow = true;
            this.edgeLabelCloseness = 0.65f;
        } else {
            this.edgeArrow = ArrowFactory.getWedgeArrow(8.0f, 10.0f);
            this.renderEdgeArrow = false;
            this.edgeLabelCloseness = 0.65f;
        }
    }

    @Override
    public Function<? super N, Shape> getNodeShapeFunction() {
        return this.nodeShapeFunction;
    }

    @Override
    public void setNodeShapeFunction(Function<? super N, Shape> nodeShapeFunction) {
        this.nodeShapeFunction = nodeShapeFunction;
    }

    @Override
    public Function<? super N, Stroke> getNodeStrokeFunction() {
        return this.nodeStrokeFunction;
    }

    @Override
    public void setNodeStrokeFunction(Function<? super N, Stroke> nodeStrokeFunction) {
        this.nodeStrokeFunction = nodeStrokeFunction;
    }

    public static float[] getDashing() {
        return dashing;
    }

    public static float[] getDotting() {
        return dotting;
    }

    @Override
    public float getArrowPlacementTolerance() {
        return this.arrowPlacementTolerance;
    }

    @Override
    public void setArrowPlacementTolerance(float arrow_placement_tolerance) {
        this.arrowPlacementTolerance = arrow_placement_tolerance;
    }

    @Override
    public Shape getEdgeArrow() {
        return this.edgeArrow;
    }

    @Override
    public void setEdgeArrow(Shape shape) {
        this.edgeArrow = shape;
    }

    @Override
    public boolean renderEdgeArrow() {
        return this.renderEdgeArrow;
    }

    @Override
    public void setRenderEdgeArrow(boolean render) {
        this.renderEdgeArrow = render;
    }

    @Override
    public Function<? super E, Font> getEdgeFontFunction() {
        return this.edgeFontFunction;
    }

    @Override
    public void setEdgeFontFunction(Function<? super E, Font> edgeFontFunction) {
        this.edgeFontFunction = edgeFontFunction;
    }

    @Override
    public Predicate<E> getEdgeIncludePredicate() {
        return this.edgeIncludePredicate;
    }

    @Override
    public void setEdgeIncludePredicate(Predicate<E> edgeIncludePredicate) {
        this.edgeIncludePredicate = edgeIncludePredicate;
    }

    @Override
    public float getEdgeLabelCloseness() {
        return this.edgeLabelCloseness;
    }

    @Override
    public void setEdgeLabelCloseness(float closeness) {
        this.edgeLabelCloseness = closeness;
    }

    @Override
    public EdgeLabelRenderer getEdgeLabelRenderer() {
        return this.edgeLabelRenderer;
    }

    @Override
    public void setEdgeLabelRenderer(EdgeLabelRenderer edgeLabelRenderer) {
        this.edgeLabelRenderer = edgeLabelRenderer;
    }

    @Override
    public Function<? super E, Paint> getEdgeFillPaintFunction() {
        return this.edgeFillPaintFunction;
    }

    @Override
    public void setEdgeDrawPaintFunction(Function<? super E, Paint> edgeDrawPaintFunction) {
        this.edgeDrawPaintFunction = edgeDrawPaintFunction;
    }

    @Override
    public Function<? super E, Paint> getEdgeDrawPaintFunction() {
        return this.edgeDrawPaintFunction;
    }

    @Override
    public void setEdgeFillPaintFunction(Function<? super E, Paint> edgeFillPaintFunction) {
        this.edgeFillPaintFunction = edgeFillPaintFunction;
    }

    @Override
    public Function<Context<Network<N, E>, E>, Shape> getEdgeShapeFunction() {
        return this.edgeShapeFunction;
    }

    @Override
    public void setEdgeShapeFunction(Function<Context<Network<N, E>, E>, Shape> edgeShapeFunction) {
        this.edgeShapeFunction = edgeShapeFunction;
        if (edgeShapeFunction instanceof ParallelEdgeShapeFunction) {
            ParallelEdgeShapeFunction function = (ParallelEdgeShapeFunction)edgeShapeFunction;
            function.setEdgeIndexFunction(this.parallelEdgeIndexFunction);
        }
    }

    @Override
    public Function<? super E, String> getEdgeLabelFunction() {
        return this.edgeLabelFunction;
    }

    @Override
    public void setEdgeLabelFunction(Function<? super E, String> edgeLabelFunction) {
        this.edgeLabelFunction = edgeLabelFunction;
    }

    @Override
    public Function<? super E, Stroke> edgeStrokeFunction() {
        return this.edgeStrokeFunction;
    }

    @Override
    public void setEdgeStrokeFunction(Function<? super E, Stroke> edgeStrokeFunction) {
        this.edgeStrokeFunction = edgeStrokeFunction;
    }

    @Override
    public Function<? super E, Stroke> getEdgeArrowStrokeFunction() {
        return this.edgeArrowStrokeFunction;
    }

    @Override
    public void setEdgeArrowStrokeFunction(Function<? super E, Stroke> edgeArrowStrokeFunction) {
        this.edgeArrowStrokeFunction = edgeArrowStrokeFunction;
    }

    @Override
    public GraphicsDecorator getGraphicsContext() {
        return this.graphicsContext;
    }

    @Override
    public void setGraphicsContext(GraphicsDecorator graphicsContext) {
        this.graphicsContext = graphicsContext;
    }

    @Override
    public int getLabelOffset() {
        return this.labelOffset;
    }

    @Override
    public void setLabelOffset(int labelOffset) {
        this.labelOffset = labelOffset;
    }

    @Override
    public EdgeIndexFunction<N, E> getParallelEdgeIndexFunction() {
        return this.parallelEdgeIndexFunction;
    }

    @Override
    public void setParallelEdgeIndexFunction(EdgeIndexFunction<N, E> parallelEdgeIndexFunction) {
        this.parallelEdgeIndexFunction = parallelEdgeIndexFunction;
        this.setEdgeShapeFunction(this.getEdgeShapeFunction());
    }

    @Override
    public PickedState<E> getPickedEdgeState() {
        return this.pickedEdgeState;
    }

    @Override
    public void setPickedEdgeState(PickedState<E> pickedEdgeState) {
        this.pickedEdgeState = pickedEdgeState;
    }

    @Override
    public PickedState<N> getPickedNodeState() {
        return this.pickedNodeState;
    }

    @Override
    public void setPickedNodeState(PickedState<N> pickedNodeState) {
        this.pickedNodeState = pickedNodeState;
    }

    @Override
    public CellRendererPane getRendererPane() {
        return this.rendererPane;
    }

    @Override
    public void setRendererPane(CellRendererPane rendererPane) {
        this.rendererPane = rendererPane;
    }

    @Override
    public JComponent getScreenDevice() {
        return this.screenDevice;
    }

    @Override
    public void setScreenDevice(JComponent screenDevice) {
        this.screenDevice = screenDevice;
        screenDevice.add(this.rendererPane);
    }

    @Override
    public Function<? super N, Font> getNodeFontFunction() {
        return this.nodeFontFunction;
    }

    @Override
    public void setNodeFontFunction(Function<? super N, Font> nodeFontFunction) {
        this.nodeFontFunction = nodeFontFunction;
    }

    @Override
    public Function<N, Icon> getNodeIconFunction() {
        return this.nodeIconFunction;
    }

    @Override
    public void setNodeIconFunction(Function<N, Icon> nodeIconFunction) {
        this.nodeIconFunction = nodeIconFunction;
    }

    @Override
    public Predicate<N> getNodeIncludePredicate() {
        return this.nodeIncludePredicate;
    }

    @Override
    public void setNodeIncludePredicate(Predicate<N> nodeIncludePredicate) {
        this.nodeIncludePredicate = nodeIncludePredicate;
    }

    @Override
    public NodeLabelRenderer getNodeLabelRenderer() {
        return this.nodeLabelRenderer;
    }

    @Override
    public void setNodeLabelRenderer(NodeLabelRenderer nodeLabelRenderer) {
        this.nodeLabelRenderer = nodeLabelRenderer;
    }

    @Override
    public Function<? super N, Paint> getNodeFillPaintFunction() {
        return this.nodeFillPaintFunction;
    }

    @Override
    public void setNodeFillPaintFunction(Function<? super N, Paint> nodeFillPaintFunction) {
        this.nodeFillPaintFunction = nodeFillPaintFunction;
    }

    @Override
    public Function<? super N, Paint> getNodeDrawPaintFunction() {
        return this.nodeDrawPaintFunction;
    }

    @Override
    public void setNodeDrawPaintFunction(Function<? super N, Paint> nodeDrawPaintFunction) {
        this.nodeDrawPaintFunction = nodeDrawPaintFunction;
    }

    @Override
    public Function<? super N, String> getNodeLabelFunction() {
        return this.nodeLabelFunction;
    }

    @Override
    public void setNodeLabelFunction(Function<? super N, String> nodeLabelFunction) {
        this.nodeLabelFunction = nodeLabelFunction;
    }

    @Override
    public void setNodeLabelDrawPaintFunction(Function<? super N, Paint> nodeLabelDrawPaintFunction) {
        this.nodeLabelDrawPaintFunction = nodeLabelDrawPaintFunction;
    }

    @Override
    public Function<? super N, Paint> getNodeLabelDrawPaintFunction() {
        return this.nodeLabelDrawPaintFunction;
    }

    @Override
    public NetworkElementAccessor<N, E> getPickSupport() {
        return this.pickSupport;
    }

    @Override
    public void setPickSupport(NetworkElementAccessor<N, E> pickSupport) {
        this.pickSupport = pickSupport;
    }

    @Override
    public MultiLayerTransformer getMultiLayerTransformer() {
        return this.multiLayerTransformer;
    }

    @Override
    public void setMultiLayerTransformer(MultiLayerTransformer basicTransformer) {
        this.multiLayerTransformer = basicTransformer;
    }

    @Override
    public Function<? super E, Paint> getArrowDrawPaintFunction() {
        return this.arrowDrawPaintFunction;
    }

    @Override
    public Function<? super E, Paint> getArrowFillPaintFunction() {
        return this.arrowFillPaintFunction;
    }

    @Override
    public void setArrowDrawPaintFunction(Function<? super E, Paint> arrowDrawPaintFunction) {
        this.arrowDrawPaintFunction = arrowDrawPaintFunction;
    }

    @Override
    public void setArrowFillPaintFunction(Function<? super E, Paint> arrowFillPaintFunction) {
        this.arrowFillPaintFunction = arrowFillPaintFunction;
    }
}

