/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization.control;

import edu.uci.ics.jung.algorithms.util.MapSettableTransformer;
import edu.uci.ics.jung.layout.model.LayoutModel;
import edu.uci.ics.jung.visualization.MultiLayerTransformer;
import edu.uci.ics.jung.visualization.VisualizationViewer;
import edu.uci.ics.jung.visualization.control.AbstractGraphMousePlugin;
import edu.uci.ics.jung.visualization.layout.NetworkElementAccessor;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.Point2D;
import java.util.function.Function;
import javax.swing.JOptionPane;

public class LabelEditingGraphMousePlugin<N, E>
extends AbstractGraphMousePlugin
implements MouseListener {
    protected N node;
    protected E edge;

    public LabelEditingGraphMousePlugin() {
        this(16);
    }

    public LabelEditingGraphMousePlugin(int selectionModifiers) {
        super(selectionModifiers);
        this.cursor = Cursor.getPredefinedCursor(12);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getModifiers() == this.modifiers && e.getClickCount() == 2) {
            VisualizationViewer vv = (VisualizationViewer)e.getSource();
            LayoutModel layoutModel = vv.getModel().getLayoutModel();
            NetworkElementAccessor pickSupport = vv.getPickSupport();
            if (pickSupport != null) {
                Function es;
                Function vs = vv.getRenderContext().getNodeLabelFunction();
                if (vs instanceof MapSettableTransformer) {
                    MapSettableTransformer mst = (MapSettableTransformer)vs;
                    Point p = e.getPoint();
                    Object node = pickSupport.getNode(layoutModel, ((Point2D)p).getX(), ((Point2D)p).getY());
                    if (node != null) {
                        String newLabel = vs.apply(node);
                        newLabel = JOptionPane.showInputDialog("New Node Label for " + node);
                        if (newLabel != null) {
                            mst.set(node, (Object)newLabel);
                            vv.repaint();
                        }
                        return;
                    }
                }
                if ((es = vv.getRenderContext().getEdgeLabelFunction()) instanceof MapSettableTransformer) {
                    MapSettableTransformer mst = (MapSettableTransformer)es;
                    Point p = e.getPoint();
                    Point2D ip = vv.getRenderContext().getMultiLayerTransformer().inverseTransform(MultiLayerTransformer.Layer.VIEW, p);
                    Object edge = pickSupport.getEdge(layoutModel, ip.getX(), ip.getY());
                    if (edge != null) {
                        String newLabel = JOptionPane.showInputDialog("New Edge Label for " + edge);
                        if (newLabel != null) {
                            mst.set(edge, (Object)newLabel);
                            vv.repaint();
                        }
                        return;
                    }
                }
            }
            e.consume();
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }
}

