/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization.picking;

import com.google.common.collect.Sets;
import com.google.common.graph.EndpointPair;
import com.google.common.graph.Network;
import edu.uci.ics.jung.layout.model.LayoutModel;
import edu.uci.ics.jung.layout.model.Point;
import edu.uci.ics.jung.visualization.VisualizationServer;
import edu.uci.ics.jung.visualization.control.TransformSupport;
import edu.uci.ics.jung.visualization.layout.NetworkElementAccessor;
import edu.uci.ics.jung.visualization.spatial.Spatial;
import edu.uci.ics.jung.visualization.spatial.SpatialRTree;
import edu.uci.ics.jung.visualization.spatial.TreeNode;
import edu.uci.ics.jung.visualization.spatial.rtree.LeafNode;
import edu.uci.ics.jung.visualization.spatial.rtree.Node;
import edu.uci.ics.jung.visualization.util.Context;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShapePickSupport<N, E>
implements NetworkElementAccessor<N, E> {
    private static final Logger log = LoggerFactory.getLogger(ShapePickSupport.class);
    protected float pickSize;
    protected VisualizationServer<N, E> vv;
    protected Style style = Style.CENTERED;

    public ShapePickSupport(VisualizationServer<N, E> vv, float pickSize) {
        this.vv = vv;
        this.pickSize = pickSize;
    }

    public ShapePickSupport(VisualizationServer<N, E> vv) {
        this.vv = vv;
        this.pickSize = 2.0f;
    }

    public Style getStyle() {
        return this.style;
    }

    public void setStyle(Style style) {
        this.style = style;
    }

    public N getNode(LayoutModel<N> layoutModel, Point p) {
        return this.getNode(layoutModel, p.x, p.y);
    }

    public N getNode(LayoutModel<N> layoutModel, double x, double y) {
        log.trace("look for node at (layout coords) {},{}", (Object)x, (Object)y);
        TransformSupport<N, E> transformSupport = this.vv.getTransformSupport();
        N closest = null;
        double minDistance = Double.MAX_VALUE;
        Point2D.Double pickPoint = new Point2D.Double(x, y);
        Spatial<N> nodeSpatial = this.vv.getNodeSpatial();
        if (nodeSpatial.isActive()) {
            return this.getNode(nodeSpatial, layoutModel, ((Point2D)pickPoint).getX(), ((Point2D)pickPoint).getY());
        }
        while (true) {
            try {
                for (N v : this.getFilteredNodes()) {
                    double dy;
                    AffineTransform xform;
                    Shape shape = this.vv.getRenderContext().getNodeShapeFunction().apply(v);
                    Point p = (Point)layoutModel.apply(v);
                    if (p == null || !(shape = (xform = AffineTransform.getTranslateInstance(p.x, p.y)).createTransformedShape(shape)).contains(((Point2D)pickPoint).getX(), ((Point2D)pickPoint).getY())) continue;
                    if (this.style == Style.LOWEST) {
                        return v;
                    }
                    if (this.style == Style.HIGHEST) {
                        closest = v;
                        continue;
                    }
                    Rectangle2D bounds = shape.getBounds2D();
                    double dx = bounds.getCenterX() - ((Point2D)pickPoint).getY();
                    double dist = dx * dx + (dy = bounds.getCenterY() - ((Point2D)pickPoint).getY()) * dy;
                    if (!(dist < minDistance)) continue;
                    minDistance = dist;
                    closest = v;
                }
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                continue;
            }
            break;
        }
        return closest;
    }

    protected N getNode(Spatial<N> spatial, LayoutModel<N> layoutModel, double x, double y) {
        TransformSupport<N, E> transformSupport = this.vv.getTransformSupport();
        Set<TreeNode> containingLeafs = spatial.getContainingLeafs(new Point2D.Double(x, y));
        if (log.isTraceEnabled()) {
            log.trace("leaf for {},{} is {}", new Object[]{x, y, containingLeafs});
        }
        if (containingLeafs == null || containingLeafs.size() == 0) {
            return null;
        }
        RectangularShape union = null;
        for (TreeNode r : containingLeafs) {
            if (union == null) {
                union = r.getBounds();
                continue;
            }
            union = ((Rectangle2D)union).createUnion(r.getBounds());
        }
        double width = union.getWidth();
        double height = union.getHeight();
        double radiusx = width / 2.0;
        double radiusy = height / 2.0;
        Ellipse2D.Double target = new Ellipse2D.Double(x - radiusx, y - radiusy, width, height);
        if (log.isTraceEnabled()) {
            log.trace("target is {}", (Object)target);
        }
        double minDistance = Double.MAX_VALUE;
        N closest = null;
        Set<N> nodes = spatial.getVisibleElements(target);
        if (log.isTraceEnabled()) {
            log.trace("instead of checking all nodes: {}", this.getFilteredNodes());
            log.trace("out of these candidates: {}...", nodes);
        }
        for (Object node : nodes) {
            double dy;
            Shape shape = this.vv.getRenderContext().getNodeShapeFunction().apply(node);
            Point p = (Point)layoutModel.apply(node);
            if (p == null) continue;
            AffineTransform xform = AffineTransform.getTranslateInstance(p.x, p.y);
            shape = xform.createTransformedShape(shape);
            Point2D.Double layoutPoint = new Point2D.Double(x, y);
            log.trace("layout coords of pick point: {}", (Object)layoutPoint);
            Point2D screenPoint = transformSupport.transform(this.vv, layoutPoint);
            log.trace("screen coords of pick point: {}", (Object)screenPoint);
            shape = transformSupport.transform(this.vv, shape);
            log.trace("looking in a shape at {} for {}", (Object)Node.asString(shape.getBounds2D()), (Object)screenPoint);
            if (!shape.contains(screenPoint)) continue;
            if (this.style == Style.LOWEST) {
                return (N)node;
            }
            if (this.style == Style.HIGHEST) {
                closest = (N)node;
                continue;
            }
            Rectangle2D bounds = shape.getBounds2D();
            double dx = bounds.getCenterX() - x;
            double dist = dx * dx + (dy = bounds.getCenterY() - y) * dy;
            if (!(dist < minDistance)) continue;
            minDistance = dist;
            closest = (N)node;
        }
        if (log.isTraceEnabled()) {
            log.trace("picked {} with spatial quadtree", closest);
        }
        return closest;
    }

    @Override
    public Collection<N> getNodes(LayoutModel<N> layoutModel, Shape shape) {
        HashSet<N> pickedNodes = new HashSet<N>();
        Spatial<N> spatial = this.vv.getNodeSpatial();
        if (spatial != null) {
            return this.getContained(spatial, layoutModel, shape);
        }
        while (true) {
            try {
                for (N v : this.getFilteredNodes()) {
                    Point p = (Point)layoutModel.apply(v);
                    if (p == null || !shape.contains(p.x, p.y)) continue;
                    pickedNodes.add(v);
                }
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                continue;
            }
            break;
        }
        return pickedNodes;
    }

    protected Collection<N> getContained(Spatial spatial, LayoutModel<N> layoutModel, Shape shape) {
        HashSet visible = Sets.newHashSet(spatial.getVisibleElements(shape));
        if (log.isTraceEnabled()) {
            log.trace("your shape intersects tree cells with these nodes: {}", (Object)visible);
        }
        Iterator iterator = visible.iterator();
        while (iterator.hasNext()) {
            Object node = iterator.next();
            Point p = (Point)layoutModel.apply(node);
            if (p == null || shape.contains(p.x, p.y)) continue;
            iterator.remove();
        }
        if (log.isTraceEnabled()) {
            log.trace("these were actually picked: {}", (Object)visible);
        }
        return visible;
    }

    protected Collection<E> getContained(SpatialRTree.Edges<E, N> spatial, LayoutModel<N> layoutModel, Shape shape) {
        Set<E> visible = spatial.getVisibleElements(shape);
        if (log.isTraceEnabled()) {
            log.trace("your shape intersects tree cells with these nodes: {}", visible);
        }
        Iterator iterator = visible.iterator();
        while (iterator.hasNext()) {
            Object edge = iterator.next();
            Shape edgeShape = this.getTransformedEdgeShape(edge);
            if (edgeShape.intersects(shape.getBounds())) continue;
            iterator.remove();
        }
        if (log.isTraceEnabled()) {
            log.trace("these were actually picked: {}", visible);
        }
        return visible;
    }

    @Override
    public E getEdge(LayoutModel<N> layoutModel, double x, double y) {
        Rectangle2D.Float pickArea = new Rectangle2D.Float((float)x - this.pickSize / 2.0f, (float)y - this.pickSize / 2.0f, this.pickSize, this.pickSize);
        E closest = null;
        double minDistance = Double.MAX_VALUE;
        Point2D.Double pickPoint = new Point2D.Double(x, y);
        Spatial<E> edgeSpatial = this.vv.getEdgeSpatial();
        if (edgeSpatial != null && edgeSpatial instanceof SpatialRTree.Edges) {
            return this.getEdge((SpatialRTree.Edges)edgeSpatial, layoutModel, ((Point2D)pickPoint).getX(), ((Point2D)pickPoint).getY());
        }
        while (true) {
            try {
                for (E e : this.getFilteredEdges()) {
                    float dy;
                    float dx;
                    float dist;
                    Shape edgeShape = this.getTransformedEdgeShape(e);
                    if (edgeShape == null || !edgeShape.intersects(pickArea)) continue;
                    float cx = 0.0f;
                    float cy = 0.0f;
                    float[] f = new float[6];
                    PathIterator pi = new GeneralPath(edgeShape).getPathIterator(null);
                    if (!pi.isDone()) {
                        pi.next();
                        pi.currentSegment(f);
                        cx = f[0];
                        cy = f[1];
                        if (!pi.isDone()) {
                            pi.currentSegment(f);
                            cx = f[0];
                            cy = f[1];
                        }
                    }
                    if (!((double)(dist = (dx = (float)((double)cx - x)) * dx + (dy = (float)((double)cy - y)) * dy) < minDistance)) continue;
                    minDistance = dist;
                    closest = e;
                }
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                continue;
            }
            break;
        }
        return closest;
    }

    @Override
    public E getEdge(LayoutModel<N> layoutModel, Point2D p) {
        return this.getEdge(layoutModel, p.getX(), p.getY());
    }

    protected E getEdge(SpatialRTree.Edges<E, N> spatial, LayoutModel<N> layoutModel, double x, double y) {
        Set containingLeafs = spatial.getContainingLeafs(new Point2D.Double(x, y));
        if (log.isTraceEnabled()) {
            log.trace("leaf for {},{} is {}", new Object[]{x, y, containingLeafs});
        }
        if (containingLeafs == null || containingLeafs.size() == 0) {
            return null;
        }
        RectangularShape union = null;
        for (LeafNode leafNode : containingLeafs) {
            if (union == null) {
                union = leafNode.getBounds();
                continue;
            }
            union = ((Rectangle2D)union).createUnion(leafNode.getBounds());
        }
        double width = union.getWidth();
        double height = union.getHeight();
        double radiusx = width / 2.0;
        double radiusy = height / 2.0;
        Ellipse2D.Double target = new Ellipse2D.Double(x - radiusx, y - radiusy, width, height);
        if (log.isTraceEnabled()) {
            log.trace("target is {}", (Object)target);
        }
        double minDistance = Double.MAX_VALUE;
        E closest = null;
        Set<E> edges = spatial.getVisibleElements(target);
        if (log.isTraceEnabled()) {
            log.trace("instead of checking all {} edges: {}", (Object)this.getFilteredEdges().size(), this.getFilteredEdges());
            log.trace("out of these {} candidates: {}...", (Object)edges.size(), edges);
        }
        Rectangle2D.Float pickArea = new Rectangle2D.Float((float)x - this.pickSize / 2.0f, (float)y - this.pickSize / 2.0f, this.pickSize, this.pickSize);
        for (Object edge : edges) {
            float dy;
            float dx;
            float dist;
            Shape edgeShape = this.getTransformedEdgeShape(edge);
            if (edgeShape == null || !edgeShape.intersects(pickArea)) continue;
            float cx = 0.0f;
            float cy = 0.0f;
            float[] f = new float[6];
            PathIterator pi = new GeneralPath(edgeShape).getPathIterator(null);
            if (!pi.isDone()) {
                pi.next();
                pi.currentSegment(f);
                cx = f[0];
                cy = f[1];
                if (!pi.isDone()) {
                    pi.currentSegment(f);
                    cx = f[0];
                    cy = f[1];
                }
            }
            if (!((double)(dist = (dx = (float)((double)cx - x)) * dx + (dy = (float)((double)cy - y)) * dy) < minDistance)) continue;
            minDistance = dist;
            closest = edge;
        }
        return closest;
    }

    private Shape getTransformedEdgeShape(E e) {
        EndpointPair endpoints = this.vv.getModel().getNetwork().incidentNodes(e);
        Object v1 = endpoints.nodeU();
        Object v2 = endpoints.nodeV();
        boolean isLoop = v1.equals(v2);
        LayoutModel<N> layoutModel = this.vv.getModel().getLayoutModel();
        Point p1 = (Point)layoutModel.apply(v1);
        Point p2 = (Point)layoutModel.apply(v2);
        if (p1 == null || p2 == null) {
            return null;
        }
        float x1 = (float)p1.x;
        float y1 = (float)p1.y;
        float x2 = (float)p2.x;
        float y2 = (float)p2.y;
        AffineTransform xform = AffineTransform.getTranslateInstance(x1, y1);
        Shape edgeShape = this.vv.getRenderContext().getEdgeShapeFunction().apply(Context.getInstance(this.vv.getModel().getNetwork(), e));
        if (isLoop) {
            Shape s2 = this.vv.getRenderContext().getNodeShapeFunction().apply(v2);
            Rectangle2D s2Bounds = s2.getBounds2D();
            xform.scale(s2Bounds.getWidth(), s2Bounds.getHeight());
            xform.translate(0.0, -edgeShape.getBounds2D().getHeight() / 2.0);
        } else {
            float dx = x2 - x1;
            float dy = y2 - y1;
            double theta = Math.atan2(dy, dx);
            xform.rotate(theta);
            float dist = (float)Math.sqrt(dx * dx + dy * dy);
            xform.scale(dist, 1.0);
        }
        edgeShape = xform.createTransformedShape(edgeShape);
        return edgeShape;
    }

    protected Collection<N> getFilteredNodes() {
        Set nodes = this.vv.getModel().getNetwork().nodes();
        return this.nodesAreFiltered() ? Sets.filter((Set)nodes, this.vv.getRenderContext().getNodeIncludePredicate()::test) : nodes;
    }

    protected Collection<E> getFilteredEdges() {
        Set edges = this.vv.getModel().getNetwork().edges();
        return this.edgesAreFiltered() ? Sets.filter((Set)edges, this.vv.getRenderContext().getEdgeIncludePredicate()::test) : edges;
    }

    protected boolean nodesAreFiltered() {
        Predicate<N> nodeIncludePredicate = this.vv.getRenderContext().getNodeIncludePredicate();
        return nodeIncludePredicate != null && !nodeIncludePredicate.equals(n -> true);
    }

    protected boolean edgesAreFiltered() {
        Predicate<E> edgeIncludePredicate = this.vv.getRenderContext().getEdgeIncludePredicate();
        return edgeIncludePredicate != null && !edgeIncludePredicate.equals(n -> true);
    }

    protected boolean isNodeRendered(N node) {
        Predicate<N> nodeIncludePredicate = this.vv.getRenderContext().getNodeIncludePredicate();
        return nodeIncludePredicate == null || nodeIncludePredicate.test(node);
    }

    protected boolean isEdgeRendered(E edge) {
        Predicate<N> nodeIncludePredicate = this.vv.getRenderContext().getNodeIncludePredicate();
        Predicate<E> edgeIncludePredicate = this.vv.getRenderContext().getEdgeIncludePredicate();
        Network<N, E> g = this.vv.getModel().getNetwork();
        if (edgeIncludePredicate != null && !edgeIncludePredicate.test(edge)) {
            return false;
        }
        EndpointPair endpoints = g.incidentNodes(edge);
        Object v1 = endpoints.nodeU();
        Object v2 = endpoints.nodeV();
        return nodeIncludePredicate == null || nodeIncludePredicate.test(v1) && nodeIncludePredicate.test(v2);
    }

    public float getPickSize() {
        return this.pickSize;
    }

    public void setPickSize(float pickSize) {
        this.pickSize = pickSize;
    }

    public static enum Style {
        LOWEST,
        CENTERED,
        HIGHEST;

    }
}

