/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization.renderers;

import com.google.common.graph.Network;
import edu.uci.ics.jung.visualization.RenderContext;
import edu.uci.ics.jung.visualization.VisualizationModel;
import edu.uci.ics.jung.visualization.VisualizationServer;
import edu.uci.ics.jung.visualization.renderers.BasicEdgeLabelRenderer;
import edu.uci.ics.jung.visualization.renderers.BasicEdgeRenderer;
import edu.uci.ics.jung.visualization.renderers.BasicNodeLabelRenderer;
import edu.uci.ics.jung.visualization.renderers.BasicNodeRenderer;
import edu.uci.ics.jung.visualization.renderers.Renderer;
import edu.uci.ics.jung.visualization.spatial.Spatial;
import java.util.ConcurrentModificationException;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicRenderer<N, E>
implements Renderer<N, E> {
    private static final Logger log = LoggerFactory.getLogger(BasicRenderer.class);
    protected Renderer.Node<N, E> nodeRenderer = new BasicNodeRenderer();
    protected Renderer.NodeLabel<N, E> nodeLabelRenderer = new BasicNodeLabelRenderer();
    protected Renderer.Edge<N, E> edgeRenderer = new BasicEdgeRenderer();
    protected Renderer.EdgeLabel<N, E> edgeLabelRenderer = new BasicEdgeLabelRenderer();

    @Override
    public void render(RenderContext<N, E> renderContext, VisualizationModel<N, E> visualizationModel, Spatial<N> nodeSpatial, Spatial<E> edgeSpatial) {
        if (nodeSpatial == null) {
            this.render(renderContext, visualizationModel);
            return;
        }
        Set<N> visibleNodes = null;
        Set<E> visibleEdges = null;
        try {
            visibleNodes = nodeSpatial.getVisibleElements(((VisualizationServer)((Object)renderContext.getScreenDevice())).viewOnLayout());
            visibleEdges = edgeSpatial != null ? edgeSpatial.getVisibleElements(((VisualizationServer)((Object)renderContext.getScreenDevice())).viewOnLayout()) : visualizationModel.getNetwork().edges();
        }
        catch (ConcurrentModificationException ex) {
            log.info("got {} so returning", (Throwable)ex);
            return;
        }
        try {
            Network<N, E> network = visualizationModel.getNetwork();
            log.trace("the visibleEdges are {}", visibleEdges);
            for (Object e : visibleEdges) {
                if (!network.edges().contains(e)) continue;
                this.renderEdge(renderContext, visualizationModel, e);
                this.renderEdgeLabel(renderContext, visualizationModel, e);
            }
        }
        catch (ConcurrentModificationException cme) {
            renderContext.getScreenDevice().repaint();
        }
        try {
            log.trace("the visibleNodes are {}", visibleNodes);
            for (Object v : visibleNodes) {
                this.renderNode(renderContext, visualizationModel, v);
                this.renderNodeLabel(renderContext, visualizationModel, v);
            }
        }
        catch (ConcurrentModificationException cme) {
            renderContext.getScreenDevice().repaint();
        }
    }

    @Override
    public void render(RenderContext<N, E> renderContext, VisualizationModel<N, E> visualizationModel) {
        Network<N, E> network = visualizationModel.getNetwork();
        try {
            for (Object e : network.edges()) {
                this.renderEdge(renderContext, visualizationModel, e);
                this.renderEdgeLabel(renderContext, visualizationModel, e);
            }
        }
        catch (ConcurrentModificationException cme) {
            renderContext.getScreenDevice().repaint();
        }
        try {
            for (Object v : network.nodes()) {
                this.renderNode(renderContext, visualizationModel, v);
                this.renderNodeLabel(renderContext, visualizationModel, v);
            }
        }
        catch (ConcurrentModificationException cme) {
            renderContext.getScreenDevice().repaint();
        }
    }

    @Override
    public void renderNode(RenderContext<N, E> renderContext, VisualizationModel<N, E> visualizationModel, N v) {
        this.nodeRenderer.paintNode(renderContext, visualizationModel, v);
    }

    @Override
    public void renderNodeLabel(RenderContext<N, E> renderContext, VisualizationModel<N, E> visualizationModel, N v) {
        this.nodeLabelRenderer.labelNode(renderContext, visualizationModel, v, renderContext.getNodeLabelFunction().apply(v));
    }

    @Override
    public void renderEdge(RenderContext<N, E> renderContext, VisualizationModel<N, E> visualizationModel, E e) {
        this.edgeRenderer.paintEdge(renderContext, visualizationModel, e);
    }

    @Override
    public void renderEdgeLabel(RenderContext<N, E> renderContext, VisualizationModel<N, E> visualizationModel, E e) {
        this.edgeLabelRenderer.labelEdge(renderContext, visualizationModel, e, renderContext.getEdgeLabelFunction().apply(e));
    }

    @Override
    public void setNodeRenderer(Renderer.Node<N, E> r) {
        this.nodeRenderer = r;
    }

    @Override
    public void setEdgeRenderer(Renderer.Edge<N, E> r) {
        this.edgeRenderer = r;
    }

    @Override
    public Renderer.EdgeLabel<N, E> getEdgeLabelRenderer() {
        return this.edgeLabelRenderer;
    }

    @Override
    public void setEdgeLabelRenderer(Renderer.EdgeLabel<N, E> edgeLabelRenderer) {
        this.edgeLabelRenderer = edgeLabelRenderer;
    }

    @Override
    public Renderer.NodeLabel<N, E> getNodeLabelRenderer() {
        return this.nodeLabelRenderer;
    }

    @Override
    public void setNodeLabelRenderer(Renderer.NodeLabel<N, E> nodeLabelRenderer) {
        this.nodeLabelRenderer = nodeLabelRenderer;
    }

    @Override
    public Renderer.Edge<N, E> getEdgeRenderer() {
        return this.edgeRenderer;
    }

    @Override
    public Renderer.Node<N, E> getNodeRenderer() {
        return this.nodeRenderer;
    }
}

