/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization.renderers;

import edu.uci.ics.jung.visualization.RenderContext;
import edu.uci.ics.jung.visualization.renderers.EdgeArrowRenderingSupport;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;

public class CenterEdgeArrowRenderingSupport<N, E>
implements EdgeArrowRenderingSupport<N, E> {
    @Override
    public AffineTransform getArrowTransform(RenderContext<N, E> rc, Shape edgeShape, Shape nodeShape) {
        GeneralPath path = new GeneralPath(edgeShape);
        float[] seg = new float[6];
        Point2D.Float p1 = null;
        Point2D.Float p2 = null;
        AffineTransform at = new AffineTransform();
        int middleSegment = 0;
        int current = 0;
        PathIterator i = path.getPathIterator(null, 1.0);
        while (!i.isDone()) {
            ++current;
            i.next();
        }
        middleSegment = current / 2;
        current = 0;
        i = path.getPathIterator(null, 1.0);
        while (!i.isDone()) {
            ++current;
            int ret = i.currentSegment(seg);
            if (ret == 0) {
                p2 = new Point2D.Float(seg[0], seg[1]);
            } else if (ret == 1) {
                p1 = p2;
                p2 = new Point2D.Float(seg[0], seg[1]);
            }
            if (current > middleSegment) {
                at = this.getArrowTransform(rc, new Line2D.Float(p1, p2), nodeShape);
                break;
            }
            i.next();
        }
        return at;
    }

    @Override
    public AffineTransform getReverseArrowTransform(RenderContext<N, E> rc, Shape edgeShape, Shape nodeShape) {
        return this.getReverseArrowTransform(rc, edgeShape, nodeShape, true);
    }

    @Override
    public AffineTransform getReverseArrowTransform(RenderContext<N, E> rc, Shape edgeShape, Shape nodeShape, boolean passedGo) {
        GeneralPath path = new GeneralPath(edgeShape);
        float[] seg = new float[6];
        Point2D.Float p1 = null;
        Point2D.Float p2 = null;
        AffineTransform at = new AffineTransform();
        int middleSegment = 0;
        int current = 0;
        PathIterator i = path.getPathIterator(null, 1.0);
        while (!i.isDone()) {
            ++current;
            i.next();
        }
        middleSegment = current / 2;
        current = 0;
        i = path.getPathIterator(null, 1.0);
        while (!i.isDone()) {
            ++current;
            int ret = i.currentSegment(seg);
            if (ret == 0) {
                p2 = new Point2D.Float(seg[0], seg[1]);
            } else if (ret == 1) {
                p1 = p2;
                p2 = new Point2D.Float(seg[0], seg[1]);
            }
            if (current > middleSegment) {
                at = this.getReverseArrowTransform(rc, new Line2D.Float(p1, p2), nodeShape);
                break;
            }
            i.next();
        }
        return at;
    }

    @Override
    public AffineTransform getArrowTransform(RenderContext<N, E> rc, Line2D edgeShape, Shape nodeShape) {
        Line2D.Float left = new Line2D.Float();
        Line2D.Float right = new Line2D.Float();
        this.subdivide(edgeShape, left, right);
        edgeShape = right;
        float dx = (float)(edgeShape.getX1() - edgeShape.getX2());
        float dy = (float)(edgeShape.getY1() - edgeShape.getY2());
        double atheta = Math.atan2(dx, dy) + 1.5707963267948966;
        AffineTransform at = AffineTransform.getTranslateInstance(edgeShape.getX1(), edgeShape.getY1());
        at.rotate(-atheta);
        return at;
    }

    protected AffineTransform getReverseArrowTransform(RenderContext<N, E> rc, Line2D edgeShape, Shape nodeShape) {
        Line2D.Float left = new Line2D.Float();
        Line2D.Float right = new Line2D.Float();
        this.subdivide(edgeShape, left, right);
        edgeShape = right;
        float dx = (float)(edgeShape.getX1() - edgeShape.getX2());
        float dy = (float)(edgeShape.getY1() - edgeShape.getY2());
        double atheta = Math.atan2(dx, dy) - 1.5707963267948966;
        AffineTransform at = AffineTransform.getTranslateInstance(edgeShape.getX1(), edgeShape.getY1());
        at.rotate(-atheta);
        return at;
    }

    protected void subdivide(Line2D src, Line2D left, Line2D right) {
        double x1 = src.getX1();
        double y1 = src.getY1();
        double x2 = src.getX2();
        double y2 = src.getY2();
        double mx = x1 + (x2 - x1) / 2.0;
        double my = y1 + (y2 - y1) / 2.0;
        if (left != null) {
            left.setLine(x1, y1, mx, my);
        }
        if (right != null) {
            right.setLine(mx, my, x2, y2);
        }
    }
}

