/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization.renderers;

import edu.uci.ics.jung.layout.model.LayoutModel;
import edu.uci.ics.jung.layout.model.Point;
import edu.uci.ics.jung.visualization.MultiLayerTransformer;
import edu.uci.ics.jung.visualization.RenderContext;
import edu.uci.ics.jung.visualization.VisualizationModel;
import edu.uci.ics.jung.visualization.renderers.NodeLabelRenderer;
import edu.uci.ics.jung.visualization.renderers.Renderer;
import edu.uci.ics.jung.visualization.transform.shape.GraphicsDecorator;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Point2D;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;

public class NodeLabelAsShapeRenderer<N, E>
implements Renderer.NodeLabel<N, E>,
Function<N, Shape> {
    protected Map<N, Shape> shapes = new HashMap<N, Shape>();
    protected final LayoutModel<N> layoutModel;
    protected final RenderContext<N, ?> renderContext;

    public NodeLabelAsShapeRenderer(VisualizationModel<N, E> visualizationModel, RenderContext<N, ?> rc) {
        this.layoutModel = visualizationModel.getLayoutModel();
        this.renderContext = rc;
    }

    public Component prepareRenderer(RenderContext<N, ?> rc, NodeLabelRenderer graphLabelRenderer, Object value, boolean isSelected, N node) {
        return this.renderContext.getNodeLabelRenderer().getNodeLabelRendererComponent(this.renderContext.getScreenDevice(), value, this.renderContext.getNodeFontFunction().apply(node), isSelected, node);
    }

    @Override
    public void labelNode(RenderContext<N, E> renderContext, VisualizationModel<N, E> visualizationModel, N v, String label) {
        if (!renderContext.getNodeIncludePredicate().test(v)) {
            return;
        }
        GraphicsDecorator g = renderContext.getGraphicsContext();
        Component component = this.prepareRenderer(renderContext, renderContext.getNodeLabelRenderer(), label, renderContext.getPickedNodeState().isPicked(v), v);
        Dimension d = component.getPreferredSize();
        int h_offset = -d.width / 2;
        int v_offset = -d.height / 2;
        Point p = (Point)this.layoutModel.apply(v);
        Point2D p2d = renderContext.getMultiLayerTransformer().transform(MultiLayerTransformer.Layer.LAYOUT, new Point2D.Double(p.x, p.y));
        int x = (int)p2d.getX();
        int y = (int)p2d.getY();
        g.draw(component, renderContext.getRendererPane(), x + h_offset, y + v_offset, d.width, d.height, true);
        Dimension size = component.getPreferredSize();
        Rectangle bounds = new Rectangle(-size.width / 2 - 2, -size.height / 2 - 2, size.width + 4, size.height);
        this.shapes.put(v, bounds);
    }

    @Override
    public Shape apply(N v) {
        Component component = this.prepareRenderer(this.renderContext, this.renderContext.getNodeLabelRenderer(), this.renderContext.getNodeLabelFunction().apply(v), this.renderContext.getPickedNodeState().isPicked(v), v);
        Dimension size = component.getPreferredSize();
        Rectangle bounds = new Rectangle(-size.width / 2 - 2, -size.height / 2 - 2, size.width + 4, size.height);
        return bounds;
    }

    @Override
    public Renderer.NodeLabel.Position getPosition() {
        return Renderer.NodeLabel.Position.CNTR;
    }

    @Override
    public Renderer.NodeLabel.Positioner getPositioner() {
        return new Renderer.NodeLabel.Positioner(){

            @Override
            public Renderer.NodeLabel.Position getPosition(float x, float y, Dimension d) {
                return Renderer.NodeLabel.Position.CNTR;
            }
        };
    }

    @Override
    public void setPosition(Renderer.NodeLabel.Position position) {
    }

    @Override
    public void setPositioner(Renderer.NodeLabel.Positioner positioner) {
    }
}

