/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization.spatial;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.graph.EndpointPair;
import com.google.common.graph.Network;
import edu.uci.ics.jung.layout.model.LayoutModel;
import edu.uci.ics.jung.layout.model.Point;
import edu.uci.ics.jung.layout.util.LayoutChangeListener;
import edu.uci.ics.jung.layout.util.LayoutEvent;
import edu.uci.ics.jung.layout.util.LayoutNetworkEvent;
import edu.uci.ics.jung.visualization.VisualizationModel;
import edu.uci.ics.jung.visualization.layout.BoundingRectangleCollector;
import edu.uci.ics.jung.visualization.layout.NetworkElementAccessor;
import edu.uci.ics.jung.visualization.layout.RadiusNetworkElementAccessor;
import edu.uci.ics.jung.visualization.spatial.AbstractSpatial;
import edu.uci.ics.jung.visualization.spatial.Spatial;
import edu.uci.ics.jung.visualization.spatial.TreeNode;
import edu.uci.ics.jung.visualization.spatial.rtree.LeafNode;
import edu.uci.ics.jung.visualization.spatial.rtree.Node;
import edu.uci.ics.jung.visualization.spatial.rtree.RTree;
import edu.uci.ics.jung.visualization.spatial.rtree.SplitterContext;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SpatialRTree<T, NT>
extends AbstractSpatial<T, NT>
implements Spatial<T> {
    private static final Logger log = LoggerFactory.getLogger(SpatialRTree.class);
    protected SplitterContext<T> splitterContext;
    protected RTree<T> rtree;
    protected BoundingRectangleCollector<T> boundingRectangleCollector;

    public SpatialRTree(LayoutModel<NT> layoutModel, SplitterContext<T> splitterContext) {
        super(layoutModel);
        this.splitterContext = splitterContext;
    }

    protected abstract List<Shape> collectGrids(List<Shape> var1, RTree<T> var2);

    @Override
    public Rectangle2D getLayoutArea() {
        return this.rectangle;
    }

    @Override
    public void setBounds(Rectangle2D bounds) {
        this.rectangle = bounds;
    }

    @Override
    public List<Shape> getGrid() {
        if (this.gridCache == null) {
            log.trace("getting Grid from tree size {}", (Object)this.rtree.count());
            if (!this.isActive()) {
                return Collections.singletonList(this.getLayoutArea());
            }
            ArrayList areas = Lists.newArrayList();
            this.gridCache = this.collectGrids(areas, this.rtree);
            log.trace("getGrid got {} and {}", (Object)areas.size(), (Object)this.gridCache.size());
            return this.gridCache;
        }
        return this.gridCache;
    }

    @Override
    public void clear() {
        this.rtree = RTree.create();
    }

    @Override
    public Set<LeafNode<T>> getContainingLeafs(double x, double y) {
        if (!this.isActive() || !this.rtree.getRoot().isPresent()) {
            return Collections.emptySet();
        }
        Node<T> theRoot = this.rtree.getRoot().get();
        return theRoot.getContainingLeafs(Sets.newHashSet(), x, y);
    }

    @Override
    public Set<LeafNode<T>> getContainingLeafs(Point2D p) {
        return this.getContainingLeafs(p.getX(), p.getY());
    }

    @Override
    public LeafNode<T> getContainingLeaf(Object element) {
        if (!this.rtree.getRoot().isPresent()) {
            return null;
        }
        Node<Object> theRoot = this.rtree.getRoot().get();
        return theRoot.getContainingLeaf(element);
    }

    protected void recalculate(Collection<T> elements) {
        log.trace("start recalculate");
        this.clear();
        if (this.boundingRectangleCollector != null) {
            for (T element : elements) {
                this.rtree = this.rtree.add(this.splitterContext, element, this.boundingRectangleCollector.getForElement(element));
                log.trace("added {} got {} nodes in {}", new Object[]{element, this.rtree.count(), this.rtree});
            }
        } else {
            log.trace("got no rectangles");
        }
        log.trace("end recalculate");
    }

    public String toString() {
        return this.rtree.toString();
    }

    public static class Edges<E, N>
    extends SpatialRTree<E, N>
    implements Spatial<E>,
    LayoutChangeListener<N> {
        private static final Logger log = LoggerFactory.getLogger(Edges.class);
        NetworkElementAccessor<N, E> networkElementAccessor;
        VisualizationModel<N, E> visualizationModel;

        public Edges(VisualizationModel visualizationModel, BoundingRectangleCollector.Edges<E> boundingRectangleCollector, SplitterContext<E> splitterContext) {
            super(visualizationModel.getLayoutModel(), splitterContext);
            this.visualizationModel = visualizationModel;
            this.boundingRectangleCollector = boundingRectangleCollector;
            this.networkElementAccessor = new RadiusNetworkElementAccessor(visualizationModel.getNetwork());
            this.rtree = RTree.create();
            this.recalculate();
        }

        @Override
        public Set<E> getVisibleElements(Shape shape) {
            if (!this.isActive() || !this.rtree.getRoot().isPresent()) {
                log.trace("not relaxing so getting from the network");
                return this.visualizationModel.getNetwork().edges();
            }
            this.pickShapes.add(shape);
            Node root = this.rtree.getRoot().get();
            HashSet visibleElements = Sets.newHashSet();
            return root.getVisibleElements(visibleElements, shape);
        }

        @Override
        public void update(E element, Point location) {
            this.gridCache = null;
            if (this.isActive()) {
                EndpointPair nodes = this.visualizationModel.getNetwork().incidentNodes(element);
                Object n1 = null;
                Object n2 = null;
                Iterator iterator = nodes.iterator();
                if (iterator.hasNext()) {
                    n1 = iterator.next();
                }
                if (iterator.hasNext()) {
                    n2 = iterator.next();
                }
                if (n2 == null) {
                    n2 = n1;
                }
                if (n1 != null && n2 != null) {
                    Rectangle2D itsShape = this.boundingRectangleCollector.getForElement(element, (Point)this.layoutModel.apply(n1), (Point)this.layoutModel.apply(n2));
                    TreeNode containingLeaf = this.getContainingLeaf(element);
                    if (containingLeaf != null) {
                        if (((LeafNode)containingLeaf).getBounds().contains(itsShape)) {
                            ((LeafNode)containingLeaf).remove(element);
                            ((LeafNode)containingLeaf).add(this.splitterContext, element, itsShape);
                            log.trace("{} changed in place", element);
                        } else {
                            ((LeafNode)containingLeaf).remove(element);
                            log.trace("rtree now size {}", (Object)this.rtree.count());
                            this.rtree = this.rtree.add(this.splitterContext, element, itsShape);
                            log.trace("added back {} with {} into rtree size {}", new Object[]{element, itsShape, this.rtree.count()});
                        }
                    } else {
                        this.rtree = this.rtree.add(this.splitterContext, element, itsShape);
                    }
                }
            }
        }

        public void layoutChanged(LayoutEvent<N> evt) {
            Object node = evt.getNode();
            Point p = evt.getLocation();
            if (this.visualizationModel.getNetwork().nodes().contains(node)) {
                Set edges = this.visualizationModel.getNetwork().incidentEdges(node);
                for (Object edge : edges) {
                    this.update((E)edge, p);
                }
            }
        }

        public void layoutChanged(LayoutNetworkEvent<N> evt) {
            Object node = evt.getNode();
            Point p = evt.getLocation();
            if (this.visualizationModel.getNetwork().nodes().contains(node)) {
                Set edges = this.visualizationModel.getNetwork().incidentEdges(node);
                for (Object edge : edges) {
                    this.update((E)edge, p);
                }
            }
        }

        @Override
        public E getClosestElement(Point2D p) {
            return this.getClosestElement(p.getX(), p.getY());
        }

        @Override
        public E getClosestElement(double x, double y) {
            double diameter;
            Ellipse2D.Double searchArea;
            Set<E> edges;
            if (!this.isActive() || !this.rtree.getRoot().isPresent()) {
                return this.networkElementAccessor.getEdge(this.layoutModel, x, y);
            }
            Node root = this.rtree.getRoot().get();
            double radius = this.layoutModel.getWidth() / 20;
            E closest = null;
            while (closest == null && (closest = (E)this.getClosestEdge(edges = this.getVisibleElements(searchArea = new Ellipse2D.Double(x - radius, y - radius, diameter = radius * 2.0, diameter)), x, y, radius)) == null && edges.size() < this.layoutModel.getGraph().edges().size()) {
                radius *= 2.0;
            }
            return closest;
        }

        protected E getClosestEdge(Collection<E> edges, double x, double y, double radius) {
            double radiusSq = radius * radius;
            if (edges.size() > 0) {
                double closestSoFar = Double.MAX_VALUE;
                E winner = null;
                double winningDistance = -1.0;
                for (E edge : edges) {
                    Network<N, E> network = this.visualizationModel.getNetwork();
                    EndpointPair endpoints = network.incidentNodes(edge);
                    Object u = endpoints.nodeU();
                    Object v = endpoints.nodeV();
                    Point up = (Point)this.layoutModel.apply(u);
                    Point vp = (Point)this.layoutModel.apply(v);
                    Line2D.Double line = new Line2D.Double(up.x, up.y, vp.x, vp.y);
                    double dist = line.ptSegDist(x, y);
                    if (!(dist < radiusSq) || !(dist < closestSoFar)) continue;
                    closestSoFar = dist;
                    winner = edge;
                    winningDistance = dist;
                }
                if (log.isTraceEnabled()) {
                    log.trace("closest winner is {} at distance {}", winner, (Object)winningDistance);
                }
                return winner;
            }
            return null;
        }

        @Override
        protected List<Shape> collectGrids(List<Shape> list, RTree<E> tree) {
            if (tree.getRoot().isPresent()) {
                Node<E> root = tree.getRoot().get();
                root.collectGrids(list);
            }
            return list;
        }

        @Override
        public void recalculate() {
            this.gridCache = null;
            log.trace("called recalculate while active:{} layout model relaxing:{}", (Object)this.isActive(), (Object)this.layoutModel.isRelaxing());
            if (this.isActive()) {
                log.trace("recalculate for edges: {}", (Object)this.visualizationModel.getNetwork().edges());
                this.recalculate(this.visualizationModel.getNetwork().edges());
            }
        }
    }

    public static class Nodes<N>
    extends SpatialRTree<N, N>
    implements Spatial<N>,
    LayoutChangeListener<N> {
        private static final Logger log = LoggerFactory.getLogger(Nodes.class);

        public Nodes(LayoutModel<N> layoutModel, SplitterContext<N> splitterContext) {
            super(layoutModel, splitterContext);
            Nodes nodes = this;
            this.rtree = nodes.rtree.create();
        }

        public Nodes(VisualizationModel visualizationModel, BoundingRectangleCollector.Nodes<N> boundingRectangleCollector, SplitterContext<N> splitterContext) {
            super(visualizationModel.getLayoutModel(), splitterContext);
            this.boundingRectangleCollector = boundingRectangleCollector;
            this.rtree = RTree.create();
        }

        @Override
        public Set<N> getVisibleElements(Shape shape) {
            if (!this.isActive() || !this.rtree.getRoot().isPresent()) {
                return this.layoutModel.getGraph().nodes();
            }
            this.pickShapes.add(shape);
            Node root = this.rtree.getRoot().get();
            log.trace("out of nodes {}", (Object)this.layoutModel.getGraph().nodes());
            HashSet visibleElements = Sets.newHashSet();
            return root.getVisibleElements(visibleElements, shape);
        }

        @Override
        public void update(N element, Point location) {
            this.gridCache = null;
            if (this.isActive() && this.rtree.getRoot().isPresent()) {
                TreeNode containingLeaf = this.getContainingLeaf(element);
                Rectangle2D itsShape = this.boundingRectangleCollector.getForElement(element, location);
                if (containingLeaf != null) {
                    if (((LeafNode)containingLeaf).getBounds().contains(itsShape)) {
                        ((LeafNode)containingLeaf).remove(element);
                        ((LeafNode)containingLeaf).add(this.splitterContext, element, itsShape);
                    } else {
                        this.rtree = this.rtree.remove(element);
                        this.rtree = this.rtree.add(this.splitterContext, element, itsShape);
                    }
                } else {
                    this.rtree = this.rtree.add(this.splitterContext, element, itsShape);
                }
            }
        }

        @Override
        public N getClosestElement(Point2D p) {
            return this.getClosestElement(p.getX(), p.getY());
        }

        @Override
        public N getClosestElement(double x, double y) {
            double diameter;
            Ellipse2D.Double searchArea;
            Set<N> nodes;
            if (!this.isActive() || !this.rtree.getRoot().isPresent()) {
                return (N)this.fallback.getNode(this.layoutModel, x, y);
            }
            double radius = this.layoutModel.getWidth() / 20;
            N closest = null;
            while (closest == null && (closest = (N)this.getClosest(nodes = this.getVisibleElements(searchArea = new Ellipse2D.Double(x - radius, y - radius, diameter = radius * 2.0, diameter)), x, y, radius)) == null && nodes.size() < this.layoutModel.getGraph().nodes().size()) {
                radius *= 2.0;
            }
            return closest;
        }

        @Override
        protected List<Shape> collectGrids(List<Shape> list, RTree<N> tree) {
            if (tree.getRoot().isPresent()) {
                Node<N> root = tree.getRoot().get();
                root.collectGrids(list);
            }
            return list;
        }

        @Override
        public void recalculate() {
            this.gridCache = null;
            log.trace("called recalculate while active:{} layout model relaxing:{}", (Object)this.isActive(), (Object)this.layoutModel.isRelaxing());
            if (this.isActive()) {
                log.trace("recalculate for nodes: {}", (Object)this.layoutModel.getGraph().nodes());
                this.recalculate(this.layoutModel.getGraph().nodes());
            } else {
                log.trace("no recalculate when active: {}", (Object)this.isActive());
            }
        }

        public void layoutChanged(LayoutEvent<N> evt) {
            this.update((N)evt.getNode(), evt.getLocation());
        }

        public void layoutChanged(LayoutNetworkEvent<N> evt) {
            this.update((N)evt.getNode(), evt.getLocation());
        }
    }
}

