/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization.spatial.rtree;

import com.google.common.collect.Lists;
import edu.uci.ics.jung.visualization.spatial.rtree.HorizontalEdgeMapEntryComparator;
import edu.uci.ics.jung.visualization.spatial.rtree.LeafNode;
import edu.uci.ics.jung.visualization.spatial.rtree.LeafSplitter;
import edu.uci.ics.jung.visualization.spatial.rtree.Node;
import edu.uci.ics.jung.visualization.spatial.rtree.Pair;
import edu.uci.ics.jung.visualization.spatial.rtree.VerticalEdgeMapEntryComparator;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RStarLeafSplitter<T>
implements LeafSplitter<T> {
    private static final Logger log = LoggerFactory.getLogger(RStarLeafSplitter.class);
    private final Comparator<Map.Entry<T, Rectangle2D>> horizontalEdgeComparator = new HorizontalEdgeMapEntryComparator();
    private final Comparator<Map.Entry<T, Rectangle2D>> verticalEdgeComparator = new VerticalEdgeMapEntryComparator();

    @Override
    public Pair<LeafNode<T>> split(Collection<Map.Entry<T, Rectangle2D>> entries, Map.Entry<T, Rectangle2D> newEntry) {
        return this.chooseSplitNodes(entries, newEntry);
    }

    private Pair<LeafNode<T>> chooseSplitNodes(Collection<Map.Entry<T, Rectangle2D>> entries, Map.Entry<T, Rectangle2D> newEntry) {
        Pair<List<Map.Entry<T, Rectangle2D>>> pair = this.chooseSplit(entries, newEntry);
        LeafNode leafNodeLeft = LeafNode.create((Collection)pair.left);
        LeafNode leafNodeRight = LeafNode.create((Collection)pair.right);
        return Pair.of(leafNodeLeft, leafNodeRight);
    }

    private Pair<List<Map.Entry<T, Rectangle2D>>> chooseSplit(Collection<Map.Entry<T, Rectangle2D>> entries, Map.Entry<T, Rectangle2D> newEntry) {
        ArrayList xAxisList = Lists.newArrayList(entries);
        xAxisList.add(newEntry);
        ArrayList yAxisList = Lists.newArrayList(entries);
        yAxisList.add(newEntry);
        xAxisList.sort(this.horizontalEdgeComparator);
        yAxisList.sort(this.verticalEdgeComparator);
        ArrayList horizontalGroup = Lists.newArrayList();
        ArrayList verticalGroup = Lists.newArrayList();
        for (int k = 0; k < 4; ++k) {
            horizontalGroup.add(Pair.of(xAxisList.subList(0, 3 + k), xAxisList.subList(3 + k, xAxisList.size())));
            verticalGroup.add(Pair.of(yAxisList.subList(0, 3 + k), yAxisList.subList(3 + k, yAxisList.size())));
        }
        if (log.isTraceEnabled()) {
            log.trace("horizontalGroup size is {}", (Object)horizontalGroup.size());
            for (Object pair : horizontalGroup) {
                log.trace("size of pair lists are {} and {}", (Object)((List)((Pair)pair).left).size(), (Object)((List)((Pair)pair).right).size());
            }
            log.trace("verticalGroup size is {}", (Object)verticalGroup.size());
            for (Object pair : verticalGroup) {
                log.trace("size of pair lists are {} and {}", (Object)((List)((Pair)pair).left).size(), (Object)((List)((Pair)pair).right).size());
            }
        }
        int sumXMarginValue = 0;
        for (Pair pair : horizontalGroup) {
            sumXMarginValue = (int)((double)sumXMarginValue + Node.entryMargin((Collection)pair.left, (Collection)pair.right));
        }
        int sumYMarginValue = 0;
        for (Pair pair : verticalGroup) {
            sumYMarginValue = (int)((double)sumYMarginValue + Node.entryMargin((Collection)pair.left, (Collection)pair.right));
        }
        if (sumXMarginValue < sumYMarginValue) {
            return this.chooseSplitIndex(horizontalGroup);
        }
        return this.chooseSplitIndex(verticalGroup);
    }

    private Pair<List<Map.Entry<T, Rectangle2D>>> chooseSplitIndex(List<Pair<List<Map.Entry<T, Rectangle2D>>>> group) {
        double minOverlap = 0.0;
        double minArea = 0.0;
        Optional<Object> winner = Optional.empty();
        for (Pair<List<Map.Entry<T, Rectangle2D>>> pair : group) {
            double nodeOverlap = Node.entryOverlap((Collection)pair.left, (Collection)pair.right);
            double nodeArea = Node.entryArea((Collection)pair.left, (Collection)pair.right);
            if (!winner.isPresent()) {
                minOverlap = nodeOverlap;
                minArea = nodeArea;
                winner = Optional.of(pair);
                continue;
            }
            if (nodeOverlap == minOverlap) {
                if (!(nodeArea < minArea)) continue;
                minOverlap = nodeOverlap;
                minArea = nodeArea;
                winner = Optional.of(pair);
                continue;
            }
            if (!(nodeOverlap < minOverlap)) continue;
            minOverlap = nodeOverlap;
            minArea = nodeArea;
            winner = Optional.of(pair);
        }
        return winner.orElse(null);
    }
}

