/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization.transform.shape;

import edu.uci.ics.jung.visualization.MultiLayerTransformer;
import edu.uci.ics.jung.visualization.RenderContext;
import edu.uci.ics.jung.visualization.VisualizationViewer;
import edu.uci.ics.jung.visualization.control.LensTransformSupport;
import edu.uci.ics.jung.visualization.control.ModalGraphMouse;
import edu.uci.ics.jung.visualization.control.TransformSupport;
import edu.uci.ics.jung.visualization.layout.NetworkElementAccessor;
import edu.uci.ics.jung.visualization.renderers.BasicRenderer;
import edu.uci.ics.jung.visualization.renderers.Renderer;
import edu.uci.ics.jung.visualization.transform.AbstractLensSupport;
import edu.uci.ics.jung.visualization.transform.LensTransformer;
import edu.uci.ics.jung.visualization.transform.shape.GraphicsDecorator;
import edu.uci.ics.jung.visualization.transform.shape.MagnifyIconGraphics;
import java.awt.Dimension;

public class MagnifyImageLensSupport<N, E>
extends AbstractLensSupport<N, E> {
    protected RenderContext<N, E> renderContext;
    protected GraphicsDecorator lensGraphicsDecorator;
    protected GraphicsDecorator savedGraphicsDecorator;
    protected Renderer<N, E> renderer;
    protected Renderer<N, E> transformingRenderer;
    protected NetworkElementAccessor<N, E> pickSupport;
    static final String instructions = "<html><center>Mouse-Drag the Lens center to move it<p>Mouse-Drag the Lens edge to resize it<p>Ctrl+MouseWheel to change magnification</center></html>";

    public MagnifyImageLensSupport(VisualizationViewer<N, E> vv, LensTransformer lensTransformer, ModalGraphMouse lensGraphMouse) {
        super(vv, lensGraphMouse);
        this.renderContext = vv.getRenderContext();
        this.pickSupport = this.renderContext.getPickSupport();
        this.renderer = vv.getRenderer();
        this.transformingRenderer = new BasicRenderer();
        this.savedGraphicsDecorator = this.renderContext.getGraphicsContext();
        this.lensTransformer = lensTransformer;
        Dimension d = vv.getSize();
        if (d.width == 0 || d.height == 0) {
            d = vv.getPreferredSize();
        }
        this.lensGraphicsDecorator = new MagnifyIconGraphics(lensTransformer);
    }

    @Override
    public void activate() {
        this.lensTransformer.setDelegate(this.vv.getRenderContext().getMultiLayerTransformer().getTransformer(MultiLayerTransformer.Layer.VIEW));
        if (this.lensPaintable == null) {
            this.lensPaintable = new AbstractLensSupport.LensPaintable(this.lensTransformer);
        }
        if (this.lensControls == null) {
            this.lensControls = new AbstractLensSupport.LensControls(this.lensTransformer);
        }
        this.lensTransformer.setDelegate(this.vv.getRenderContext().getMultiLayerTransformer().getTransformer(MultiLayerTransformer.Layer.VIEW));
        this.vv.getRenderContext().getMultiLayerTransformer().setTransformer(MultiLayerTransformer.Layer.VIEW, this.lensTransformer);
        this.renderContext.setGraphicsContext(this.lensGraphicsDecorator);
        this.vv.addPreRenderPaintable(this.lensPaintable);
        this.vv.addPostRenderPaintable(this.lensControls);
        this.vv.setGraphMouse(this.lensGraphMouse);
        this.vv.setToolTipText(instructions);
        this.vv.setTransformSupport(new LensTransformSupport());
        this.vv.repaint();
    }

    @Override
    public void deactivate() {
        this.renderContext.setPickSupport(this.pickSupport);
        this.vv.getRenderContext().getMultiLayerTransformer().setTransformer(MultiLayerTransformer.Layer.VIEW, this.lensTransformer.getDelegate());
        this.vv.removePreRenderPaintable(this.lensPaintable);
        this.vv.removePostRenderPaintable(this.lensControls);
        this.renderContext.setGraphicsContext(this.savedGraphicsDecorator);
        this.vv.setToolTipText(this.defaultToolTipText);
        this.vv.setGraphMouse(this.graphMouse);
        this.vv.setTransformSupport(new TransformSupport());
        this.vv.repaint();
    }
}

