/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.io;

import com.google.common.graph.EndpointPair;
import com.google.common.graph.Network;
import edu.uci.ics.jung.io.GraphMLMetadata;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;

public class GraphMLWriter<N, E> {
    protected Function<? super N, String> node_ids = Object::toString;
    protected Function<? super E, String> edge_ids = e -> null;
    protected Map<String, GraphMLMetadata<Network<N, E>>> graph_data = Collections.emptyMap();
    protected Map<String, GraphMLMetadata<N>> node_data = Collections.emptyMap();
    protected Map<String, GraphMLMetadata<E>> edge_data = Collections.emptyMap();
    protected Function<? super N, String> node_desc = n -> null;
    protected Function<? super E, String> edge_desc = e -> null;
    protected Function<? super Network<N, E>, String> graph_desc = g -> null;
    protected boolean directed;
    protected int nest_level = 0;

    public void save(Network<N, E> g, Writer w) throws IOException {
        BufferedWriter bw = new BufferedWriter(w);
        bw.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        bw.write("<graphml xmlns=\"http://graphml.graphdrawing.org/xmlns/graphml\"\nxmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"  \n");
        bw.write("xsi:schemaLocation=\"http://graphml.graphdrawing.org/xmlns/graphml\">\n");
        for (String key : this.graph_data.keySet()) {
            this.writeKeySpecification(key, "graph", this.graph_data.get(key), bw);
        }
        for (String key : this.node_data.keySet()) {
            this.writeKeySpecification(key, "node", this.node_data.get(key), bw);
        }
        for (String key : this.edge_data.keySet()) {
            this.writeKeySpecification(key, "edge", this.edge_data.get(key), bw);
        }
        bw.write("<graph edgedefault=\"");
        if (g.isDirected()) {
            bw.write("directed\">\n");
        } else {
            bw.write("undirected\">\n");
        }
        String desc = this.graph_desc.apply(g);
        if (desc != null) {
            bw.write("<desc>" + desc + "</desc>\n");
        }
        for (String key : this.graph_data.keySet()) {
            Function<Network<N, E>, String> t = this.graph_data.get((Object)key).transformer;
            String value = t.apply(g);
            if (value == null) continue;
            bw.write(this.format("data", "key", key, value.toString()) + "\n");
        }
        this.writeNodeData(g, bw);
        this.writeEdgeData(g, bw);
        bw.write("</graph>\n");
        bw.write("</graphml>\n");
        bw.flush();
        bw.close();
    }

    protected void writeIndentedText(BufferedWriter w, String to_write) throws IOException {
        for (int i = 0; i < this.nest_level; ++i) {
            w.write("  ");
        }
        w.write(to_write);
    }

    protected void writeNodeData(Network<N, E> graph, BufferedWriter w) throws IOException {
        for (Object v : graph.nodes()) {
            String v_string = String.format("<node id=\"%s\"", this.node_ids.apply(v));
            boolean closed = false;
            String desc = this.node_desc.apply(v);
            if (desc != null) {
                w.write(v_string + ">\n");
                closed = true;
                w.write("<desc>" + desc + "</desc>\n");
            }
            for (String key : this.node_data.keySet()) {
                String value;
                Function t = this.node_data.get((Object)key).transformer;
                if (t == null || (value = t.apply(v)) == null) continue;
                if (!closed) {
                    w.write(v_string + ">\n");
                    closed = true;
                }
                w.write(this.format("data", "key", key, value.toString()) + "\n");
            }
            if (!closed) {
                w.write(v_string + "/>\n");
                continue;
            }
            w.write("</node>\n");
        }
    }

    protected void writeEdgeData(Network<N, E> g, Writer w) throws IOException {
        for (Object e : g.edges()) {
            EndpointPair endpoints = g.incidentNodes(e);
            String id = this.edge_ids.apply(e);
            String e_string = "<edge ";
            if (id != null) {
                e_string = e_string + "id=\"" + id + "\" ";
            }
            e_string = e_string + "source=\"" + this.node_ids.apply(endpoints.nodeU()) + "\" target=\"" + this.node_ids.apply(endpoints.nodeV()) + "\"";
            boolean closed = false;
            String desc = this.edge_desc.apply(e);
            if (desc != null) {
                w.write(e_string + ">\n");
                closed = true;
                w.write("<desc>" + desc + "</desc>\n");
            }
            for (String key : this.edge_data.keySet()) {
                Function t = this.edge_data.get((Object)key).transformer;
                String value = t.apply(e);
                if (value == null) continue;
                if (!closed) {
                    w.write(e_string + ">\n");
                    closed = true;
                }
                w.write(this.format("data", "key", key, value.toString()) + "\n");
            }
            if (!closed) {
                w.write(e_string + "/>\n");
                continue;
            }
            w.write("</edge>\n");
        }
    }

    protected void writeKeySpecification(String key, String type, GraphMLMetadata<?> ds, BufferedWriter bw) throws IOException {
        String def;
        bw.write("<key id=\"" + key + "\" for=\"" + type + "\"");
        boolean closed = false;
        String desc = ds.description;
        if (desc != null) {
            if (!closed) {
                bw.write(">\n");
                closed = true;
            }
            bw.write("<desc>" + desc + "</desc>\n");
        }
        if ((def = ds.default_value) != null) {
            if (!closed) {
                bw.write(">\n");
                closed = true;
            }
            bw.write("<default>" + def.toString() + "</default>\n");
        }
        if (!closed) {
            bw.write("/>\n");
        } else {
            bw.write("</key>\n");
        }
    }

    protected String format(String type, String attr, String value, String contents) {
        return String.format("<%s %s=\"%s\">%s</%s>", type, attr, value, contents, type);
    }

    public void setNodeIDs(Function<N, String> node_ids) {
        this.node_ids = node_ids;
    }

    public void setEdgeIDs(Function<E, String> edge_ids) {
        this.edge_ids = edge_ids;
    }

    public void setGraphData(Map<String, GraphMLMetadata<Network<N, E>>> graph_map) {
        this.graph_data = graph_map;
    }

    public void setNodeData(Map<String, GraphMLMetadata<N>> node_map) {
        this.node_data = node_map;
    }

    public void setEdgeData(Map<String, GraphMLMetadata<E>> edge_map) {
        this.edge_data = edge_map;
    }

    public void addGraphData(String id, String description, String default_value, Function<Network<N, E>, String> graph_transformer) {
        if (this.graph_data.equals(Collections.EMPTY_MAP)) {
            this.graph_data = new HashMap<String, GraphMLMetadata<Network<N, E>>>();
        }
        this.graph_data.put(id, new GraphMLMetadata<Network<N, E>>(description, default_value, graph_transformer));
    }

    public void addNodeData(String id, String description, String default_value, Function<N, String> node_transformer) {
        if (this.node_data.equals(Collections.EMPTY_MAP)) {
            this.node_data = new HashMap<String, GraphMLMetadata<N>>();
        }
        this.node_data.put(id, new GraphMLMetadata<N>(description, default_value, node_transformer));
    }

    public void addEdgeData(String id, String description, String default_value, Function<E, String> edge_transformer) {
        if (this.edge_data.equals(Collections.EMPTY_MAP)) {
            this.edge_data = new HashMap<String, GraphMLMetadata<E>>();
        }
        this.edge_data.put(id, new GraphMLMetadata<E>(description, default_value, edge_transformer));
    }

    public void setNodeDescriptions(Function<N, String> node_desc) {
        this.node_desc = node_desc;
    }

    public void setEdgeDescriptions(Function<E, String> edge_desc) {
        this.edge_desc = edge_desc;
    }

    public void setGraphDescriptions(Function<Network<N, E>, String> graph_desc) {
        this.graph_desc = graph_desc;
    }
}

