/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.io;

import com.google.common.base.Preconditions;
import com.google.common.graph.MutableNetwork;
import edu.uci.ics.jung.algorithms.util.MapSettableTransformer;
import edu.uci.ics.jung.algorithms.util.SettableTransformer;
import java.awt.geom.Point2D;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import java.util.function.Predicate;
import java.util.function.Supplier;

public class PajekNetReader<G extends MutableNetwork<N, E>, N, E> {
    protected Supplier<N> node_factory;
    protected Supplier<E> edge_factory;
    protected SettableTransformer<N, String> node_labels = new MapSettableTransformer(new HashMap());
    protected SettableTransformer<N, Point2D> node_locations = new MapSettableTransformer(new HashMap());
    protected SettableTransformer<E, Number> edge_weights = new MapSettableTransformer(new HashMap());
    private static final Predicate<String> v_pred = new StartsWithPredicate("*nodes");
    private static final Predicate<String> a_pred = new StartsWithPredicate("*arcs");
    private static final Predicate<String> e_pred = new StartsWithPredicate("*edges");
    private static final Predicate<String> t_pred = new StartsWithPredicate("*");
    private static final Predicate<String> c_pred = a_pred.or(e_pred);
    protected static final Predicate<String> l_pred = ListTagPred.getInstance();

    public PajekNetReader(Supplier<N> node_factory, Supplier<E> edge_factory) {
        this.node_factory = node_factory;
        this.edge_factory = edge_factory;
    }

    public PajekNetReader(Supplier<E> edge_factory) {
        this(null, edge_factory);
    }

    public G load(String filename, Supplier<? extends G> graph_factory) throws IOException {
        return (G)this.load((Reader)new FileReader(filename), (MutableNetwork)graph_factory.get());
    }

    public G load(Reader reader, Supplier<? extends G> graph_factory) throws IOException {
        return (G)this.load(reader, (MutableNetwork)graph_factory.get());
    }

    public G load(String filename, G g) throws IOException {
        return this.load((Reader)new FileReader(filename), g);
    }

    public G load(Reader reader, G g) throws IOException {
        Preconditions.checkNotNull(g);
        BufferedReader br = new BufferedReader(reader);
        String curLine = this.skip(br, v_pred);
        if (curLine == null) {
            return g;
        }
        StringTokenizer st = new StringTokenizer(curLine);
        st.nextToken();
        int num_nodes = Integer.parseInt(st.nextToken());
        ArrayList id = null;
        if (this.node_factory != null) {
            for (int i = 1; i <= num_nodes; ++i) {
                g.addNode(this.node_factory.get());
            }
            id = new ArrayList(g.nodes());
        }
        curLine = null;
        while (br.ready() && (curLine = br.readLine()) != null && !t_pred.test(curLine)) {
            if (curLine == "") continue;
            try {
                this.readNode(curLine, id, num_nodes);
            }
            catch (IllegalArgumentException iae) {
                br.close();
                reader.close();
                throw iae;
            }
        }
        curLine = this.readArcsOrEdges(curLine, br, (MutableNetwork<N, E>)g, id, this.edge_factory);
        this.readArcsOrEdges(curLine, br, (MutableNetwork<N, E>)g, id, this.edge_factory);
        br.close();
        reader.close();
        return g;
    }

    private void readNode(String curLine, List<N> id, int num_nodes) {
        String index;
        String[] parts = null;
        int coord_idx = -1;
        String label = null;
        if (curLine.indexOf(34) != -1) {
            String[] initial_split = curLine.trim().split("\"");
            Preconditions.checkArgument((initial_split.length == 2 || initial_split.length == 3 ? 1 : 0) != 0, (Object)("Unbalanced (or too many) quote marks in " + curLine));
            index = initial_split[0].trim();
            label = initial_split[1].trim();
            if (initial_split.length == 3) {
                parts = initial_split[2].trim().split("\\s+", -1);
            }
            coord_idx = 0;
        } else {
            parts = curLine.trim().split("\\s+", -1);
            index = parts[0];
            switch (parts.length) {
                case 1: {
                    break;
                }
                case 2: {
                    label = parts[1];
                    break;
                }
                case 3: {
                    coord_idx = 1;
                    break;
                }
                default: {
                    coord_idx = 2;
                }
            }
        }
        int v_id = Integer.parseInt(index) - 1;
        Preconditions.checkArgument((v_id >= 0 && v_id < num_nodes ? 1 : 0) != 0);
        Object v = id != null ? id.get(v_id) : new Integer(v_id);
        if (label != null && label.length() > 0 && this.node_labels != null) {
            this.node_labels.set(v, (Object)label);
        }
        if (coord_idx != -1 && parts != null && parts.length >= coord_idx + 2 && this.node_locations != null) {
            double x = Double.parseDouble(parts[coord_idx]);
            double y = Double.parseDouble(parts[coord_idx + 1]);
            this.node_locations.set(v, (Object)new Point2D.Double(x, y));
        }
    }

    private String readArcsOrEdges(String curLine, BufferedReader br, MutableNetwork<N, E> g, List<N> id, Supplier<E> edge_factory) throws IOException {
        String nextLine = curLine;
        if (!c_pred.test(curLine)) {
            nextLine = this.skip(br, c_pred);
        }
        boolean reading_arcs = false;
        boolean reading_edges = false;
        if (a_pred.test(nextLine)) {
            Preconditions.checkState((boolean)g.isDirected(), (Object)"Supplied undirected-only graph cannot be populated with directed edges");
            reading_arcs = true;
        }
        if (e_pred.test(nextLine)) {
            Preconditions.checkState((!g.isDirected() ? 1 : 0) != 0, (Object)"Supplied directed-only graph cannot be populated with undirected edges");
            reading_edges = true;
        }
        if (!reading_arcs && !reading_edges) {
            return nextLine;
        }
        boolean is_list = l_pred.test(nextLine);
        while (br.ready() && (nextLine = br.readLine()) != null && !t_pred.test(nextLine)) {
            if (curLine == "") continue;
            StringTokenizer st = new StringTokenizer(nextLine.trim());
            int vid1 = Integer.parseInt(st.nextToken()) - 1;
            Object v1 = id != null ? id.get(vid1) : new Integer(vid1);
            if (is_list) {
                do {
                    this.createAddEdge(st, v1, g, id, edge_factory);
                } while (st.hasMoreTokens());
                continue;
            }
            E e = this.createAddEdge(st, v1, g, id, edge_factory);
            if (this.edge_weights == null || !st.hasMoreTokens()) continue;
            this.edge_weights.set(e, (Object)new Float(st.nextToken()));
        }
        return nextLine;
    }

    protected E createAddEdge(StringTokenizer st, N v1, MutableNetwork<N, E> g, List<N> id, Supplier<E> edge_factory) {
        int vid2 = Integer.parseInt(st.nextToken()) - 1;
        Object v2 = id != null ? id.get(vid2) : new Integer(vid2);
        E e = edge_factory.get();
        g.addEdge(v1, v2, e);
        return e;
    }

    protected String skip(BufferedReader br, Predicate<String> p) throws IOException {
        String curLine;
        while (br.ready() && (curLine = br.readLine()) != null) {
            if (!p.test(curLine = curLine.trim())) continue;
            return curLine;
        }
        return null;
    }

    public SettableTransformer<N, Point2D> getNodeLocationTransformer() {
        return this.node_locations;
    }

    public void setNodeLocationTransformer(SettableTransformer<N, Point2D> node_locations) {
        this.node_locations = node_locations;
    }

    public SettableTransformer<N, String> getNodeLabeller() {
        return this.node_labels;
    }

    public void setNodeLabeller(SettableTransformer<N, String> node_labels) {
        this.node_labels = node_labels;
    }

    public SettableTransformer<E, Number> getEdgeWeightTransformer() {
        return this.edge_weights;
    }

    public void setEdgeWeightTransformer(SettableTransformer<E, Number> edge_weights) {
        this.edge_weights = edge_weights;
    }

    protected static class ListTagPred
    implements Predicate<String> {
        protected static ListTagPred instance;

        protected ListTagPred() {
        }

        protected static ListTagPred getInstance() {
            if (instance == null) {
                instance = new ListTagPred();
            }
            return instance;
        }

        @Override
        public boolean test(String s) {
            return s != null && s.toLowerCase().endsWith("list");
        }
    }

    protected static class StartsWithPredicate
    implements Predicate<String> {
        private String tag;

        protected StartsWithPredicate(String s) {
            this.tag = s;
        }

        @Override
        public boolean test(String str) {
            return str != null && str.toLowerCase().startsWith(this.tag);
        }
    }
}

