/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.io.graphml.parser;

import com.google.common.graph.MutableNetwork;
import edu.uci.ics.jung.io.GraphIOException;
import edu.uci.ics.jung.io.graphml.DataMetadata;
import edu.uci.ics.jung.io.graphml.ExceptionConverter;
import edu.uci.ics.jung.io.graphml.parser.AbstractElementParser;
import edu.uci.ics.jung.io.graphml.parser.ParserContext;
import java.util.Iterator;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class DataElementParser<G extends MutableNetwork<N, E>, N, E>
extends AbstractElementParser<G, N, E> {
    public DataElementParser(ParserContext<G, N, E> parserContext) {
        super(parserContext);
    }

    @Override
    public DataMetadata parse(XMLEventReader xmlEventReader, StartElement start) throws GraphIOException {
        try {
            DataMetadata data = new DataMetadata();
            Iterator<Attribute> iterator = start.getAttributes();
            while (iterator.hasNext()) {
                Attribute attribute = iterator.next();
                String name = attribute.getName().getLocalPart();
                String value = attribute.getValue();
                if (data.getKey() != null || !"key".equals(name)) continue;
                data.setKey(value);
            }
            if (data.getKey() == null) {
                throw new GraphIOException("Element 'data' is missing attribute 'key'");
            }
            while (xmlEventReader.hasNext()) {
                XMLEvent event = xmlEventReader.nextEvent();
                if (event.isStartElement()) {
                    StartElement element = (StartElement)event;
                    this.getUnknownParser().parse(xmlEventReader, element);
                }
                if (event.isCharacters()) {
                    Characters characters = (Characters)event;
                    data.setValue(characters.getData());
                }
                if (!event.isEndElement()) continue;
                EndElement end = (EndElement)event;
                this.verifyMatch(start, end);
                break;
            }
            return data;
        }
        catch (Exception e) {
            ExceptionConverter.convert(e);
            return null;
        }
    }
}

