/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.io.graphml.parser;

import com.google.common.graph.MutableNetwork;
import edu.uci.ics.jung.io.GraphIOException;
import edu.uci.ics.jung.io.graphml.EndpointMetadata;
import edu.uci.ics.jung.io.graphml.ExceptionConverter;
import edu.uci.ics.jung.io.graphml.parser.AbstractElementParser;
import edu.uci.ics.jung.io.graphml.parser.ParserContext;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class EndpointElementParser<G extends MutableNetwork<N, E>, N, E>
extends AbstractElementParser<G, N, E> {
    private static final Map<String, EndpointMetadata.EndpointType> endpointTypeMap = new HashMap<String, EndpointMetadata.EndpointType>();

    public EndpointElementParser(ParserContext<G, N, E> parserContext) {
        super(parserContext);
    }

    @Override
    public EndpointMetadata parse(XMLEventReader xmlEventReader, StartElement start) throws GraphIOException {
        try {
            EndpointMetadata endpoint = new EndpointMetadata();
            Iterator<Attribute> iterator = start.getAttributes();
            while (iterator.hasNext()) {
                Attribute attribute = iterator.next();
                String name = attribute.getName().getLocalPart();
                String value = attribute.getValue();
                if (endpoint.getId() == null && "id".equals(name)) {
                    endpoint.setId(value);
                }
                if (endpoint.getPort() == null && "port".equals(name)) {
                    endpoint.setPort(value);
                }
                if (endpoint.getNode() == null && "node".equals(name)) {
                    endpoint.setNode(value);
                }
                if ("type".equals(name)) {
                    EndpointMetadata.EndpointType t = endpointTypeMap.get(value);
                    if (t == null) {
                        t = EndpointMetadata.EndpointType.UNDIR;
                    }
                    endpoint.setEndpointType(t);
                    continue;
                }
                endpoint.setProperty(name, value);
            }
            if (endpoint.getNode() == null) {
                throw new GraphIOException("Element 'endpoint' is missing attribute 'node'");
            }
            while (xmlEventReader.hasNext()) {
                XMLEvent event = xmlEventReader.nextEvent();
                if (event.isStartElement()) {
                    StartElement element = (StartElement)event;
                    String name = element.getName().getLocalPart();
                    if ("desc".equals(name)) {
                        String desc = (String)this.getParser(name).parse(xmlEventReader, element);
                        endpoint.setDescription(desc);
                    } else {
                        this.getUnknownParser().parse(xmlEventReader, element);
                    }
                }
                if (!event.isEndElement()) continue;
                EndElement end = (EndElement)event;
                this.verifyMatch(start, end);
                break;
            }
            this.applyKeys(endpoint);
            return endpoint;
        }
        catch (Exception e) {
            ExceptionConverter.convert(e);
            return null;
        }
    }

    static {
        endpointTypeMap.put("in", EndpointMetadata.EndpointType.IN);
        endpointTypeMap.put("out", EndpointMetadata.EndpointType.OUT);
        endpointTypeMap.put("undir", EndpointMetadata.EndpointType.UNDIR);
    }
}

