/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.graph.Network;
import edu.uci.ics.jung.layout.algorithms.LayoutAlgorithm;
import edu.uci.ics.jung.layout.model.LayoutModel;
import edu.uci.ics.jung.layout.model.LoadingCacheLayoutModel;
import edu.uci.ics.jung.layout.model.Point;
import edu.uci.ics.jung.layout.util.LayoutChangeListener;
import edu.uci.ics.jung.layout.util.LayoutEvent;
import edu.uci.ics.jung.layout.util.LayoutEventSupport;
import edu.uci.ics.jung.layout.util.LayoutNetworkEvent;
import edu.uci.ics.jung.layout.util.RandomLocationTransformer;
import edu.uci.ics.jung.visualization.VisualizationModel;
import edu.uci.ics.jung.visualization.util.ChangeEventSupport;
import edu.uci.ics.jung.visualization.util.DefaultChangeEventSupport;
import java.awt.Dimension;
import java.util.List;
import java.util.function.Function;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseVisualizationModel<N, E>
implements VisualizationModel<N, E>,
ChangeEventSupport,
LayoutEventSupport<N>,
LayoutChangeListener<N>,
ChangeListener,
LayoutModel.ChangeListener {
    private static final Logger log = LoggerFactory.getLogger(BaseVisualizationModel.class);
    protected Network<N, E> network;
    protected LayoutModel<N> layoutModel;
    protected LayoutAlgorithm<N> layoutAlgorithm;
    protected ChangeEventSupport changeSupport = new DefaultChangeEventSupport(this);
    private List<LayoutChangeListener<N>> layoutChangeListeners = Lists.newArrayList();

    public BaseVisualizationModel(VisualizationModel<N, E> other) {
        this(other.getNetwork(), other.getLayoutAlgorithm(), null, other.getLayoutSize());
    }

    public BaseVisualizationModel(VisualizationModel<N, E> other, Dimension layoutSize) {
        this(other.getNetwork(), other.getLayoutAlgorithm(), null, layoutSize);
    }

    public BaseVisualizationModel(Network<N, E> network, LayoutAlgorithm<N> layoutAlgorithm, Dimension layoutSize) {
        this(network, layoutAlgorithm, null, layoutSize);
    }

    public BaseVisualizationModel(Network<N, E> network, LayoutAlgorithm<N> layoutAlgorithm, Function<N, Point> initializer, Dimension layoutSize) {
        Preconditions.checkNotNull(network);
        Preconditions.checkNotNull((Object)layoutSize);
        Preconditions.checkArgument((layoutSize.width > 0 ? 1 : 0) != 0, (Object)"width must be > 0");
        Preconditions.checkArgument((layoutSize.height > 0 ? 1 : 0) != 0, (Object)"height must be > 0");
        this.layoutAlgorithm = layoutAlgorithm;
        this.layoutModel = LoadingCacheLayoutModel.builder().setGraph(network.asGraph()).setSize(layoutSize.width, layoutSize.height).setInitializer((Function)new RandomLocationTransformer((double)layoutSize.width, (double)layoutSize.height, System.currentTimeMillis())).build();
        if (this.layoutModel instanceof LayoutModel.ChangeSupport) {
            ((LayoutModel.ChangeSupport)this.layoutModel).addChangeListener((LayoutModel.ChangeListener)this);
        }
        if (this.layoutModel instanceof LayoutEventSupport) {
            ((LayoutEventSupport)this.layoutModel).addLayoutChangeListener((LayoutChangeListener)this);
        }
        this.network = network;
        if (initializer != null) {
            this.layoutModel.setInitializer(initializer);
        }
        this.layoutModel.accept(layoutAlgorithm);
    }

    public BaseVisualizationModel(Network<N, E> network, LayoutModel<N> layoutModel, LayoutAlgorithm<N> layoutAlgorithm) {
        Preconditions.checkNotNull(network);
        Preconditions.checkNotNull(layoutModel);
        this.layoutModel = layoutModel;
        if (this.layoutModel instanceof ChangeEventSupport) {
            ((ChangeEventSupport)layoutModel).addChangeListener(this);
        }
        this.network = network;
        this.layoutModel.accept(layoutAlgorithm);
        this.layoutAlgorithm = layoutAlgorithm;
    }

    @Override
    public LayoutModel<N> getLayoutModel() {
        log.trace("getting a layourModel " + this.layoutModel);
        return this.layoutModel;
    }

    @Override
    public void setLayoutModel(LayoutModel<N> layoutModel) {
        if (this.layoutModel != null) {
            this.layoutModel.stopRelaxer();
        }
        this.layoutModel = layoutModel;
        if (this.layoutAlgorithm != null) {
            layoutModel.accept(this.layoutAlgorithm);
        }
    }

    @Override
    public void setLayoutAlgorithm(LayoutAlgorithm<N> layoutAlgorithm) {
        this.layoutAlgorithm = layoutAlgorithm;
        log.trace("setLayoutAlgorithm to " + layoutAlgorithm);
        this.layoutModel.accept(layoutAlgorithm);
    }

    @Override
    public Dimension getLayoutSize() {
        return new Dimension(this.layoutModel.getWidth(), this.layoutModel.getHeight());
    }

    @Override
    public void setNetwork(Network<N, E> network) {
        this.setNetwork(network, true);
    }

    @Override
    public void setNetwork(Network<N, E> network, boolean forceUpdate) {
        log.trace("setNetwork to n:{} e:{}", (Object)network.nodes(), (Object)network.edges());
        this.network = network;
        this.layoutModel.setGraph(network.asGraph());
        if (forceUpdate && this.layoutAlgorithm != null) {
            log.trace("will accept {}", this.layoutAlgorithm);
            this.layoutModel.accept(this.layoutAlgorithm);
            log.trace("will fire stateChanged");
            this.changeSupport.fireStateChanged();
            log.trace("fired stateChanged");
        }
    }

    @Override
    public LayoutAlgorithm<N> getLayoutAlgorithm() {
        return this.layoutAlgorithm;
    }

    @Override
    public Network<N, E> getNetwork() {
        return this.network;
    }

    @Override
    public void addChangeListener(ChangeListener l) {
        this.changeSupport.addChangeListener(l);
    }

    @Override
    public void removeChangeListener(ChangeListener l) {
        this.changeSupport.removeChangeListener(l);
    }

    @Override
    public ChangeListener[] getChangeListeners() {
        return this.changeSupport.getChangeListeners();
    }

    @Override
    public void fireStateChanged() {
        this.changeSupport.fireStateChanged();
    }

    public void addLayoutChangeListener(LayoutChangeListener<N> listener) {
        this.layoutChangeListeners.add(listener);
    }

    public void removeLayoutChangeListener(LayoutChangeListener<N> listener) {
        this.layoutChangeListeners.remove(listener);
    }

    private void fireLayoutChanged(LayoutEvent<N> layoutEvent, Network<N, E> network) {
        if (!this.layoutChangeListeners.isEmpty()) {
            LayoutNetworkEvent evt = new LayoutNetworkEvent(layoutEvent, network);
            for (LayoutChangeListener<N> listener : this.layoutChangeListeners) {
                listener.layoutChanged((LayoutEvent)evt);
            }
        }
    }

    public void changed() {
        this.fireStateChanged();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.fireStateChanged();
    }

    public void layoutChanged(LayoutEvent<N> evt) {
        this.fireLayoutChanged(evt, this.network);
    }

    public void layoutChanged(LayoutNetworkEvent<N> evt) {
        this.fireLayoutChanged((LayoutEvent<N>)evt, this.network);
    }
}

