/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization;

import com.google.common.collect.Lists;
import com.google.common.graph.Network;
import edu.uci.ics.jung.layout.algorithms.LayoutAlgorithm;
import edu.uci.ics.jung.layout.model.LayoutModel;
import edu.uci.ics.jung.layout.util.Caching;
import edu.uci.ics.jung.layout.util.LayoutChangeListener;
import edu.uci.ics.jung.layout.util.LayoutEvent;
import edu.uci.ics.jung.layout.util.LayoutEventSupport;
import edu.uci.ics.jung.layout.util.LayoutNetworkEvent;
import edu.uci.ics.jung.visualization.BaseVisualizationModel;
import edu.uci.ics.jung.visualization.MultiLayerTransformer;
import edu.uci.ics.jung.visualization.PluggableRenderContext;
import edu.uci.ics.jung.visualization.RenderContext;
import edu.uci.ics.jung.visualization.VisualizationModel;
import edu.uci.ics.jung.visualization.VisualizationServer;
import edu.uci.ics.jung.visualization.control.ScalingControl;
import edu.uci.ics.jung.visualization.control.TransformSupport;
import edu.uci.ics.jung.visualization.decorators.PickableEdgePaintFunction;
import edu.uci.ics.jung.visualization.decorators.PickableNodePaintFunction;
import edu.uci.ics.jung.visualization.layout.BoundingRectangleCollector;
import edu.uci.ics.jung.visualization.layout.NetworkElementAccessor;
import edu.uci.ics.jung.visualization.picking.MultiPickedState;
import edu.uci.ics.jung.visualization.picking.PickedState;
import edu.uci.ics.jung.visualization.picking.ShapePickSupport;
import edu.uci.ics.jung.visualization.properties.VisualizationViewerUI;
import edu.uci.ics.jung.visualization.renderers.BasicRenderer;
import edu.uci.ics.jung.visualization.renderers.Renderer;
import edu.uci.ics.jung.visualization.spatial.Spatial;
import edu.uci.ics.jung.visualization.spatial.SpatialRTree;
import edu.uci.ics.jung.visualization.spatial.rtree.QuadraticLeafSplitter;
import edu.uci.ics.jung.visualization.spatial.rtree.QuadraticSplitter;
import edu.uci.ics.jung.visualization.spatial.rtree.RStarLeafSplitter;
import edu.uci.ics.jung.visualization.spatial.rtree.RStarSplitter;
import edu.uci.ics.jung.visualization.spatial.rtree.SplitterContext;
import edu.uci.ics.jung.visualization.transform.shape.GraphicsDecorator;
import edu.uci.ics.jung.visualization.util.ChangeEventSupport;
import edu.uci.ics.jung.visualization.util.DefaultChangeEventSupport;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicVisualizationServer<N, E>
extends JPanel
implements ChangeListener,
ChangeEventSupport,
VisualizationServer<N, E>,
LayoutChangeListener<N> {
    static Logger log = LoggerFactory.getLogger(BasicVisualizationServer.class);
    protected ChangeEventSupport changeSupport = new DefaultChangeEventSupport(this);
    protected VisualizationModel<N, E> model;
    protected Renderer<N, E> renderer;
    protected Map<RenderingHints.Key, Object> renderingHints = new HashMap<RenderingHints.Key, Object>();
    protected PickedState<N> pickedNodeState;
    protected PickedState<E> pickedEdgeState;
    protected ItemListener pickEventListener;
    protected BufferedImage offscreen;
    protected Graphics2D offscreenG2d;
    protected boolean doubleBuffered;
    protected List<VisualizationServer.Paintable> preRenderers = new ArrayList<VisualizationServer.Paintable>();
    protected List<VisualizationServer.Paintable> postRenderers = new ArrayList<VisualizationServer.Paintable>();
    protected RenderContext<N, E> renderContext;
    protected TransformSupport<N, E> transformSupport = new TransformSupport();
    protected Spatial<N> nodeSpatial;
    protected Spatial<E> edgeSpatial;

    public BasicVisualizationServer(Network<N, E> network, LayoutAlgorithm<N> layoutAlgorithm, Dimension preferredSize) {
        this(new BaseVisualizationModel<N, E>(network, layoutAlgorithm, preferredSize), preferredSize);
    }

    public BasicVisualizationServer(VisualizationModel<N, E> model, Dimension preferredSize) {
        this.model = model;
        this.renderContext = new PluggableRenderContext<N, E>(model.getNetwork());
        this.renderer = new BasicRenderer();
        this.createSpatialStuctures(model, this.renderContext);
        model.addChangeListener(this);
        model.addLayoutChangeListener(this);
        this.setDoubleBuffered(false);
        this.addComponentListener(new VisualizationListener(this));
        this.setPickSupport(new ShapePickSupport(this));
        this.setPickedNodeState(new MultiPickedState());
        this.setPickedEdgeState(new MultiPickedState());
        this.renderContext.setEdgeDrawPaintFunction(new PickableEdgePaintFunction<E>(this.getPickedEdgeState(), Color.black, Color.cyan));
        this.renderContext.setNodeFillPaintFunction(new PickableNodePaintFunction<N>(this.getPickedNodeState(), Color.red, Color.yellow));
        this.setPreferredSize(preferredSize);
        this.renderingHints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.renderContext.getMultiLayerTransformer().addChangeListener(this);
        try {
            VisualizationViewerUI.getInstance(this).parse();
        }
        catch (IOException e) {
            log.debug("Unable to read property files. Using defaults.");
        }
    }

    private void createSpatialStuctures(VisualizationModel model, RenderContext renderContext) {
        this.setNodeSpatial(new SpatialRTree.Nodes(model, new BoundingRectangleCollector.Nodes(renderContext, model), SplitterContext.of(new RStarLeafSplitter(), new RStarSplitter())));
        this.setEdgeSpatial(new SpatialRTree.Edges(model, new BoundingRectangleCollector.Edges(renderContext, model), SplitterContext.of(new QuadraticLeafSplitter(), new QuadraticSplitter())));
    }

    @Override
    public Spatial<N> getNodeSpatial() {
        return this.nodeSpatial;
    }

    @Override
    public void setNodeSpatial(Spatial<N> spatial) {
        if (this.nodeSpatial != null) {
            this.disconnectListeners(this.nodeSpatial);
        }
        this.nodeSpatial = spatial;
        boolean layoutModelRelaxing = this.model.getLayoutModel().isRelaxing();
        this.nodeSpatial.setActive(!layoutModelRelaxing);
        if (!layoutModelRelaxing) {
            this.nodeSpatial.recalculate();
        }
        this.connectListeners(spatial);
    }

    @Override
    public Spatial<E> getEdgeSpatial() {
        return this.edgeSpatial;
    }

    @Override
    public void setEdgeSpatial(Spatial<E> spatial) {
        if (this.edgeSpatial != null) {
            this.disconnectListeners(this.edgeSpatial);
        }
        this.edgeSpatial = spatial;
        boolean layoutModelRelaxing = this.model.getLayoutModel().isRelaxing();
        this.edgeSpatial.setActive(!layoutModelRelaxing);
        if (!layoutModelRelaxing) {
            this.edgeSpatial.recalculate();
        }
        this.connectListeners(this.edgeSpatial);
    }

    private void connectListeners(Spatial<?> spatial) {
        if (this.model instanceof LayoutEventSupport && spatial instanceof LayoutChangeListener && spatial instanceof LayoutChangeListener) {
            this.model.addLayoutChangeListener((LayoutChangeListener)spatial);
        }
        this.model.getLayoutModel().getLayoutStateChangeSupport().addLayoutStateChangeListener(spatial);
    }

    private void disconnectListeners(Spatial<?> spatial) {
        if (this.model instanceof LayoutEventSupport && spatial instanceof LayoutChangeListener) {
            this.model.removeLayoutChangeListener((LayoutChangeListener)spatial);
        }
        if (this.model.getLayoutModel() instanceof LayoutEventSupport) {
            ((LayoutEventSupport)this.model.getLayoutModel()).removeLayoutChangeListener((LayoutChangeListener)spatial);
        }
        if (this.model.getLayoutModel() instanceof LayoutModel.ChangeSupport && spatial instanceof LayoutModel.ChangeListener) {
            ((LayoutModel.ChangeSupport)this.model.getLayoutModel()).removeChangeListener((LayoutModel.ChangeListener)spatial);
        }
        this.model.getLayoutModel().getLayoutStateChangeSupport().removeLayoutStateChangeListener(spatial);
    }

    @Override
    public void setDoubleBuffered(boolean doubleBuffered) {
        this.doubleBuffered = doubleBuffered;
    }

    @Override
    public boolean isDoubleBuffered() {
        return this.doubleBuffered;
    }

    @Override
    public Dimension getSize() {
        Dimension d = super.getSize();
        if (d.width <= 0 || d.height <= 0) {
            d = this.getPreferredSize();
        }
        return d;
    }

    protected void checkOffscreenImage(Dimension d) {
        if (this.doubleBuffered && (this.offscreen == null || this.offscreen.getWidth() != d.width || this.offscreen.getHeight() != d.height)) {
            this.offscreen = new BufferedImage(d.width, d.height, 2);
            this.offscreenG2d = this.offscreen.createGraphics();
        }
    }

    @Override
    public VisualizationModel<N, E> getModel() {
        return this.model;
    }

    @Override
    public void setModel(VisualizationModel<N, E> model) {
        this.model = model;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.repaint();
        this.fireStateChanged();
    }

    @Override
    public void setRenderer(Renderer<N, E> r) {
        this.renderer = r;
        this.repaint();
    }

    @Override
    public Renderer<N, E> getRenderer() {
        return this.renderer;
    }

    public void scaleToLayout(ScalingControl scaler) {
        Dimension ld;
        Dimension vd = this.getPreferredSize();
        if (this.isShowing()) {
            vd = this.getSize();
        }
        if (!vd.equals(ld = this.model.getLayoutSize())) {
            scaler.scale(this, (float)(vd.getWidth() / ld.getWidth()), new Point2D.Double());
        }
    }

    @Override
    public Map<RenderingHints.Key, Object> getRenderingHints() {
        return this.renderingHints;
    }

    @Override
    public void setRenderingHints(Map<RenderingHints.Key, Object> renderingHints) {
        this.renderingHints = renderingHints;
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g;
        if (this.doubleBuffered) {
            this.checkOffscreenImage(this.getSize());
            this.renderGraph(this.offscreenG2d);
            g2d.drawImage(this.offscreen, null, 0, 0);
        } else {
            this.renderGraph(g2d);
        }
    }

    @Override
    public Shape viewOnLayout() {
        Dimension d = this.getSize();
        MultiLayerTransformer vt = this.renderContext.getMultiLayerTransformer();
        Rectangle2D.Double s = new Rectangle2D.Double(0.0, 0.0, d.width, d.height);
        return vt.inverseTransform(s);
    }

    protected void renderGraph(Graphics2D g2d) {
        if (this.renderContext.getGraphicsContext() == null) {
            this.renderContext.setGraphicsContext(new GraphicsDecorator(g2d));
        } else {
            this.renderContext.getGraphicsContext().setDelegate(g2d);
        }
        this.renderContext.setScreenDevice(this);
        g2d.setRenderingHints(this.renderingHints);
        Dimension d = this.getSize();
        g2d.setColor(this.getBackground());
        g2d.fillRect(0, 0, d.width, d.height);
        AffineTransform oldXform = g2d.getTransform();
        AffineTransform newXform = new AffineTransform(oldXform);
        newXform.concatenate(this.renderContext.getMultiLayerTransformer().getTransformer(MultiLayerTransformer.Layer.VIEW).getTransform());
        g2d.setTransform(newXform);
        VisualizationServer.Paintable lowerAnnotationPaintable = null;
        if (log.isTraceEnabled()) {
            this.addSpatialAnnotations(this.nodeSpatial, Color.blue);
            this.addSpatialAnnotations(this.edgeSpatial, Color.green);
        } else {
            this.removeSpatialAnnotations();
        }
        for (VisualizationServer.Paintable paintable : this.preRenderers) {
            if (paintable.useTransform()) {
                paintable.paint(g2d);
                continue;
            }
            g2d.setTransform(oldXform);
            paintable.paint(g2d);
            g2d.setTransform(newXform);
        }
        if (lowerAnnotationPaintable != null) {
            this.removePreRenderPaintable(lowerAnnotationPaintable);
        }
        if (this.model instanceof Caching) {
            ((Caching)this.model).clear();
        }
        this.renderer.render(this.renderContext, this.model, this.nodeSpatial, this.edgeSpatial);
        for (VisualizationServer.Paintable paintable : this.postRenderers) {
            if (paintable.useTransform()) {
                paintable.paint(g2d);
                continue;
            }
            g2d.setTransform(oldXform);
            paintable.paint(g2d);
            g2d.setTransform(newXform);
        }
        g2d.setTransform(oldXform);
    }

    public void layoutChanged(LayoutEvent<N> evt) {
        this.repaint();
    }

    public void layoutChanged(LayoutNetworkEvent<N> evt) {
        this.repaint();
    }

    @Override
    public void addPreRenderPaintable(VisualizationServer.Paintable paintable) {
        if (this.preRenderers == null) {
            this.preRenderers = new ArrayList<VisualizationServer.Paintable>();
        }
        this.preRenderers.add(paintable);
    }

    public void prependPreRenderPaintable(VisualizationServer.Paintable paintable) {
        if (this.preRenderers == null) {
            this.preRenderers = new ArrayList<VisualizationServer.Paintable>();
        }
        this.preRenderers.add(0, paintable);
    }

    @Override
    public void removePreRenderPaintable(VisualizationServer.Paintable paintable) {
        if (this.preRenderers != null) {
            this.preRenderers.remove(paintable);
        }
    }

    @Override
    public void addPostRenderPaintable(VisualizationServer.Paintable paintable) {
        if (this.postRenderers == null) {
            this.postRenderers = new ArrayList<VisualizationServer.Paintable>();
        }
        this.postRenderers.add(paintable);
    }

    public void prependPostRenderPaintable(VisualizationServer.Paintable paintable) {
        if (this.postRenderers == null) {
            this.postRenderers = new ArrayList<VisualizationServer.Paintable>();
        }
        this.postRenderers.add(0, paintable);
    }

    @Override
    public void removePostRenderPaintable(VisualizationServer.Paintable paintable) {
        if (this.postRenderers != null) {
            this.postRenderers.remove(paintable);
        }
    }

    @Override
    public void addChangeListener(ChangeListener l) {
        this.changeSupport.addChangeListener(l);
    }

    @Override
    public void removeChangeListener(ChangeListener l) {
        this.changeSupport.removeChangeListener(l);
    }

    @Override
    public ChangeListener[] getChangeListeners() {
        return this.changeSupport.getChangeListeners();
    }

    @Override
    public void fireStateChanged() {
        this.changeSupport.fireStateChanged();
    }

    @Override
    public PickedState<N> getPickedNodeState() {
        return this.pickedNodeState;
    }

    @Override
    public PickedState<E> getPickedEdgeState() {
        return this.pickedEdgeState;
    }

    @Override
    public void setPickedNodeState(PickedState<N> pickedNodeState) {
        if (this.pickEventListener != null && this.pickedNodeState != null) {
            this.pickedNodeState.removeItemListener(this.pickEventListener);
        }
        this.pickedNodeState = pickedNodeState;
        this.renderContext.setPickedNodeState(pickedNodeState);
        if (this.pickEventListener == null) {
            this.pickEventListener = e -> this.repaint();
        }
        pickedNodeState.addItemListener(this.pickEventListener);
    }

    @Override
    public void setPickedEdgeState(PickedState<E> pickedEdgeState) {
        if (this.pickEventListener != null && this.pickedEdgeState != null) {
            this.pickedEdgeState.removeItemListener(this.pickEventListener);
        }
        this.pickedEdgeState = pickedEdgeState;
        this.renderContext.setPickedEdgeState(pickedEdgeState);
        if (this.pickEventListener == null) {
            this.pickEventListener = e -> this.repaint();
        }
        pickedEdgeState.addItemListener(this.pickEventListener);
    }

    @Override
    public NetworkElementAccessor<N, E> getPickSupport() {
        return this.renderContext.getPickSupport();
    }

    @Override
    public void setPickSupport(NetworkElementAccessor<N, E> pickSupport) {
        this.renderContext.setPickSupport(pickSupport);
    }

    @Override
    public Point2D getCenter() {
        Dimension d = this.getSize();
        return new Point2D.Double(d.width / 2, d.height / 2);
    }

    @Override
    public RenderContext<N, E> getRenderContext() {
        return this.renderContext;
    }

    @Override
    public void setRenderContext(RenderContext<N, E> renderContext) {
        this.renderContext = renderContext;
    }

    private void addSpatialAnnotations(Spatial spatial, Color color) {
        if (spatial != null) {
            this.addPreRenderPaintable(new SpatialPaintable(spatial, color));
        }
    }

    private void removeSpatialAnnotations() {
        Iterator<VisualizationServer.Paintable> iterator = this.preRenderers.iterator();
        while (iterator.hasNext()) {
            VisualizationServer.Paintable paintable = iterator.next();
            if (!(paintable instanceof SpatialPaintable)) continue;
            iterator.remove();
        }
    }

    @Override
    public TransformSupport<N, E> getTransformSupport() {
        return this.transformSupport;
    }

    public void setTransformSupport(TransformSupport<N, E> transformSupport) {
        this.transformSupport = transformSupport;
    }

    class SpatialPaintable<T>
    implements VisualizationServer.Paintable {
        Spatial<T> quadTree;
        Color color;

        public SpatialPaintable(Spatial<T> quadTree, Color color) {
            this.quadTree = quadTree;
            this.color = color;
        }

        @Override
        public boolean useTransform() {
            return false;
        }

        @Override
        public void paint(Graphics g) {
            Shape shape;
            Graphics2D g2d = (Graphics2D)g;
            Color oldColor = g2d.getColor();
            List<Object> grid = Lists.newArrayList();
            grid = this.quadTree.getGrid();
            g2d.setColor(this.color);
            for (Shape shape2 : grid) {
                shape = BasicVisualizationServer.this.transformSupport.transform(BasicVisualizationServer.this, shape2);
                g2d.draw(shape);
            }
            g2d.setColor(Color.red);
            for (Shape shape3 : this.quadTree.getPickShapes()) {
                if (shape3 == null) continue;
                shape = BasicVisualizationServer.this.transformSupport.transform(BasicVisualizationServer.this, shape3);
                g2d.draw(shape);
            }
            g2d.setColor(oldColor);
        }
    }

    protected class VisualizationListener
    extends ComponentAdapter {
        protected BasicVisualizationServer<N, E> vv;

        public VisualizationListener(BasicVisualizationServer<N, E> vv) {
            this.vv = vv;
        }

        @Override
        public void componentResized(ComponentEvent e) {
            Dimension d = this.vv.getSize();
            if (d.width <= 0 || d.height <= 0) {
                return;
            }
            BasicVisualizationServer.this.checkOffscreenImage(d);
            BasicVisualizationServer.this.repaint();
        }
    }
}

