/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization.control;

import edu.uci.ics.jung.visualization.control.AbstractModalGraphMouse;
import edu.uci.ics.jung.visualization.control.AnimatedPickingGraphMousePlugin;
import edu.uci.ics.jung.visualization.control.CrossoverScalingControl;
import edu.uci.ics.jung.visualization.control.ModalGraphMouse;
import edu.uci.ics.jung.visualization.control.PickingGraphMousePlugin;
import edu.uci.ics.jung.visualization.control.RotatingGraphMousePlugin;
import edu.uci.ics.jung.visualization.control.ScalingGraphMousePlugin;
import edu.uci.ics.jung.visualization.control.ShearingGraphMousePlugin;
import edu.uci.ics.jung.visualization.control.TranslatingGraphMousePlugin;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.ItemSelectable;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;

public class DefaultModalGraphMouse<N, E>
extends AbstractModalGraphMouse
implements ModalGraphMouse,
ItemSelectable {
    public DefaultModalGraphMouse() {
        this(1.1f, 0.9090909f);
    }

    public DefaultModalGraphMouse(float in, float out) {
        super(in, out);
        this.loadPlugins();
        this.setModeKeyListener(new ModeKeyAdapter(this));
    }

    @Override
    protected void loadPlugins() {
        this.pickingPlugin = new PickingGraphMousePlugin();
        this.animatedPickingPlugin = new AnimatedPickingGraphMousePlugin();
        this.translatingPlugin = new TranslatingGraphMousePlugin(16);
        this.scalingPlugin = new ScalingGraphMousePlugin(new CrossoverScalingControl(), 0, this.in, this.out);
        this.rotatingPlugin = new RotatingGraphMousePlugin();
        this.shearingPlugin = new ShearingGraphMousePlugin();
        this.add(this.scalingPlugin);
        this.setMode(ModalGraphMouse.Mode.TRANSFORMING);
    }

    public static class ModeKeyAdapter
    extends KeyAdapter {
        private char t = (char)116;
        private char p = (char)112;
        protected ModalGraphMouse graphMouse;

        public ModeKeyAdapter(ModalGraphMouse graphMouse) {
            this.graphMouse = graphMouse;
        }

        public ModeKeyAdapter(char t, char p, ModalGraphMouse graphMouse) {
            this.t = t;
            this.p = p;
            this.graphMouse = graphMouse;
        }

        @Override
        public void keyTyped(KeyEvent event) {
            char keyChar = event.getKeyChar();
            if (keyChar == this.t) {
                ((Component)event.getSource()).setCursor(Cursor.getPredefinedCursor(0));
                this.graphMouse.setMode(ModalGraphMouse.Mode.TRANSFORMING);
            } else if (keyChar == this.p) {
                ((Component)event.getSource()).setCursor(Cursor.getPredefinedCursor(12));
                this.graphMouse.setMode(ModalGraphMouse.Mode.PICKING);
            }
        }
    }
}

