/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization.control;

import edu.uci.ics.jung.layout.model.LayoutModel;
import edu.uci.ics.jung.layout.model.Point;
import edu.uci.ics.jung.visualization.MultiLayerTransformer;
import edu.uci.ics.jung.visualization.VisualizationViewer;
import edu.uci.ics.jung.visualization.control.AnimatedPickingGraphMousePlugin;
import edu.uci.ics.jung.visualization.control.SatelliteVisualizationViewer;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Point2D;

public class SatelliteAnimatedPickingGraphMousePlugin<N, E>
extends AnimatedPickingGraphMousePlugin<N, E>
implements MouseListener,
MouseMotionListener {
    public SatelliteAnimatedPickingGraphMousePlugin() {
        this(18);
    }

    public SatelliteAnimatedPickingGraphMousePlugin(int selectionModifiers) {
        super(selectionModifiers);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        VisualizationViewer vv;
        if (e.getModifiers() == this.modifiers && (vv = (VisualizationViewer)e.getSource()) instanceof SatelliteVisualizationViewer) {
            final VisualizationViewer vvMaster = ((SatelliteVisualizationViewer)vv).getMaster();
            if (this.node != null) {
                LayoutModel layoutModel = vvMaster.getModel().getLayoutModel();
                Point q = (Point)layoutModel.apply(this.node);
                Point2D lvc = vvMaster.getRenderContext().getMultiLayerTransformer().inverseTransform(MultiLayerTransformer.Layer.LAYOUT, vvMaster.getCenter());
                final double dx = (lvc.getX() - q.x) / 10.0;
                final double dy = (lvc.getY() - q.y) / 10.0;
                Runnable animator = new Runnable(){

                    @Override
                    public void run() {
                        for (int i = 0; i < 10; ++i) {
                            vvMaster.getRenderContext().getMultiLayerTransformer().getTransformer(MultiLayerTransformer.Layer.LAYOUT).translate(dx, dy);
                            try {
                                Thread.sleep(100L);
                                continue;
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                    }
                };
                Thread thread = new Thread(animator);
                thread.start();
            }
        }
    }
}

