/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization.control;

import edu.uci.ics.jung.layout.model.LayoutModel;
import edu.uci.ics.jung.visualization.MultiLayerTransformer;
import edu.uci.ics.jung.visualization.VisualizationServer;
import edu.uci.ics.jung.visualization.VisualizationViewer;
import edu.uci.ics.jung.visualization.control.ModalSatelliteGraphMouse;
import edu.uci.ics.jung.visualization.spatial.Spatial;
import edu.uci.ics.jung.visualization.transform.MutableAffineTransformer;
import edu.uci.ics.jung.visualization.transform.MutableTransformer;
import edu.uci.ics.jung.visualization.transform.shape.GraphicsDecorator;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;

public class SatelliteVisualizationViewer<N, E>
extends VisualizationViewer<N, E> {
    protected VisualizationViewer<N, E> master;

    public SatelliteVisualizationViewer(VisualizationViewer<N, E> master, Dimension preferredSize) {
        super(master.getModel(), preferredSize);
        this.master = master;
        ModalSatelliteGraphMouse gm = new ModalSatelliteGraphMouse();
        this.setGraphMouse(gm);
        this.addPreRenderPaintable(new ViewLens<N, E>(this, master));
        AffineTransform modelLayoutTransform = new AffineTransform(master.getRenderContext().getMultiLayerTransformer().getTransformer(MultiLayerTransformer.Layer.LAYOUT).getTransform());
        this.getRenderContext().getMultiLayerTransformer().setTransformer(MultiLayerTransformer.Layer.LAYOUT, new MutableAffineTransformer(modelLayoutTransform));
        master.addChangeListener(this);
        this.setPickedNodeState(master.getPickedNodeState());
        this.setPickedEdgeState(master.getPickedEdgeState());
        this.setNodeSpatial(new Spatial.NoOp.Node(this.model.getLayoutModel()));
        this.setEdgeSpatial(new Spatial.NoOp.Edge(this.model));
    }

    @Override
    protected void renderGraph(Graphics2D g2d) {
        if (this.renderContext.getGraphicsContext() == null) {
            this.renderContext.setGraphicsContext(new GraphicsDecorator(g2d));
        } else {
            this.renderContext.getGraphicsContext().setDelegate(g2d);
        }
        this.renderContext.setScreenDevice(this);
        LayoutModel layoutModel = this.getModel().getLayoutModel();
        g2d.setRenderingHints(this.renderingHints);
        Dimension d = this.getSize();
        g2d.setColor(this.getBackground());
        g2d.fillRect(0, 0, d.width, d.height);
        AffineTransform oldXform = g2d.getTransform();
        AffineTransform newXform = new AffineTransform(oldXform);
        newXform.concatenate(this.renderContext.getMultiLayerTransformer().getTransformer(MultiLayerTransformer.Layer.VIEW).getTransform());
        g2d.setTransform(newXform);
        for (VisualizationServer.Paintable paintable : this.preRenderers) {
            if (paintable.useTransform()) {
                paintable.paint(g2d);
                continue;
            }
            g2d.setTransform(oldXform);
            paintable.paint(g2d);
            g2d.setTransform(newXform);
        }
        this.renderer.render(this.renderContext, this.model);
        for (VisualizationServer.Paintable paintable : this.postRenderers) {
            if (paintable.useTransform()) {
                paintable.paint(g2d);
                continue;
            }
            g2d.setTransform(oldXform);
            paintable.paint(g2d);
            g2d.setTransform(newXform);
        }
        g2d.setTransform(oldXform);
    }

    public VisualizationViewer<N, E> getMaster() {
        return this.master;
    }

    static class ViewLens<N, E>
    implements VisualizationServer.Paintable {
        VisualizationViewer<N, E> master;
        VisualizationViewer<N, E> vv;

        public ViewLens(VisualizationViewer<N, E> vv, VisualizationViewer<N, E> master) {
            this.vv = vv;
            this.master = master;
        }

        @Override
        public void paint(Graphics g) {
            MutableTransformer masterViewTransformer = this.master.getRenderContext().getMultiLayerTransformer().getTransformer(MultiLayerTransformer.Layer.VIEW);
            MutableTransformer masterLayoutTransformer = this.master.getRenderContext().getMultiLayerTransformer().getTransformer(MultiLayerTransformer.Layer.LAYOUT);
            MutableTransformer vvLayoutTransformer = this.vv.getRenderContext().getMultiLayerTransformer().getTransformer(MultiLayerTransformer.Layer.LAYOUT);
            Shape lens = this.master.getBounds();
            lens = masterViewTransformer.inverseTransform(lens);
            lens = masterLayoutTransformer.inverseTransform(lens);
            lens = vvLayoutTransformer.transform(lens);
            Graphics2D g2d = (Graphics2D)g;
            Color old = g.getColor();
            Color lensColor = this.master.getBackground();
            this.vv.setBackground(lensColor.darker());
            g.setColor(lensColor);
            g2d.fill(lens);
            g.setColor(Color.gray);
            g2d.draw(lens);
            g.setColor(old);
        }

        @Override
        public boolean useTransform() {
            return true;
        }
    }
}

