/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization.control;

import com.google.common.base.Preconditions;
import com.google.common.graph.MutableNetwork;
import edu.uci.ics.jung.visualization.BasicVisualizationServer;
import edu.uci.ics.jung.visualization.VisualizationModel;
import edu.uci.ics.jung.visualization.control.NodeSupport;
import java.awt.geom.Point2D;
import java.util.function.Supplier;

public class SimpleNodeSupport<N, E>
implements NodeSupport<N, E> {
    protected Supplier<N> nodeFactory;

    public SimpleNodeSupport(Supplier<N> nodeFactory) {
        this.nodeFactory = nodeFactory;
    }

    @Override
    public void startNodeCreate(BasicVisualizationServer<N, E> vv, Point2D point) {
        Preconditions.checkState((boolean)(vv.getModel().getNetwork() instanceof MutableNetwork), (Object)"graph must be mutable");
        N newNode = this.nodeFactory.get();
        VisualizationModel<N, E> visualizationModel = vv.getModel();
        MutableNetwork graph = (MutableNetwork)visualizationModel.getNetwork();
        graph.addNode(newNode);
        Point2D p2d = vv.getRenderContext().getMultiLayerTransformer().inverseTransform(point);
        visualizationModel.getLayoutModel().set(newNode, p2d.getX(), p2d.getY());
        vv.repaint();
    }

    @Override
    public void midNodeCreate(BasicVisualizationServer<N, E> vv, Point2D point) {
    }

    @Override
    public void endNodeCreate(BasicVisualizationServer<N, E> vv, Point2D point) {
    }

    public Supplier<N> getNodeFactory() {
        return this.nodeFactory;
    }

    public void setNodeFactory(Supplier<N> nodeFactory) {
        this.nodeFactory = nodeFactory;
    }
}

