/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization.control;

import edu.uci.ics.jung.visualization.MultiLayerTransformer;
import edu.uci.ics.jung.visualization.VisualizationViewer;
import edu.uci.ics.jung.visualization.control.AbstractGraphMousePlugin;
import edu.uci.ics.jung.visualization.transform.MutableTransformer;
import java.awt.Cursor;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Point2D;

public class ViewTranslatingGraphMousePlugin
extends AbstractGraphMousePlugin
implements MouseListener,
MouseMotionListener {
    public ViewTranslatingGraphMousePlugin() {
        this(16);
    }

    public ViewTranslatingGraphMousePlugin(int modifiers) {
        super(modifiers);
        this.cursor = Cursor.getPredefinedCursor(13);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        VisualizationViewer vv = (VisualizationViewer)e.getSource();
        boolean accepted = this.checkModifiers(e);
        this.down = e.getPoint();
        if (accepted) {
            vv.setCursor(this.cursor);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        VisualizationViewer vv = (VisualizationViewer)e.getSource();
        this.down = null;
        vv.setCursor(Cursor.getPredefinedCursor(0));
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        VisualizationViewer vv = (VisualizationViewer)e.getSource();
        boolean accepted = this.checkModifiers(e);
        if (accepted) {
            MutableTransformer viewTransformer = vv.getRenderContext().getMultiLayerTransformer().getTransformer(MultiLayerTransformer.Layer.VIEW);
            vv.setCursor(this.cursor);
            try {
                Point2D q = viewTransformer.inverseTransform(this.down);
                Point2D p = viewTransformer.inverseTransform(e.getPoint());
                float dx = (float)(p.getX() - q.getX());
                float dy = (float)(p.getY() - q.getY());
                viewTransformer.translate(dx, dy);
                this.down.x = e.getX();
                this.down.y = e.getY();
            }
            catch (RuntimeException ex) {
                System.err.println("down = " + this.down + ", e = " + e);
                throw ex;
            }
            e.consume();
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }
}

