/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization.decorators;

import com.google.common.graph.EndpointPair;
import com.google.common.graph.Network;
import edu.uci.ics.jung.graph.util.Graphs;
import edu.uci.ics.jung.layout.model.LayoutModel;
import edu.uci.ics.jung.layout.model.Point;
import edu.uci.ics.jung.visualization.MultiLayerTransformer;
import edu.uci.ics.jung.visualization.VisualizationViewer;
import edu.uci.ics.jung.visualization.transform.BidirectionalTransformer;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Paint;
import java.awt.geom.Point2D;
import java.util.function.Function;

public class GradientEdgePaintFunction<N, E>
implements Function<E, Paint> {
    protected Color c1;
    protected Color c2;
    protected Network<N, E> graph;
    protected LayoutModel<N> layoutModel;
    protected BidirectionalTransformer transformer;

    public GradientEdgePaintFunction(Color c1, Color c2, VisualizationViewer<N, E> vv) {
        this.c1 = c1;
        this.c2 = c2;
        this.graph = vv.getModel().getNetwork();
        this.layoutModel = vv.getModel().getLayoutModel();
        this.transformer = vv.getRenderContext().getMultiLayerTransformer().getTransformer(MultiLayerTransformer.Layer.LAYOUT);
    }

    @Override
    public Paint apply(E e) {
        EndpointPair endpoints = this.graph.incidentNodes(e);
        Object b = endpoints.nodeU();
        Object f = endpoints.nodeV();
        Point pb = (Point)this.layoutModel.apply(b);
        Point pf = (Point)this.layoutModel.apply(f);
        Point2D p2db = this.transformer.transform(pb.x, pb.y);
        Point2D p2df = this.transformer.transform(pf.x, pf.y);
        float xB = (float)p2db.getX();
        float yB = (float)p2db.getY();
        float xF = (float)p2df.getX();
        float yF = (float)p2df.getY();
        if (!this.graph.isDirected()) {
            xF = (xF + xB) / 2.0f;
            yF = (yF + yB) / 2.0f;
        }
        if (Graphs.isSelfLoop((EndpointPair)endpoints)) {
            yF += 50.0f;
            xF += 50.0f;
        }
        return new GradientPaint(xB, yB, this.getColor1(e), xF, yF, this.getColor2(e), true);
    }

    protected Color getColor1(E e) {
        return this.c1;
    }

    protected Color getColor2(E e) {
        return this.c2;
    }
}

