/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization.layout;

import com.google.common.graph.Network;
import edu.uci.ics.jung.layout.model.LayoutModel;
import edu.uci.ics.jung.visualization.MultiLayerTransformer;
import edu.uci.ics.jung.visualization.RenderContext;
import edu.uci.ics.jung.visualization.VisualizationModel;
import edu.uci.ics.jung.visualization.VisualizationServer;
import edu.uci.ics.jung.visualization.layout.BoundingRectangleCollector;
import edu.uci.ics.jung.visualization.util.ChangeEventSupport;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class BoundingRectanglePaintable<N>
implements VisualizationServer.Paintable {
    protected RenderContext rc;
    protected Network graph;
    protected LayoutModel<N> layoutModel;
    protected List<Rectangle2D> rectangles;

    public BoundingRectanglePaintable(RenderContext rc, VisualizationModel<N, ?> visualizationModel) {
        this.rc = rc;
        this.layoutModel = visualizationModel.getLayoutModel();
        this.graph = visualizationModel.getNetwork();
        final BoundingRectangleCollector.Nodes brc = new BoundingRectangleCollector.Nodes(rc, visualizationModel);
        this.rectangles = brc.getRectangles();
        if (this.layoutModel instanceof ChangeEventSupport) {
            ((ChangeEventSupport)this.layoutModel).addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    brc.compute();
                    BoundingRectanglePaintable.this.rectangles = brc.getRectangles();
                }
            });
        }
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        g.setColor(Color.cyan);
        for (Rectangle2D r : this.rectangles) {
            g2d.draw(this.rc.getMultiLayerTransformer().transform(MultiLayerTransformer.Layer.LAYOUT, r));
        }
    }

    @Override
    public boolean useTransform() {
        return true;
    }
}

