/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization.layout;

import edu.uci.ics.jung.layout.algorithms.LayoutAlgorithm;
import edu.uci.ics.jung.layout.model.LayoutModel;
import edu.uci.ics.jung.visualization.VisualizationServer;
import edu.uci.ics.jung.visualization.layout.AnimationLayoutAlgorithm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LayoutAlgorithmTransition<N, E> {
    private static Logger log = LoggerFactory.getLogger(LayoutAlgorithmTransition.class);

    public static <N, E> void animate(VisualizationServer<N, E> visualizationServer, LayoutAlgorithm<N> endLayoutAlgorithm) {
        LayoutAlgorithmTransition.fireLayoutStateChanged(visualizationServer.getModel().getLayoutModel(), true);
        AnimationLayoutAlgorithm<N> transitionLayoutAlgorithm = new AnimationLayoutAlgorithm<N>(visualizationServer, endLayoutAlgorithm);
        visualizationServer.getModel().setLayoutAlgorithm((LayoutAlgorithm<N>)transitionLayoutAlgorithm);
    }

    public static <N, E> void apply(VisualizationServer<N, E> visualizationServer, LayoutAlgorithm<N> endLayoutAlgorithm) {
        visualizationServer.getModel().setLayoutAlgorithm(endLayoutAlgorithm);
    }

    private static void fireLayoutStateChanged(LayoutModel layoutModel, boolean state) {
        log.trace("fireLayoutStateChanged to {}", (Object)state);
        layoutModel.getLayoutStateChangeSupport().fireLayoutStateChanged(layoutModel, state);
    }
}

