/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization.layout;

import com.google.common.graph.EndpointPair;
import com.google.common.graph.Network;
import edu.uci.ics.jung.layout.model.LayoutModel;
import edu.uci.ics.jung.layout.model.Point;
import edu.uci.ics.jung.layout.util.RadiusNetworkNodeAccessor;
import edu.uci.ics.jung.visualization.layout.NetworkElementAccessor;
import java.awt.Shape;
import java.awt.geom.Point2D;
import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.Set;

public class RadiusNetworkElementAccessor<N, E>
extends RadiusNetworkNodeAccessor<N>
implements NetworkElementAccessor<N, E> {
    private final Network<N, E> network;

    public RadiusNetworkElementAccessor(Network<N, E> network) {
        this(network, Math.sqrt(Double.MAX_VALUE));
    }

    public RadiusNetworkElementAccessor(Network<N, E> network, double maxDistance) {
        super(maxDistance);
        this.network = network;
    }

    @Override
    public E getEdge(LayoutModel<N> layoutModel, Point2D p) {
        return this.getEdge(layoutModel, p.getX(), p.getY());
    }

    @Override
    public E getEdge(LayoutModel<N> layoutModel, double x, double y) {
        double minDistance = this.maxDistance * this.maxDistance;
        E closest = null;
        while (true) {
            try {
                for (Object edge : this.network.edges()) {
                    double distance2;
                    EndpointPair endpoints = this.network.incidentNodes(edge);
                    Object node1 = endpoints.nodeU();
                    Object node2 = endpoints.nodeV();
                    Point p1 = (Point)layoutModel.apply(node1);
                    Point p2 = (Point)layoutModel.apply(node2);
                    double x1 = p1.x;
                    double y1 = p1.y;
                    double x2 = p2.x;
                    double y2 = p2.y;
                    if (x1 == x2 && y1 == y2) continue;
                    double b = ((y - y1) * (y2 - y1) + (x - x1) * (x2 - x1)) / ((x2 - x1) * (x2 - x1) + (y2 - y1) * (y2 - y1));
                    if (b <= 0.0) {
                        distance2 = (x - x1) * (x - x1) + (y - y1) * (y - y1);
                    } else if (b >= 1.0) {
                        distance2 = (x - x2) * (x - x2) + (y - y2) * (y - y2);
                    } else {
                        double x3 = x1 + b * (x2 - x1);
                        double y3 = y1 + b * (y2 - y1);
                        distance2 = (x - x3) * (x - x3) + (y - y3) * (y - y3);
                    }
                    if (!(distance2 < minDistance)) continue;
                    minDistance = distance2;
                    closest = edge;
                }
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                continue;
            }
            break;
        }
        return closest;
    }

    @Override
    public Set<N> getNodes(LayoutModel<N> layoutModel, Shape rectangle) {
        HashSet pickednodes = new HashSet();
        while (true) {
            try {
                for (Object node : layoutModel.getGraph().nodes()) {
                    Point p = (Point)layoutModel.apply(node);
                    if (!rectangle.contains(p.x, p.y)) continue;
                    pickednodes.add(node);
                }
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                continue;
            }
            break;
        }
        return pickednodes;
    }
}

