/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization.properties;

import edu.uci.ics.jung.visualization.RenderContext;
import edu.uci.ics.jung.visualization.VisualizationModel;
import edu.uci.ics.jung.visualization.VisualizationServer;
import edu.uci.ics.jung.visualization.decorators.EdgeShape;
import edu.uci.ics.jung.visualization.decorators.PickableEdgePaintFunction;
import edu.uci.ics.jung.visualization.decorators.PickableNodePaintFunction;
import edu.uci.ics.jung.visualization.layout.BoundingRectangleCollector;
import edu.uci.ics.jung.visualization.renderers.Renderer;
import edu.uci.ics.jung.visualization.spatial.Spatial;
import edu.uci.ics.jung.visualization.spatial.SpatialGrid;
import edu.uci.ics.jung.visualization.spatial.SpatialQuadTree;
import edu.uci.ics.jung.visualization.spatial.SpatialRTree;
import edu.uci.ics.jung.visualization.spatial.rtree.QuadraticLeafSplitter;
import edu.uci.ics.jung.visualization.spatial.rtree.QuadraticSplitter;
import edu.uci.ics.jung.visualization.spatial.rtree.RStarLeafSplitter;
import edu.uci.ics.jung.visualization.spatial.rtree.RStarSplitter;
import edu.uci.ics.jung.visualization.spatial.rtree.SplitterContext;
import java.awt.Color;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VisualizationViewerUI<N, E> {
    private static final Logger log = LoggerFactory.getLogger(VisualizationViewerUI.class);
    private static final String PROPERTIES_FILE_NAME = "jung.properties";
    private static final String PREFIX = "jung.";
    private static final String NODE_SHAPE = "jung.nodeShape";
    private static final String NODE_SIZE = "jung.nodeSize";
    private static final String EDGE_SHAPE = "jung.edgeShape";
    private static final String NODE_COLOR = "jung.nodeColor";
    private static final String PICKED_NODE_COLOR = "jung.pickedNodeColor";
    private static final String EDGE_COLOR = "jung.edgeColor";
    private static final String PICKED_EDGE_COLOR = "jung.pickedEdgeColor";
    private static final String ARROW_STYLE = "jung.arrowStyle";
    private static final String NODE_SPATIAL_SUPPORT = "jung.nodeSpatialSupport";
    private static final String EDGE_SPATIAL_SUPPORT = "jung.edgeSpatialSupport";
    private static final String NODE_LABEL_POSITION = "jung.nodeLabelPosition";
    private static final String NODE_LABEL_COLOR = "jung.nodeLabelColor";
    VisualizationServer<N, E> vv;

    public static VisualizationViewerUI getInstance(VisualizationServer vv) {
        return new VisualizationViewerUI(vv);
    }

    VisualizationViewerUI(VisualizationServer<N, E> vv) {
        this.vv = vv;
    }

    private boolean loadFromAppName() {
        try {
            String launchProgram = System.getProperty("sun.java.command");
            if (launchProgram != null && !launchProgram.isEmpty()) {
                launchProgram = "/" + launchProgram.substring(launchProgram.lastIndexOf(46) + 1) + ".properties";
                InputStream stream = this.getClass().getResourceAsStream(launchProgram);
                System.getProperties().load(stream);
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private boolean loadFromDefault() {
        try {
            InputStream stream = this.getClass().getResourceAsStream("/jung.properties");
            System.getProperties().load(stream);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void parse() throws IOException {
        if (this.loadFromAppName() || this.loadFromDefault()) {
            Spatial<Object> spatial;
            RenderContext<Object, E> rc = this.vv.getRenderContext();
            this.setEdgeShape(System.getProperty(EDGE_SHAPE, "QUAD_CURVE"));
            rc.setNodeFillPaintFunction(new PickableNodePaintFunction<N>(this.vv.getPickedNodeState(), new Color(Integer.getInteger(NODE_COLOR, 0xFF0000)), new Color(Integer.getInteger(PICKED_NODE_COLOR, 65535))));
            rc.setEdgeDrawPaintFunction(new PickableEdgePaintFunction<E>(this.vv.getPickedEdgeState(), new Color(Integer.getInteger(EDGE_COLOR, 0xFF0000)), new Color(Integer.getInteger(PICKED_EDGE_COLOR, 65535))));
            rc.setNodeLabelDrawPaintFunction(n -> new Color(Integer.getInteger(NODE_LABEL_COLOR, 0)));
            int size = Integer.getInteger(NODE_SIZE, 12);
            this.vv.getRenderContext().setNodeShapeFunction(n -> this.getNodeShape(System.getProperty(NODE_SHAPE, "CIRCLE"), size));
            if (System.getProperty(NODE_SPATIAL_SUPPORT) != null && (spatial = this.createNodeSpatial(this.vv)) != null) {
                this.vv.setNodeSpatial(spatial);
            }
            if (System.getProperty(EDGE_SPATIAL_SUPPORT) != null && (spatial = this.createEdgeSpatial(this.vv)) != null) {
                this.vv.setEdgeSpatial(spatial);
            }
            this.vv.getRenderer().getNodeLabelRenderer().setPosition(this.getPosition(System.getProperty(NODE_LABEL_POSITION, "SE")));
        }
    }

    private Shape getNodeShape(String shape, int size) {
        switch (shape) {
            case "SQUARE": {
                return new Rectangle2D.Float((float)(-size) / 2.0f, (float)(-size) / 2.0f, size, size);
            }
        }
        return new Ellipse2D.Float((float)(-size) / 2.0f, (float)(-size) / 2.0f, size, size);
    }

    private Renderer.NodeLabel.Position getPosition(String position) {
        try {
            return Renderer.NodeLabel.Position.valueOf(position);
        }
        catch (Exception exception) {
            return Renderer.NodeLabel.Position.SE;
        }
    }

    private void setEdgeShape(String edgeShape) {
        RenderContext<N, E> rc = this.vv.getRenderContext();
        switch (edgeShape) {
            case "LINE": {
                rc.setEdgeShapeFunction(EdgeShape.line());
                break;
            }
            case "CUBIC_CURVE": {
                rc.setEdgeShapeFunction(EdgeShape.cubicCurve());
                break;
            }
            case "ORTHOGONAL": {
                rc.setEdgeShapeFunction(EdgeShape.orthogonal());
                break;
            }
            case "WEDGE": {
                rc.setEdgeShapeFunction(EdgeShape.wedge(10));
                break;
            }
            default: {
                rc.setEdgeShapeFunction(EdgeShape.quadCurve());
            }
        }
    }

    private VisualizationModel.SpatialSupport getNodeSpatialSupportPreference() {
        String spatialSupportProperty = System.getProperty(NODE_SPATIAL_SUPPORT, "RTREE");
        try {
            return VisualizationModel.SpatialSupport.valueOf(spatialSupportProperty);
        }
        catch (IllegalArgumentException ex) {
            log.warn("Unknown ModelStructure type {} ignored.", (Object)spatialSupportProperty);
            return VisualizationModel.SpatialSupport.QUADTREE;
        }
    }

    private VisualizationModel.SpatialSupport getEdgeSpatialSupportPreference() {
        String spatialSupportProperty = System.getProperty(EDGE_SPATIAL_SUPPORT, "RTREE");
        try {
            return VisualizationModel.SpatialSupport.valueOf(spatialSupportProperty);
        }
        catch (IllegalArgumentException ex) {
            log.warn("Unknown ModelStructure type {} ignored.", (Object)spatialSupportProperty);
            return VisualizationModel.SpatialSupport.NONE;
        }
    }

    private Spatial<N> createNodeSpatial(VisualizationServer<N, E> visualizationServer) {
        switch (this.getNodeSpatialSupportPreference()) {
            case RTREE: {
                return new SpatialRTree.Nodes(visualizationServer.getModel(), new BoundingRectangleCollector.Nodes(visualizationServer.getRenderContext(), visualizationServer.getModel()), SplitterContext.of(new RStarLeafSplitter(), new RStarSplitter()));
            }
            case GRID: {
                return new SpatialGrid<N>(visualizationServer.getModel().getLayoutModel());
            }
            case QUADTREE: {
                return new SpatialQuadTree<N>(visualizationServer.getModel().getLayoutModel());
            }
        }
        return new Spatial.NoOp.Node<N>(visualizationServer.getModel().getLayoutModel());
    }

    private Spatial<E> createEdgeSpatial(VisualizationServer<N, E> visualizationServer) {
        switch (this.getEdgeSpatialSupportPreference()) {
            case RTREE: {
                return new SpatialRTree.Edges(visualizationServer.getModel(), new BoundingRectangleCollector.Edges(visualizationServer.getRenderContext(), visualizationServer.getModel()), SplitterContext.of(new QuadraticLeafSplitter(), new QuadraticSplitter()));
            }
        }
        return new Spatial.NoOp.Edge<E, N>(visualizationServer.getModel());
    }
}

