/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization.renderers;

import edu.uci.ics.jung.layout.model.LayoutModel;
import edu.uci.ics.jung.layout.model.Point;
import edu.uci.ics.jung.visualization.MultiLayerTransformer;
import edu.uci.ics.jung.visualization.RenderContext;
import edu.uci.ics.jung.visualization.VisualizationModel;
import edu.uci.ics.jung.visualization.renderers.NodeLabelRenderer;
import edu.uci.ics.jung.visualization.renderers.Renderer;
import edu.uci.ics.jung.visualization.transform.BidirectionalTransformer;
import edu.uci.ics.jung.visualization.transform.shape.GraphicsDecorator;
import edu.uci.ics.jung.visualization.transform.shape.ShapeTransformer;
import edu.uci.ics.jung.visualization.transform.shape.TransformingGraphics;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class BasicNodeLabelRenderer<N, E>
implements Renderer.NodeLabel<N, E> {
    protected Renderer.NodeLabel.Position position = Renderer.NodeLabel.Position.SE;
    private Renderer.NodeLabel.Positioner positioner = new OutsidePositioner();

    @Override
    public Renderer.NodeLabel.Position getPosition() {
        return this.position;
    }

    @Override
    public void setPosition(Renderer.NodeLabel.Position position) {
        this.position = position;
    }

    public Component prepareRenderer(RenderContext<N, E> renderContext, LayoutModel<N> layoutModel, NodeLabelRenderer graphLabelRenderer, Object value, boolean isSelected, N node) {
        return renderContext.getNodeLabelRenderer().getNodeLabelRendererComponent(renderContext.getScreenDevice(), value, renderContext.getNodeFontFunction().apply(node), isSelected, node);
    }

    @Override
    public void labelNode(RenderContext<N, E> renderContext, VisualizationModel<N, E> visualizationModel, N v, String label) {
        BidirectionalTransformer transformer;
        if (!renderContext.getNodeIncludePredicate().test(v)) {
            return;
        }
        LayoutModel<N> layoutModel = visualizationModel.getLayoutModel();
        Point pt = (Point)layoutModel.apply(v);
        Point2D pt2d = renderContext.getMultiLayerTransformer().transform(MultiLayerTransformer.Layer.LAYOUT, new Point2D.Double(pt.x, pt.y));
        float x = (float)pt2d.getX();
        float y = (float)pt2d.getY();
        Component component = this.prepareRenderer(renderContext, layoutModel, renderContext.getNodeLabelRenderer(), label, renderContext.getPickedNodeState().isPicked(v), v);
        GraphicsDecorator g = renderContext.getGraphicsContext();
        Dimension d = component.getPreferredSize();
        AffineTransform xform = AffineTransform.getTranslateInstance(x, y);
        Shape shape = renderContext.getNodeShapeFunction().apply(v);
        shape = xform.createTransformedShape(shape);
        if (renderContext.getGraphicsContext() instanceof TransformingGraphics && (transformer = ((TransformingGraphics)renderContext.getGraphicsContext()).getTransformer()) instanceof ShapeTransformer) {
            ShapeTransformer shapeTransformer = (ShapeTransformer)transformer;
            shape = shapeTransformer.transform(shape);
        }
        Rectangle2D bounds = shape.getBounds2D();
        Point p = null;
        if (this.position == Renderer.NodeLabel.Position.AUTO) {
            Dimension vvd = renderContext.getScreenDevice().getSize();
            if (vvd.width == 0 || vvd.height == 0) {
                vvd = renderContext.getScreenDevice().getPreferredSize();
            }
            p = this.getAnchorPoint(bounds, d, this.positioner.getPosition(x, y, vvd));
        } else {
            p = this.getAnchorPoint(bounds, d, this.position);
        }
        Paint fillPaint = renderContext.getNodeLabelDrawPaintFunction().apply(v);
        if (fillPaint != null) {
            Color oldPaint = component.getForeground();
            component.setForeground((Color)fillPaint);
            g.draw(component, renderContext.getRendererPane(), (int)p.x, (int)p.y, d.width, d.height, true);
            component.setForeground(oldPaint);
        } else {
            g.draw(component, renderContext.getRendererPane(), (int)p.x, (int)p.y, d.width, d.height, true);
        }
    }

    protected Point getAnchorPoint(Rectangle2D nodeBounds, Dimension labelSize, Renderer.NodeLabel.Position position) {
        int offset = 5;
        switch (position) {
            case N: {
                double x = nodeBounds.getCenterX() - (double)(labelSize.width / 2);
                double y = nodeBounds.getMinY() - (double)offset - (double)labelSize.height;
                return Point.of((double)x, (double)y);
            }
            case NE: {
                double x = nodeBounds.getMaxX() + (double)offset;
                double y = nodeBounds.getMinY() - (double)offset - (double)labelSize.height;
                return Point.of((double)x, (double)y);
            }
            case E: {
                double x = nodeBounds.getMaxX() + (double)offset;
                double y = nodeBounds.getCenterY() - (double)(labelSize.height / 2);
                return Point.of((double)x, (double)y);
            }
            case SE: {
                double x = nodeBounds.getMaxX() + (double)offset;
                double y = nodeBounds.getMaxY() + (double)offset;
                return Point.of((double)x, (double)y);
            }
            case S: {
                double x = nodeBounds.getCenterX() - (double)(labelSize.width / 2);
                double y = nodeBounds.getMaxY() + (double)offset;
                return Point.of((double)x, (double)y);
            }
            case SW: {
                double x = nodeBounds.getMinX() - (double)offset - (double)labelSize.width;
                double y = nodeBounds.getMaxY() + (double)offset;
                return Point.of((double)x, (double)y);
            }
            case W: {
                double x = nodeBounds.getMinX() - (double)offset - (double)labelSize.width;
                double y = nodeBounds.getCenterY() - (double)(labelSize.height / 2);
                return Point.of((double)x, (double)y);
            }
            case NW: {
                double x = nodeBounds.getMinX() - (double)offset - (double)labelSize.width;
                double y = nodeBounds.getMinY() - (double)offset - (double)labelSize.height;
                return Point.of((double)x, (double)y);
            }
            case CNTR: {
                double x = nodeBounds.getCenterX() - (double)(labelSize.width / 2);
                double y = nodeBounds.getCenterY() - (double)(labelSize.height / 2);
                return Point.of((double)x, (double)y);
            }
        }
        return Point.ORIGIN;
    }

    @Override
    public Renderer.NodeLabel.Positioner getPositioner() {
        return this.positioner;
    }

    @Override
    public void setPositioner(Renderer.NodeLabel.Positioner positioner) {
        this.positioner = positioner;
    }

    public static class OutsidePositioner
    implements Renderer.NodeLabel.Positioner {
        @Override
        public Renderer.NodeLabel.Position getPosition(float x, float y, Dimension d) {
            int cx = d.width / 2;
            int cy = d.height / 2;
            if (x > (float)cx && y > (float)cy) {
                return Renderer.NodeLabel.Position.SE;
            }
            if (x > (float)cx && y < (float)cy) {
                return Renderer.NodeLabel.Position.NE;
            }
            if (x < (float)cx && y > (float)cy) {
                return Renderer.NodeLabel.Position.SW;
            }
            return Renderer.NodeLabel.Position.NW;
        }
    }

    public static class InsidePositioner
    implements Renderer.NodeLabel.Positioner {
        @Override
        public Renderer.NodeLabel.Position getPosition(float x, float y, Dimension d) {
            int cx = d.width / 2;
            int cy = d.height / 2;
            if (x > (float)cx && y > (float)cy) {
                return Renderer.NodeLabel.Position.NW;
            }
            if (x > (float)cx && y < (float)cy) {
                return Renderer.NodeLabel.Position.SW;
            }
            if (x < (float)cx && y > (float)cy) {
                return Renderer.NodeLabel.Position.NE;
            }
            return Renderer.NodeLabel.Position.SE;
        }
    }
}

