/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization.renderers;

import edu.uci.ics.jung.visualization.RenderContext;
import edu.uci.ics.jung.visualization.VisualizationModel;
import edu.uci.ics.jung.visualization.renderers.EdgeArrowRenderingSupport;
import edu.uci.ics.jung.visualization.spatial.Spatial;
import java.awt.Dimension;

public interface Renderer<N, E> {
    public void render(RenderContext<N, E> var1, VisualizationModel<N, E> var2, Spatial<N> var3, Spatial<E> var4);

    public void render(RenderContext<N, E> var1, VisualizationModel<N, E> var2);

    public void renderNode(RenderContext<N, E> var1, VisualizationModel<N, E> var2, N var3);

    public void renderNodeLabel(RenderContext<N, E> var1, VisualizationModel<N, E> var2, N var3);

    public void renderEdge(RenderContext<N, E> var1, VisualizationModel<N, E> var2, E var3);

    public void renderEdgeLabel(RenderContext<N, E> var1, VisualizationModel<N, E> var2, E var3);

    public void setNodeRenderer(Node<N, E> var1);

    public void setEdgeRenderer(Edge<N, E> var1);

    public void setNodeLabelRenderer(NodeLabel<N, E> var1);

    public void setEdgeLabelRenderer(EdgeLabel<N, E> var1);

    public NodeLabel<N, E> getNodeLabelRenderer();

    public Node<N, E> getNodeRenderer();

    public Edge<N, E> getEdgeRenderer();

    public EdgeLabel<N, E> getEdgeLabelRenderer();

    public static interface EdgeLabel<N, E> {
        public void labelEdge(RenderContext<N, E> var1, VisualizationModel<N, E> var2, E var3, String var4);

        public static class NOOP<N, E>
        implements EdgeLabel<N, E> {
            @Override
            public void labelEdge(RenderContext<N, E> renderContext, VisualizationModel<N, E> visualizationModel, E e, String label) {
            }
        }
    }

    public static interface NodeLabel<N, E> {
        public void labelNode(RenderContext<N, E> var1, VisualizationModel<N, E> var2, N var3, String var4);

        public Position getPosition();

        public void setPosition(Position var1);

        public void setPositioner(Positioner var1);

        public Positioner getPositioner();

        public static interface Positioner {
            public Position getPosition(float var1, float var2, Dimension var3);
        }

        public static enum Position {
            N,
            NE,
            E,
            SE,
            S,
            SW,
            W,
            NW,
            CNTR,
            AUTO;

        }

        public static class NOOP<N, E>
        implements NodeLabel<N, E> {
            @Override
            public void labelNode(RenderContext<N, E> renderContext, VisualizationModel<N, E> visualizationModel, N v, String label) {
            }

            @Override
            public Position getPosition() {
                return Position.CNTR;
            }

            @Override
            public void setPosition(Position position) {
            }

            @Override
            public Positioner getPositioner() {
                return new Positioner(){

                    @Override
                    public Position getPosition(float x, float y, Dimension d) {
                        return Position.CNTR;
                    }
                };
            }

            @Override
            public void setPositioner(Positioner positioner) {
            }
        }
    }

    public static interface Edge<N, E> {
        public void paintEdge(RenderContext<N, E> var1, VisualizationModel<N, E> var2, E var3);

        public EdgeArrowRenderingSupport<N, E> getEdgeArrowRenderingSupport();

        public void setEdgeArrowRenderingSupport(EdgeArrowRenderingSupport<N, E> var1);

        public static class NOOP<N, E>
        implements Edge<N, E> {
            @Override
            public void paintEdge(RenderContext<N, E> renderContext, VisualizationModel<N, E> visualizationModel, E e) {
            }

            @Override
            public EdgeArrowRenderingSupport getEdgeArrowRenderingSupport() {
                return null;
            }

            @Override
            public void setEdgeArrowRenderingSupport(EdgeArrowRenderingSupport edgeArrowRenderingSupport) {
            }
        }
    }

    public static interface Node<N, E> {
        public void paintNode(RenderContext<N, E> var1, VisualizationModel<N, E> var2, N var3);

        public static class NOOP<N, E>
        implements Node<N, E> {
            @Override
            public void paintNode(RenderContext<N, E> renderContext, VisualizationModel<N, E> visualizationModel, N v) {
            }
        }
    }
}

