/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization.spatial;

import com.google.common.collect.Sets;
import edu.uci.ics.jung.layout.model.LayoutModel;
import edu.uci.ics.jung.layout.model.Point;
import edu.uci.ics.jung.layout.util.RadiusNetworkNodeAccessor;
import edu.uci.ics.jung.visualization.VisualizationModel;
import edu.uci.ics.jung.visualization.layout.RadiusNetworkElementAccessor;
import edu.uci.ics.jung.visualization.spatial.AbstractSpatial;
import edu.uci.ics.jung.visualization.spatial.TreeNode;
import java.awt.Shape;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public interface Spatial<T>
extends LayoutModel.LayoutStateChangeListener {
    public void setActive(boolean var1);

    public boolean isActive();

    public List<Shape> getGrid();

    public Collection<Shape> getPickShapes();

    public void clear();

    public void recalculate();

    public Rectangle2D getLayoutArea();

    public void setBounds(Rectangle2D var1);

    default public Rectangle2D getUnion(Rectangle2D rect, Point2D p) {
        rect.add(p);
        return rect;
    }

    default public Rectangle2D getUnion(Rectangle2D rect, double x, double y) {
        rect.add(x, y);
        return rect;
    }

    public void update(T var1, Point var2);

    public Set<? extends TreeNode> getContainingLeafs(Point2D var1);

    public Set<? extends TreeNode> getContainingLeafs(double var1, double var3);

    public TreeNode getContainingLeaf(Object var1);

    public Set<T> getVisibleElements(Shape var1);

    public T getClosestElement(Point2D var1);

    public T getClosestElement(double var1, double var3);

    public static abstract class NoOp<T, NT>
    extends AbstractSpatial<T, NT> {
        private TreeNode treeNode;

        public NoOp(LayoutModel<NT> layoutModel) {
            super(layoutModel);
            this.treeNode = new DegenerateTreeNode<NT>(layoutModel);
        }

        @Override
        public List<Shape> getGrid() {
            return Collections.singletonList(this.getLayoutArea());
        }

        @Override
        public void clear() {
        }

        @Override
        public void recalculate() {
        }

        @Override
        public Rectangle2D getLayoutArea() {
            return new Rectangle2D.Double(0.0, 0.0, this.layoutModel.getWidth(), this.layoutModel.getHeight());
        }

        @Override
        public void setBounds(Rectangle2D bounds) {
        }

        @Override
        public void update(T element, Point location) {
        }

        @Override
        public Set<? extends TreeNode> getContainingLeafs(Point2D p) {
            return Collections.singleton(this.treeNode);
        }

        @Override
        public Set<? extends TreeNode> getContainingLeafs(double x, double y) {
            return Collections.singleton(this.treeNode);
        }

        @Override
        public TreeNode getContainingLeaf(Object element) {
            return this.treeNode;
        }

        public static class Edge<E, N>
        extends NoOp<E, N> {
            private VisualizationModel<N, E> visualizationModel;
            RadiusNetworkElementAccessor<N, E> accessor;

            public Edge(VisualizationModel<N, E> visualizationModel) {
                super(visualizationModel.getLayoutModel());
                this.visualizationModel = visualizationModel;
                this.accessor = new RadiusNetworkElementAccessor<N, E>(visualizationModel.getNetwork());
            }

            @Override
            public Set<E> getVisibleElements(Shape shape) {
                return Sets.newHashSet((Iterable)this.visualizationModel.getNetwork().edges());
            }

            @Override
            public void setActive(boolean active) {
            }

            @Override
            public E getClosestElement(Point2D p) {
                return this.getClosestElement(p.getX(), p.getY());
            }

            @Override
            public E getClosestElement(double x, double y) {
                return this.accessor.getEdge(this.layoutModel, x, y);
            }
        }

        public static class Node<N>
        extends NoOp<N, N> {
            RadiusNetworkNodeAccessor<N> accessor = new RadiusNetworkNodeAccessor();

            public Node(LayoutModel<N> layoutModel) {
                super(layoutModel);
            }

            @Override
            public Set<N> getVisibleElements(Shape shape) {
                return Sets.newHashSet((Iterable)this.layoutModel.getGraph().nodes());
            }

            @Override
            public void setActive(boolean active) {
            }

            @Override
            public N getClosestElement(Point2D p) {
                return this.getClosestElement(p.getX(), p.getY());
            }

            @Override
            public N getClosestElement(double x, double y) {
                return null;
            }
        }

        public static class DegenerateTreeNode<N>
        implements TreeNode {
            LayoutModel<N> layoutModel;

            public DegenerateTreeNode(LayoutModel<N> layoutModel) {
                this.layoutModel = layoutModel;
            }

            @Override
            public Rectangle2D getBounds() {
                return new Rectangle2D.Double(0.0, 0.0, this.layoutModel.getWidth(), this.layoutModel.getHeight());
            }

            public List<? extends TreeNode> getChildren() {
                return Collections.emptyList();
            }
        }
    }
}

