/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization.spatial;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import edu.uci.ics.jung.layout.model.LayoutModel;
import edu.uci.ics.jung.layout.model.Point;
import edu.uci.ics.jung.visualization.spatial.AbstractSpatial;
import edu.uci.ics.jung.visualization.spatial.Spatial;
import edu.uci.ics.jung.visualization.spatial.TreeNode;
import java.awt.Dimension;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpatialGrid<N>
extends AbstractSpatial<N, N>
implements Spatial<N>,
TreeNode {
    private static final Logger log = LoggerFactory.getLogger(SpatialGrid.class);
    private int horizontalCount;
    private int verticalCount;
    private Dimension size;
    private Multimap<Integer, N> map = Multimaps.synchronizedListMultimap((ListMultimap)ArrayListMultimap.create());
    private double boxWidth;
    private double boxHeight;
    private Rectangle2D layoutArea;
    private List<Shape> gridCache;

    public SpatialGrid(LayoutModel<N> layoutModel) {
        super(layoutModel);
        this.horizontalCount = 10;
        this.verticalCount = 10;
        this.setBounds(new Rectangle2D.Double(0.0, 0.0, layoutModel.getWidth(), layoutModel.getHeight()));
    }

    public SpatialGrid(LayoutModel<N> layoutModel, Rectangle2D bounds, int horizontalCount, int verticalCount) {
        super(layoutModel);
        this.horizontalCount = horizontalCount;
        this.verticalCount = verticalCount;
        this.setBounds(bounds);
    }

    @Override
    public void setBounds(Rectangle2D bounds) {
        this.size = bounds.getBounds().getSize();
        this.layoutArea = bounds;
        this.boxWidth = this.size.getWidth() / (double)this.horizontalCount;
        this.boxHeight = this.size.getHeight() / (double)this.verticalCount;
        this.gridCache = null;
    }

    @Override
    public Set<TreeNode> getContainingLeafs(Point2D p) {
        int boxNumber = this.getBoxNumberFromLocation(p.getX(), p.getY());
        Rectangle2D r = (Rectangle2D)this.gridCache.get(boxNumber);
        SpatialGrid<N> grid = new SpatialGrid<N>(this.layoutModel, r, 1, 1);
        return Collections.singleton(grid);
    }

    @Override
    public Set<TreeNode> getContainingLeafs(double x, double y) {
        return this.getContainingLeafs(new Point2D.Double(x, y));
    }

    @Override
    public TreeNode getContainingLeaf(Object element) {
        for (Map.Entry entry : this.map.asMap().entrySet()) {
            if (!((Collection)entry.getValue()).contains(element)) continue;
            int index = (Integer)entry.getKey();
            Rectangle2D r = (Rectangle2D)this.gridCache.get(index);
            return new SpatialGrid<N>(this.layoutModel, r, 1, 1);
        }
        return null;
    }

    public static <N> List<Shape> getGrid(List<Shape> list, SpatialGrid<N> grid) {
        list.addAll(grid.getGrid());
        return list;
    }

    @Override
    public List<Shape> getGrid() {
        if (this.gridCache == null) {
            this.gridCache = Lists.newArrayList();
            for (int j = 0; j < this.verticalCount; ++j) {
                for (int i = 0; i < this.horizontalCount; ++i) {
                    this.gridCache.add(new Rectangle2D.Double(this.layoutArea.getX() + (double)i * this.boxWidth, this.layoutArea.getY() + (double)j * this.boxHeight, this.boxWidth, this.boxHeight));
                }
            }
        }
        return this.gridCache;
    }

    public Multimap<Integer, N> getMap() {
        return this.map;
    }

    protected int getBoxNumber(int boxX, int boxY) {
        if (log.isTraceEnabled() && log.isTraceEnabled()) {
            log.trace("{},{} clamped to {},{}", new Object[]{boxX, boxY, Math.max(0, Math.min(boxX, this.horizontalCount - 1)), Math.max(0, Math.min(boxY, this.verticalCount - 1))});
        }
        boxX = Math.max(0, Math.min(boxX, this.horizontalCount - 1));
        boxY = Math.max(0, Math.min(boxY, this.verticalCount - 1));
        if (log.isTraceEnabled()) {
            log.trace("getBoxNumber({},{}):{}", new Object[]{boxX, boxY, boxY * this.horizontalCount + boxX});
        }
        return boxY * this.horizontalCount + boxX;
    }

    protected int getBoxNumber(int[] boxXY) {
        return this.getBoxNumber(boxXY[0], boxXY[1]);
    }

    protected int getBoxNumberFromLocation(Point p) {
        int count = 0;
        for (Shape shape : this.getGrid()) {
            Rectangle2D r = shape.getBounds2D();
            if (r.contains(p.x, p.y) || r.intersects(p.x, p.y, 1.0, 1.0)) {
                return count;
            }
            ++count;
        }
        log.trace("no box for  {}", (Object)p);
        return -1;
    }

    protected int getBoxNumberFromLocation(double x, double y) {
        int count = 0;
        for (Shape shape : this.getGrid()) {
            Rectangle2D r = shape.getBounds2D();
            if (r.contains(x, y) || r.intersects(x, y, 1.0, 1.0)) {
                return count;
            }
            ++count;
        }
        log.trace("no box for {},{}", (Object)x, (Object)y);
        return -1;
    }

    protected int[] getBoxIndex(double x, double y) {
        int[] boxIndex = new int[2];
        int hcount = 0;
        int vcount = 0;
        for (Shape r : this.getGrid()) {
            if (r.contains(new Point2D.Double(x, y))) {
                boxIndex = new int[]{hcount, vcount};
                break;
            }
            if (++hcount < this.horizontalCount) continue;
            hcount = 0;
            ++vcount;
        }
        if (log.isTraceEnabled()) {
            log.trace("boxIndex for ({},{}) is {}", new Object[]{x, y, Arrays.toString(boxIndex)});
        }
        return boxIndex;
    }

    @Override
    public void recalculate() {
        if (this.isActive()) {
            this.recalculate(this.layoutModel.getGraph().nodes());
        }
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    public void recalculate(Collection<N> nodes) {
        this.clear();
        while (true) {
            try {
                for (N node : nodes) {
                    this.map.put((Object)this.getBoxNumberFromLocation((Point)this.layoutModel.apply(node)), node);
                }
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(N node, Point location) {
        if (this.isActive()) {
            int rightBox;
            if (!this.getLayoutArea().contains(location.x, location.y)) {
                log.trace(location + " outside of spatial " + this.getLayoutArea());
                this.setBounds(this.getUnion(this.getLayoutArea(), location.x, location.y));
                this.recalculate(this.layoutModel.getGraph().nodes());
            }
            if (this.map.get((Object)(rightBox = this.getBoxNumberFromLocation((Point)this.layoutModel.apply(node)))).contains(node)) {
                return;
            }
            Integer wrongBox = null;
            Multimap<Integer, N> multimap = this.map;
            synchronized (multimap) {
                for (Integer box : this.map.keySet()) {
                    if (!this.map.get((Object)box).contains(node)) continue;
                    wrongBox = box;
                    break;
                }
            }
            if (wrongBox != null) {
                this.map.remove(wrongBox, node);
            }
            this.map.put((Object)rightBox, node);
        }
    }

    @Override
    public N getClosestElement(Point2D p) {
        return this.getClosestElement(p.getX(), p.getY());
    }

    @Override
    public N getClosestElement(double x, double y) {
        if (!this.isActive()) {
            return (N)this.fallback.getNode(this.layoutModel, x, y);
        }
        Set<TreeNode> leafs = this.getContainingLeafs(x, y);
        if (leafs.size() != 0) {
            TreeNode leaf = (TreeNode)leafs.iterator().next();
            Rectangle2D area = leaf.getBounds();
            double radius = area.getWidth();
            N closest = null;
            while (closest == null) {
                double diameter = radius * 2.0;
                Ellipse2D.Double searchArea = new Ellipse2D.Double(x - radius, y - radius, diameter, diameter);
                Set<N> nodes = this.getVisibleElements(searchArea);
                closest = this.getClosest(nodes, x, y, radius);
                if (nodes.size() >= this.layoutModel.getGraph().nodes().size()) break;
                radius *= 2.0;
            }
            return closest;
        }
        return null;
    }

    protected Collection<Integer> getVisibleTiles(Shape visibleArea) {
        HashSet visibleTiles = Sets.newHashSet();
        List<Shape> grid = this.getGrid();
        for (int i = 0; i < this.horizontalCount * this.verticalCount; ++i) {
            if (!visibleArea.intersects(grid.get(i).getBounds2D())) continue;
            visibleTiles.add(i);
        }
        if (log.isDebugEnabled()) {
            log.debug("visible boxes:{}", (Object)visibleTiles);
        }
        return visibleTiles;
    }

    @Override
    public Set<N> getVisibleElements(Shape visibleArea) {
        if (!this.isActive()) {
            log.trace("not active so getting from the graph");
            return this.layoutModel.getGraph().nodes();
        }
        this.pickShapes.add(visibleArea);
        Area area = new Area(visibleArea);
        area.intersect(new Area(this.layoutArea));
        if (log.isTraceEnabled()) {
            log.trace("map is {}", this.map);
        }
        HashSet visibleNodes = Sets.newHashSet();
        Collection<Integer> tiles = this.getVisibleTiles(area);
        for (Integer index : tiles) {
            Collection toAdd = this.map.get((Object)index);
            if (toAdd.size() <= 0) continue;
            visibleNodes.addAll(toAdd);
            if (!log.isTraceEnabled()) continue;
            log.trace("added all of: {} from index {} to visibleNodes", (Object)toAdd, (Object)index);
        }
        if (log.isDebugEnabled()) {
            log.debug("visibleNodes:{}", (Object)visibleNodes);
        }
        return visibleNodes;
    }

    @Override
    public Rectangle2D getLayoutArea() {
        return this.layoutArea;
    }

    @Override
    public Rectangle2D getBounds() {
        return this.layoutArea;
    }

    @Override
    public Collection<? extends TreeNode> getChildren() {
        return null;
    }
}

