/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization.spatial.rtree;

import edu.uci.ics.jung.visualization.spatial.rtree.InnerNode;
import edu.uci.ics.jung.visualization.spatial.rtree.Node;
import java.awt.geom.Rectangle2D;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSplitter<T> {
    private static final Logger log = LoggerFactory.getLogger(AbstractSplitter.class);

    protected Optional<Node<T>> leastEnlargementThenAreaThenKids(InnerNode<T> nodeToSplit, Rectangle2D incoming) {
        double leastEnlargement = Double.MAX_VALUE;
        Optional<Node<T>> winner = Optional.empty();
        Optional<Object> winningUnion = Optional.empty();
        for (Node kid : nodeToSplit.getChildren()) {
            Rectangle2D kidRectangle = kid.getBounds();
            Rectangle2D union = kidRectangle.createUnion(incoming);
            double kidArea = Node.area(kidRectangle);
            double unionArea = Node.area(union);
            double enlargement = unionArea - kidArea;
            if (!winner.isPresent()) {
                winner = Optional.of(kid);
                winningUnion = Optional.of(kidRectangle);
            }
            double winnerArea = Node.area((Rectangle2D)winningUnion.get());
            if (enlargement == leastEnlargement) {
                log.trace("we have a tie for enlargement {}", (Object)enlargement);
                log.trace("compare the areas {} and {}", (Object)unionArea, (Object)winnerArea);
                if (unionArea == winnerArea) {
                    log.trace("a tie for unionArea and winnerArea, now compare child counts");
                    if (kid.size() >= winner.get().size()) continue;
                    log.trace("the new kid has fewer children. choose it");
                    winner = Optional.of(kid);
                    winningUnion = Optional.of(union);
                    leastEnlargement = enlargement;
                    continue;
                }
                if (!(unionArea < winnerArea)) continue;
                log.trace("unionArea is smaller than the previous winner");
                leastEnlargement = enlargement;
                winningUnion = Optional.of(union);
                winner = Optional.of(kid);
                continue;
            }
            if (!(enlargement < leastEnlargement)) continue;
            leastEnlargement = enlargement;
            winningUnion = Optional.of(union);
            winner = Optional.of(kid);
        }
        if (winner == null) {
            winner = Optional.of(nodeToSplit);
        }
        return winner;
    }

    protected Optional<Node<T>> leastOverlapThenEnlargementThenAreaThenKids(InnerNode<T> nodeToSplit, Rectangle2D bounds) {
        double leastOverlap = Double.MAX_VALUE;
        double leastEnlargement = Double.MAX_VALUE;
        Optional<Node<T>> winner = Optional.empty();
        Optional<Object> winningUnion = Optional.empty();
        for (Node kid : nodeToSplit.getChildren()) {
            Rectangle2D kidRectangle = kid.getBounds();
            double overlap = Node.overlap(kid.getBounds(), bounds);
            if (!winner.isPresent()) {
                winner = Optional.of(kid);
                leastOverlap = overlap;
                winningUnion = Optional.of(kid.getBounds().createUnion(bounds));
                log.trace("won as first");
                continue;
            }
            if (overlap == leastOverlap) {
                log.trace("tie on overlap {} == {}", (Object)overlap, (Object)leastOverlap);
                Rectangle2D union = kidRectangle.createUnion(bounds);
                double kidArea = Node.area(kidRectangle);
                double unionArea = Node.area(union);
                double enlargement = unionArea - kidArea;
                double winnerArea = Node.area((Rectangle2D)winningUnion.get());
                if (enlargement == leastEnlargement) {
                    log.trace("tie on enlargement {} == {}", (Object)enlargement, (Object)leastEnlargement);
                    log.trace("we have a tie for enlargement {}", (Object)enlargement);
                    log.trace("compare the areas {} and {}", (Object)unionArea, (Object)winnerArea);
                    if (unionArea == winnerArea) {
                        log.trace("tie on area {} == {}", (Object)unionArea, (Object)winnerArea);
                        log.trace("a tie for unionArea and winnerArea, now compare child counts");
                        if (kid.size() < winner.get().size()) {
                            log.trace("the new kid has fewer children. choose it");
                            winner = Optional.of(kid);
                            winningUnion = Optional.of(union);
                            leastEnlargement = enlargement;
                            log.trace("won on kid size {} < {}", (Object)kid.size(), (Object)winner.get().size());
                            continue;
                        }
                        log.trace("kept winner based on kid size {} >= {}", (Object)kid.size(), (Object)winner.get().size());
                        continue;
                    }
                    if (!(unionArea < winnerArea)) continue;
                    log.trace("won on area {} < {}", (Object)unionArea, (Object)winnerArea);
                    leastEnlargement = enlargement;
                    winningUnion = Optional.of(union);
                    winner = Optional.of(kid);
                    continue;
                }
                if (!(enlargement < leastEnlargement)) continue;
                log.trace("won on enlargement {} < {}", (Object)enlargement, (Object)leastEnlargement);
                leastEnlargement = enlargement;
                winningUnion = Optional.of(union);
                winner = Optional.of(kid);
                continue;
            }
            if (!(overlap < leastOverlap)) continue;
            log.trace("won on overlap {} < {}", (Object)overlap, (Object)leastOverlap);
            leastOverlap = overlap;
            winner = Optional.of(kid);
        }
        if (!winner.isPresent()) {
            winner = Optional.of(nodeToSplit);
        }
        return winner;
    }
}

