/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization.spatial.rtree;

import edu.uci.ics.jung.visualization.spatial.TreeNode;
import edu.uci.ics.jung.visualization.spatial.rtree.InnerNode;
import edu.uci.ics.jung.visualization.spatial.rtree.Node;
import edu.uci.ics.jung.visualization.spatial.rtree.NodeMap;
import edu.uci.ics.jung.visualization.spatial.rtree.Pair;
import edu.uci.ics.jung.visualization.spatial.rtree.RTreeNode;
import edu.uci.ics.jung.visualization.spatial.rtree.SplitterContext;
import java.awt.Shape;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LeafNode<T>
extends RTreeNode<T>
implements Node<T> {
    private static final Logger log = LoggerFactory.getLogger(LeafNode.class);
    final NodeMap<T> map = new NodeMap();
    public static LeafNode EMPTY = new LeafNode();

    public static <T> LeafNode<T> create(Map.Entry<T, Rectangle2D> entry) {
        return new LeafNode<T>(entry);
    }

    public static <T> LeafNode<T> create(T element, Rectangle2D bounds) {
        return new LeafNode<T>(element, bounds);
    }

    public static <T> LeafNode<T> create(Collection<Map.Entry<T, Rectangle2D>> entries) {
        return new LeafNode<T>(entries);
    }

    LeafNode(Collection<Map.Entry<T, Rectangle2D>> entries) {
        for (Map.Entry<T, Rectangle2D> entry : entries) {
            this.map.put(entry.getKey(), entry.getValue());
        }
    }

    LeafNode(Map.Entry<T, Rectangle2D> entry) {
        this.map.put(entry.getKey(), entry.getValue());
    }

    LeafNode(T element, Rectangle2D bounds) {
        this.map.put(element, bounds);
    }

    private LeafNode() {
    }

    public Node<T> add(SplitterContext<T> splitterContext, Map.Entry<T, Rectangle2D> ... entries) {
        Node<T> top = this;
        for (Map.Entry<T, Rectangle2D> entry : entries) {
            top = this.add(splitterContext, entry.getKey(), entry.getValue());
        }
        return top;
    }

    @Override
    public Node<T> add(SplitterContext<T> splitterContext, T element, Rectangle2D bounds) {
        if (this.size() > 10) {
            Pair pair = splitterContext.leafSplitter.split(this.map.entrySet(), new AbstractMap.SimpleEntry<T, Rectangle2D>(element, bounds));
            if (this.parent.isPresent()) {
                InnerNode innerNodeParent = (InnerNode)this.parent.get();
                innerNodeParent.removeNode(this);
                return innerNodeParent.add(splitterContext, (Node)pair.left, (Node)pair.right);
            }
            InnerNode<T> newParent = InnerNode.create((Node)pair.left);
            return newParent.add(splitterContext, new Node[]{(Node)pair.right});
        }
        this.map.put(element, bounds);
        return this.parent.orElse(this);
    }

    @Override
    public boolean isLeafChildren() {
        return false;
    }

    @Override
    public Node<T> remove(T element) {
        log.trace("LeafNode wants to remove {}", element);
        if (this.map.containsKey(element)) {
            this.map.remove(element);
            if (this.parent.isPresent()) {
                InnerNode parentNode = (InnerNode)this.parent.get();
                if (this.map.size() == 0) {
                    parentNode.removeNode(this);
                }
                return parentNode.recalculateBounds();
            }
            log.trace("no parent? return this {}", (Object)this);
            return this;
        }
        return null;
    }

    @Override
    public Node<T> recalculateBounds() {
        if (this.parent.isPresent()) {
            return ((Node)this.parent.get()).recalculateBounds();
        }
        return this;
    }

    public Rectangle2D getBoundsFor(T element) {
        return (Rectangle2D)this.map.get(element);
    }

    public Node<T> add(SplitterContext<T> splitterContext, Map.Entry<T, Rectangle2D> entry) {
        return this.add(splitterContext, entry.getKey(), entry.getValue());
    }

    public boolean contains(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public int size() {
        return this.map.size();
    }

    Collection<T> getKeys() {
        return this.map.keySet();
    }

    @Override
    public LeafNode<T> getContainingLeaf(T element) {
        if (this.map.containsKey(element)) {
            return this;
        }
        return null;
    }

    @Override
    public Set<LeafNode<T>> getContainingLeafs(Set<LeafNode<T>> containingLeafs, Point2D p) {
        return this.getContainingLeafs(containingLeafs, p.getX(), p.getY());
    }

    @Override
    public Set<LeafNode<T>> getContainingLeafs(Set<LeafNode<T>> containingLeafs, double x, double y) {
        if (this.getBounds().contains(x, y)) {
            containingLeafs.add(this);
            return containingLeafs;
        }
        return Collections.emptySet();
    }

    @Override
    public Collection<Shape> collectGrids(Collection<Shape> list) {
        list.add(this.getBounds());
        for (Rectangle2D r : this.map.values()) {
            list.add(r);
        }
        log.trace("in leaf {}, added {} so list size now {}", new Object[]{this.hashCode(), this.map.size(), list.size()});
        return list;
    }

    @Override
    public Rectangle2D getBounds() {
        return this.map.getBounds();
    }

    @Override
    public T getPickedObject(Point2D p) {
        T picked = null;
        for (Map.Entry entry : this.map.entrySet()) {
            if (!((Rectangle2D)entry.getValue()).contains(p)) continue;
            picked = (T)entry.getKey();
        }
        return picked;
    }

    @Override
    public Set<T> getVisibleElements(Set<T> visibleElements, Shape shape) {
        if (shape.intersects(this.getBounds())) {
            for (Map.Entry entry : this.map.entrySet()) {
                if (!shape.intersects((Rectangle2D)entry.getValue())) continue;
                visibleElements.add(entry.getKey());
            }
        }
        log.trace("visibleElements of LeafNode inside {} are {}", (Object)shape, visibleElements);
        return visibleElements;
    }

    @Override
    public int count() {
        return this.size();
    }

    @Override
    public String asString(String margin) {
        StringBuilder s = new StringBuilder();
        s.append(margin);
        s.append("LeafNode:");
        s.append("parent:");
        s.append(this.parent.isPresent() ? "yes" : "none");
        s.append(" bounds=");
        s.append(Node.asString(this.getBounds()));
        s.append('\n');
        for (Map.Entry entry : this.map.entrySet()) {
            s.append(margin);
            s.append("   ");
            s.append("entry=");
            s.append(LeafNode.asString(entry));
            s.append('\n');
        }
        return s.toString();
    }

    private static <T> String asString(Map.Entry<T, Rectangle2D> entry) {
        return entry.getKey() + "->" + Node.asString(entry.getValue());
    }

    @Override
    public Collection<? extends TreeNode> getChildren() {
        return Collections.emptySet();
    }

    public String toString() {
        return this.asString("");
    }
}

