/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization.spatial.rtree;

import edu.uci.ics.jung.visualization.spatial.rtree.Bounded;
import edu.uci.ics.jung.visualization.spatial.rtree.BoundedMap;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeMap<N>
extends HashMap<N, Rectangle2D>
implements BoundedMap<N>,
Bounded {
    private static final Logger log = LoggerFactory.getLogger(NodeMap.class);
    private Rectangle2D bounds;

    public NodeMap() {
    }

    public NodeMap(int initialCapacity) {
        super(initialCapacity);
    }

    public NodeMap(Map<N, Rectangle2D> map) {
        super(map);
        this.recalculateBounds();
    }

    public void put(Map.Entry<N, Rectangle2D> entry) {
        this.put(entry.getKey(), entry.getValue());
    }

    @Override
    public Rectangle2D put(N n, Rectangle2D b) {
        this.addBoundsFor(b);
        return super.put(n, b);
    }

    @Override
    public Rectangle2D remove(Object o) {
        Rectangle2D removed = (Rectangle2D)super.remove(o);
        this.recalculateBounds();
        return removed;
    }

    @Override
    public void clear() {
        super.clear();
        this.bounds = null;
    }

    @Override
    public Rectangle2D getBounds() {
        if (this.bounds == null) {
            return new Rectangle2D.Double();
        }
        return this.bounds;
    }

    private void addBoundsFor(Map<? extends N, Rectangle2D> kids) {
        for (Map.Entry<N, Rectangle2D> kid : kids.entrySet()) {
            this.addBoundsFor(kid.getValue());
        }
    }

    private void addBoundsFor(Rectangle2D r) {
        this.bounds = this.bounds == null ? r : this.bounds.createUnion(r);
    }

    @Override
    public void recalculateBounds() {
        this.bounds = null;
        for (Rectangle2D r : this.values()) {
            this.addBoundsFor(r);
        }
    }
}

