/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization.spatial.rtree;

import com.google.common.collect.Lists;
import edu.uci.ics.jung.visualization.spatial.rtree.AbstractSplitter;
import edu.uci.ics.jung.visualization.spatial.rtree.HorizontalEdgeNodeComparator;
import edu.uci.ics.jung.visualization.spatial.rtree.InnerNode;
import edu.uci.ics.jung.visualization.spatial.rtree.Node;
import edu.uci.ics.jung.visualization.spatial.rtree.Pair;
import edu.uci.ics.jung.visualization.spatial.rtree.Splitter;
import edu.uci.ics.jung.visualization.spatial.rtree.VerticalEdgeNodeComparator;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RStarSplitter<T>
extends AbstractSplitter<T>
implements Splitter<T> {
    private static Logger log = LoggerFactory.getLogger(RStarSplitter.class);
    private Comparator<Node<T>> horizontalEdgeComparator = new HorizontalEdgeNodeComparator();
    private Comparator verticalEdgeComparator = new VerticalEdgeNodeComparator();

    @Override
    public Pair<InnerNode<T>> split(List<Node<T>> children, Node<T> newEntry) {
        return this.chooseSplitNodes(children, newEntry);
    }

    private Pair<InnerNode<T>> chooseSplitNodes(Collection<Node<T>> entries, Node<T> newEntry) {
        Pair<List<Node<T>>> pair = this.chooseSplit(entries, newEntry);
        InnerNode innerNodeLeft = InnerNode.create((Collection)pair.left);
        InnerNode innerNodeRight = InnerNode.create((Collection)pair.right);
        return Pair.of(innerNodeLeft, innerNodeRight);
    }

    private Pair<List<Node<T>>> chooseSplit(Collection<Node<T>> entries, Node<T> newEntry) {
        ArrayList xAxisList = Lists.newArrayList(entries);
        xAxisList.add(newEntry);
        ArrayList yAxisList = Lists.newArrayList(entries);
        yAxisList.add(newEntry);
        xAxisList.sort(this.horizontalEdgeComparator);
        yAxisList.sort(this.verticalEdgeComparator);
        ArrayList horizontalGroup = Lists.newArrayList();
        ArrayList verticalGroup = Lists.newArrayList();
        for (int k = 0; k < 4; ++k) {
            horizontalGroup.add(Pair.of(xAxisList.subList(0, 3 + k), xAxisList.subList(3 + k, xAxisList.size())));
            verticalGroup.add(Pair.of(yAxisList.subList(0, 3 + k), yAxisList.subList(3 + k, yAxisList.size())));
        }
        int sumXMarginValue = 0;
        for (Pair pair : horizontalGroup) {
            sumXMarginValue = (int)((double)sumXMarginValue + Node.nodeMargin((Collection)pair.left, (Collection)pair.right));
        }
        int sumYMarginValue = 0;
        for (Pair pair : verticalGroup) {
            sumYMarginValue = (int)((double)sumYMarginValue + Node.nodeMargin((Collection)pair.left, (Collection)pair.right));
        }
        if (sumXMarginValue < sumYMarginValue) {
            return this.chooseSplitIndex(horizontalGroup);
        }
        return this.chooseSplitIndex(verticalGroup);
    }

    private Pair<List<Node<T>>> chooseSplitIndex(List<Pair<List<Node<T>>>> group) {
        double minOverlap = 0.0;
        double minArea = 0.0;
        Optional<Object> winner = Optional.empty();
        for (Pair<List<Node<T>>> pair : group) {
            double nodeOverlap = Node.nodeOverlap((Collection)pair.left, (Collection)pair.right);
            double nodeArea = Node.nodeArea((Collection)pair.left, (Collection)pair.right);
            if (!winner.isPresent()) {
                minOverlap = nodeOverlap;
                minArea = nodeArea;
                winner = Optional.of(pair);
                continue;
            }
            if (nodeOverlap == minOverlap) {
                if (!(nodeArea < minArea)) continue;
                minOverlap = nodeOverlap;
                minArea = nodeArea;
                winner = Optional.of(pair);
                continue;
            }
            if (!(nodeOverlap < minOverlap)) continue;
            minOverlap = nodeOverlap;
            minArea = nodeArea;
            winner = Optional.of(pair);
        }
        return winner.orElse(null);
    }

    @Override
    public Optional<Node<T>> chooseSubtree(InnerNode<T> nodeToSplit, T element, Rectangle2D bounds) {
        if (nodeToSplit.isLeafChildren()) {
            return this.leastOverlapThenEnlargementThenAreaThenKids(nodeToSplit, bounds);
        }
        return this.leastEnlargementThenAreaThenKids(nodeToSplit, bounds);
    }
}

