/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization.spatial.rtree;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import edu.uci.ics.jung.visualization.spatial.TreeNode;
import edu.uci.ics.jung.visualization.spatial.rtree.InnerNode;
import edu.uci.ics.jung.visualization.spatial.rtree.LeafNode;
import edu.uci.ics.jung.visualization.spatial.rtree.Node;
import edu.uci.ics.jung.visualization.spatial.rtree.SplitterContext;
import java.awt.Shape;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RTree<T> {
    private static final Logger log = LoggerFactory.getLogger(RTree.class);
    private final Optional<Node<T>> root;
    private static final String marginIncrement = "   ";

    public Optional<Node<T>> getRoot() {
        return this.root;
    }

    private RTree() {
        this.root = Optional.empty();
    }

    private RTree(Node<T> node) {
        Preconditions.checkArgument((!node.getParent().isPresent() ? 1 : 0) != 0, (Object)"Error creating R-Tree with root that has parent");
        this.root = Optional.of(node);
    }

    public static <T> RTree<T> create() {
        return new RTree<T>();
    }

    public RTree<T> add(SplitterContext<T> splitterContext, T element, Rectangle2D bounds) {
        if (!this.root.isPresent()) {
            return new RTree<T>(LeafNode.create(element, bounds));
        }
        Node<T> node = this.root.get();
        if (node instanceof LeafNode) {
            LeafNode leafNode = (LeafNode)node;
            Node<T> got = leafNode.add(splitterContext, element, bounds);
            Preconditions.checkArgument((!got.getParent().isPresent() ? 1 : 0) != 0, (Object)"return from LeafNode add has a parent");
            return new RTree<T>(got);
        }
        InnerNode innerNode = (InnerNode)node;
        Node<T> got = innerNode.add(splitterContext, element, bounds);
        Preconditions.checkArgument((!got.getParent().isPresent() ? 1 : 0) != 0, (Object)"return from InnerNode add has a parent");
        return new RTree<T>(got);
    }

    public RTree<T> remove(T element) {
        log.trace("want to remove {} from tree of size {}", element, (Object)this.count());
        if (!this.root.isPresent()) {
            return new RTree<T>();
        }
        Node<T> rootNode = this.root.get();
        Node<T> newRoot = rootNode.remove(element);
        return new RTree<T>(newRoot);
    }

    public T getPickedObject(Point2D p) {
        Node<T> root = this.root.get();
        if (root instanceof LeafNode) {
            LeafNode leafNode = (LeafNode)root;
            return leafNode.getPickedObject(p);
        }
        if (root instanceof InnerNode) {
            InnerNode innerNode = (InnerNode)root;
            return innerNode.getPickedObject(p);
        }
        return null;
    }

    public Set<Shape> getGrid() {
        HashSet areas = Sets.newHashSet();
        if (this.root.isPresent()) {
            Node<T> node = this.root.get();
            node.collectGrids(areas);
        }
        return areas;
    }

    public Collection<TreeNode> getContainingLeafs(Point2D p) {
        if (this.root.isPresent()) {
            Node<T> theRoot = this.root.get();
            if (theRoot instanceof LeafNode) {
                return Collections.singleton(theRoot);
            }
            if (theRoot instanceof InnerNode) {
                return ((InnerNode)theRoot).getContainingLeafs(Sets.newHashSet(), p);
            }
        }
        return Collections.emptySet();
    }

    public int count() {
        int count = 0;
        if (this.root.isPresent()) {
            Node<T> node = this.root.get();
            count += node.count();
        }
        return count;
    }

    private String asString() {
        if (this.root.isPresent()) {
            return this.root.get().asString("");
        }
        return "Empty RTree";
    }

    private static String asString(Rectangle2D r) {
        return "[" + (int)r.getX() + "," + (int)r.getY() + "," + (int)r.getWidth() + "," + (int)r.getHeight() + "]";
    }

    private static <T> String asString(Collection<RTree<T>> trees) {
        StringBuilder sb = new StringBuilder();
        for (RTree<T> tree : trees) {
            if (sb.length() > 0) {
                sb.append('\n');
            }
            sb.append(super.asString());
        }
        return sb.toString();
    }

    private static <T> String asString(Map<T, Rectangle2D> map) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<T, Rectangle2D> entry : map.entrySet()) {
            if (sb.length() > 0) {
                sb.append('\n');
            }
            sb.append(RTree.asString(entry));
        }
        return sb.toString();
    }

    private static <T> String asString(Map.Entry<T, Rectangle2D> entry) {
        return entry.getKey() + "->" + RTree.asString(entry.getValue());
    }

    public String toString() {
        return this.asString();
    }
}

